# Nursing Minimum Data Set - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Nursing Minimum Data Set**

## NamingSystem: Nursing Minimum Data Set 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/nmds | *Version*:2.1.0 |
| Retired as of 2021-11-09 | *Computable Name*:Nmds |

 
The NMDS is the minimum set of items of information with uniform definitions and categories concerning the specific dimension of the context of patient care delivery. It represents the minimum data used to support the management and administration of patient/nursing care delivery across all types of settings. 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "nmds",
  "url" : "http://terminology.hl7.org/NamingSystem/nmds",
  "version" : "2.1.0",
  "name" : "Nmds",
  "title" : "Nursing Minimum Data Set",
  "status" : "retired",
  "kind" : "codesystem",
  "date" : "2021-11-09T10:00:00+10:00",
  "description" : "The NMDS is the minimum set of items of information with uniform definitions and categories concerning the specific dimension of the context of patient care delivery. It represents the minimum data used to support the management and administration of patient/nursing care delivery across all types of settings.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.87",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/nmds",
      "preferred" : true
    }
  ]
}

```
