# All Patient Diagnosis Related Groups (AP DRGs) - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **All Patient Diagnosis Related Groups (AP DRGs)**

## NamingSystem: All Patient Diagnosis Related Groups (AP DRGs) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/apdrg | *Version*:1.0.0 | |
| Active as of 2020-11-12 | *Responsible:*[3M Health Information Systems, Inc.](http://www.3mhis.com) | *Computable Name*:APDRG |

 
In 1987, the state of New York passed legislation instituting a DRG-based prospective payment system for all non-Medicare patients. The legislation included a requirement that the New York State Department of Health (NYDH) evaluate the applicability of the DRGs to a non-Medicare population. In particular, the legislation required that the DRGs be evaluated with respect to neonates and patients with Human Immunodeficiency Virus (HIV) infections. NYDH entered into an agreement with 3M HIS to assist with the evaluation of the need for DRG modifications as well as to make the necessary changes in the DRG definitions and software. The DRG definitions developed by NYDH and 3M HIS are referred to as the All Patient DRGs (AP DRGs). 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "apdrg",
  "url" : "http://terminology.hl7.org/NamingSystem/apdrg",
  "version" : "1.0.0",
  "name" : "APDRG",
  "title" : "All Patient Diagnosis Related Groups (AP DRGs)",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2020-11-12T00:00:00-04:00",
  "publisher" : "3M Health Information Systems, Inc.",
  "contact" : [
    {
      "name" : "3M Health Information Systems, Inc.; 575 West Murray Boulevard, Salt Lake City, UT 84123, USA",
      "telecom" : [
        {
          "system" : "phone",
          "value" : "+1 800 367 2447"
        },
        {
          "system" : "url",
          "value" : "http://www.3mhis.com"
        }
      ]
    }
  ],
  "responsible" : "3M Health Information Systems, Inc.",
  "description" : "In 1987, the state of New York passed legislation instituting a DRG-based prospective payment system for all non-Medicare patients. The legislation included a requirement that the New York State Department of Health (NYDH) evaluate the applicability of the DRGs to a non-Medicare population. In particular, the legislation required that the DRGs be evaluated with respect to neonates and patients with Human Immunodeficiency Virus (HIV) infections. NYDH entered into an agreement with 3M HIS to assist with the evaluation of the need for DRG modifications as well as to make the necessary changes in the DRG definitions and software. The DRG definitions developed by NYDH and 3M HIS are referred to as the All Patient DRGs (AP DRGs).",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://uri.hddaccess.com/cs/apdrg",
      "preferred" : true
    }
  ]
}

```
