# Nomenclature for Properties and Units (NPU) - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Nomenclature for Properties and Units (NPU)**

## NamingSystem: Nomenclature for Properties and Units (NPU) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/NPU | *Version*:1.0.0 | |
| Active as of 2024-11-06 | *Responsible:*Danish National eHealth Authority | *Computable Name*:NomenclatureForPropertiesAndUnits |
| **Copyright/Legal**: https://cms.npu-terminology.org/wp-content/uploads/2024/06/NPU-License-Terms-of-Use.pdf | | |

 
The NPU terminology is a coding system and terminology for identification and communication of examinations for ordering and reporting results between clinical laboratories and laboratory information systems, hospital patient records, general practitioners (GP) and local and national data repositories. 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "NPU",
  "url" : "http://terminology.hl7.org/NamingSystem/NPU",
  "version" : "1.0.0",
  "name" : "NomenclatureForPropertiesAndUnits",
  "title" : "Nomenclature for Properties and Units (NPU)",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2024-11-06T13:00:00+10:00",
  "publisher" : "Danish National eHealth Authority",
  "contact" : [
    {
      "name" : "Danish National eHealth Authority"
    }
  ],
  "description" : "The NPU terminology is a coding system and terminology for identification and communication of examinations for ordering and reporting results between clinical laboratories and laboratory information systems, hospital patient records, general practitioners (GP) and local and national data repositories.",
  "copyright" : "https://cms.npu-terminology.org/wp-content/uploads/2024/06/NPU-License-Terms-of-Use.pdf",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://npu-terminology.org",
      "preferred" : true,
      "comment" : "This is the URL endorsed by the TSMG and is considered authoritative.",
      "period" : {
        "start" : "2024-11-06"
      }
    }
  ]
}

```
