# NCPDP Prescription Origin Code - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NCPDP Prescription Origin Code**

## NamingSystem: NCPDP Prescription Origin Code 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/NCPDPPrescriptionOriginCode | *Version*:1.0.1 | |
| Active as of 2021-03-10 | *Responsible:*National Council for Prescription Drug Programs | *Computable Name*:NCPDPPrescriptionOriginCode |

 
Code indicating the origin of the prescription. Indicates whether the prescription was transmitted as an electronic prescription, by phone, by fax, or as a written paper copy. 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "NCPDPPrescriptionOriginCode",
  "url" : "http://terminology.hl7.org/NamingSystem/NCPDPPrescriptionOriginCode",
  "version" : "1.0.1",
  "name" : "NCPDPPrescriptionOriginCode",
  "title" : "NCPDP Prescription Origin Code",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2021-03-10T00:00:00-04:00",
  "publisher" : "National Council for Prescription Drug Programs",
  "contact" : [
    {
      "name" : "National Council for Prescription Drug Programs",
      "telecom" : [
        {
          "system" : "phone",
          "value" : "480.477.1000"
        },
        {
          "system" : "email",
          "value" : "info@ncpdp.org"
        }
      ]
    }
  ],
  "responsible" : "National Council for Prescription Drug Programs",
  "description" : "Code indicating the origin of the prescription. Indicates whether the prescription was transmitted as an electronic prescription, by phone, by fax, or as a written paper copy.",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/NCPDPPrescriptionOriginCode",
      "preferred" : true
    }
  ]
}

```
