# Human Phenotype Ontology - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Human Phenotype Ontology**

## NamingSystem: Human Phenotype Ontology 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/HPO | *Version*:1.0.0 |
| Active as of 2022-06-02 | *Computable Name*:HPO |
| **Copyright/Legal**: The HPO vocabularies, annotation files, tools, and documentation are freely available.The HPO is copyrighted to protect the integrity of the vocabularies, which means that changes to the HPO vocabularies need to be done by HPO developers. However, anyone can download the HPO and use the ontologies or other HPO files under three conditions:The Human Phenotype Ontology Consortium is acknowledged and [cited properly](https://hpo.jax.org/app/citation). Any HPO Consortium file(s) displayed publicly include the date(s) and/or version number(s) of the relevant HPO file(s). Neither the content of the HPO file(s) nor the logical relationships embedded within the HPO file(s) be altered in any way. (Content additions and modifications have to be suggested using our [issue tracker](https://github.com/obophenotype/human-phenotype-ontology/issues).)Users of the HPO should add the following statement to their online presence: This service/product uses the Human Phenotype Ontology (version information). Find out more at [http://www.human-phenotype-ontology.org](http://www.human-phenotype-ontology.org). We request that the HPO logo be included as well. | |

 
"The Human Phenotype Ontology (HPO) provides a standardized vocabulary of phenotypic abnormalities encountered in human disease. Each term in the HPO describes a phenotypic abnormality, such as Atrial septal defect. The HPO is currently being developed using the medical literature, Orphanet, DECIPHER, and OMIM. HPO currently contains over 13,000 terms and over 156,000 annotations to hereditary diseases. The HPO project and others have developed software for phenotype-driven differential diagnostics, genomic diagnostics, and translational research. The HPO is a flagship product of the Monarch Initiative, an NIH-supported international consortium dedicated to semantic integration of biomedical and model organism data with the ultimate goal of improving biomedical research. The HPO, as a part of the Monarch Initiative, is a central component of one of the 13 driver projects in the Global Alliance for Genomics and Health (GA4GH) strategic roadmap." 
Please see https://hpo.jax.org/app/download/ontology. 
Releases, produced approximately every 2 months, can be found [here](https://github.com/obophenotype/human-phenotype-ontology/releases). 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "HPO",
  "url" : "http://terminology.hl7.org/NamingSystem/HPO",
  "version" : "1.0.0",
  "name" : "HPO",
  "title" : "Human Phenotype Ontology",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2022-06-02T00:00:00-00:00",
  "contact" : [
    {
      "name" : "Peter Robinson or Melissa Haendel, The Monarch Initiative",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.human-phenotype-ontology.org/"
        }
      ]
    }
  ],
  "description" : "\"The Human Phenotype Ontology (HPO) provides a standardized vocabulary of phenotypic abnormalities encountered in human disease. Each term in the HPO describes a phenotypic abnormality, such as Atrial septal defect. The HPO is currently being developed using the medical literature, Orphanet, DECIPHER, and OMIM. HPO currently contains over 13,000 terms and over 156,000 annotations to hereditary diseases. The HPO project and others have developed software for phenotype-driven differential diagnostics, genomic diagnostics, and translational research. The HPO is a flagship product of the Monarch Initiative, an NIH-supported international consortium dedicated to semantic integration of biomedical and model organism data with the ultimate goal of improving biomedical research. The HPO, as a part of the Monarch Initiative, is a central component of one of the 13 driver projects in the Global Alliance for Genomics and Health (GA4GH) strategic roadmap.\"\r\n\r\nPlease see https://hpo.jax.org/app/download/ontology.\r\n\r\nReleases, produced approximately every 2 months, can be found [here](https://github.com/obophenotype/human-phenotype-ontology/releases).",
  "copyright" : "The HPO vocabularies, annotation files, tools, and documentation are freely available.\n\nThe HPO is copyrighted to protect the integrity of the vocabularies, which means that changes to the HPO vocabularies need to be done by HPO developers. However, anyone can download the HPO and use the ontologies or other HPO files under three conditions:\n\nThe Human Phenotype Ontology Consortium is acknowledged and [cited properly](https://hpo.jax.org/app/citation).\nAny HPO Consortium file(s) displayed publicly include the date(s) and/or version number(s) of the relevant HPO file(s).\nNeither the content of the HPO file(s) nor the logical relationships embedded within the HPO file(s) be altered in any way. (Content additions and modifications have to be suggested using our [issue tracker](https://github.com/obophenotype/human-phenotype-ontology/issues).)\n\nUsers of the HPO should add the following statement to their online presence: This service/product uses the Human Phenotype Ontology (version information). Find out more at [http://www.human-phenotype-ontology.org](http://www.human-phenotype-ontology.org). We request that the HPO logo be included as well.",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://human-phenotype-ontology.org",
      "preferred" : true,
      "comment" : "This is the URL as specified by the terminology owner, and is considered authoritative.",
      "period" : {
        "start" : "2022-06-02"
      }
    },
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.339",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://purl.obolibrary.org/obo/hp.owl",
      "preferred" : false,
      "period" : {
        "start" : "2022-06-02"
      }
    }
  ]
}

```
