# American Dental Association Tooth Surface Codes - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **American Dental Association Tooth Surface Codes**

## NamingSystem: American Dental Association Tooth Surface Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/ADAToothSurfaceCodes | *Version*:1.0.0 | |
| Active as of 2024-08-28 | *Responsible:*American Dental Association | *Computable Name*:ADAToothSurfaceCodes |
| **Copyright/Legal**: No official copyright statement is available. For general information see paper form located here : [https://www.ada.org/-/media/project/ada-organization/ada/ada-org/files/publications/cdt/v2019adadentalclaimcompletioninstructions_v3_2022feb.pdf](https://www.ada.org/-/media/project/ada-organization/ada/ada-org/files/publications/cdt/v2019adadentalclaimcompletioninstructions_v3_2022feb.pdf) | | |

 
Tooth Surface Codes are defined by the HIPAA standard electronic dental claim transaction (837D v5010) and the ADA Dental Claim Form. Surface codes can be used in a variety of combinations to define a multi-surface procedure (ie. MOD for a singular intervention which covers Mesial, Occlusal, and Distal surfaces). Tooth Surface Codes can be accessed through the [ADA Guide to Dental Procedures Reported with Area of the Oral Cavity or Tooth Anatomy (or Both).](https://www.ada.org/-/media/project/ada-organization/ada/ada-org/files/publications/cdt/final_areaoftheoralcavityandtoothanatomy.pdf?rev=fbd215c7d8c546aa967443e79f9d8e20&hash=2F759947EFD75EF5ABCCBF0F62CE1FE7). 
A Statement of Understanding (SOU) between ADA and HL7 exists [here](http://www.hl7.org/documentcenter/public/mou/ADA%20HL7%20SOU%202021_signed.pdf). 



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "ADAToothSurfaceCodes",
  "url" : "http://terminology.hl7.org/NamingSystem/ADAToothSurfaceCodes",
  "version" : "1.0.0",
  "name" : "ADAToothSurfaceCodes",
  "title" : "American Dental Association Tooth Surface Codes",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2024-08-28T00:00:00-00:00",
  "publisher" : "American Dental Association",
  "contact" : [
    {
      "name" : "American Dental Association; 211 East Chicago Avenue Chicago, IL 60610-2678"
    }
  ],
  "description" : "Tooth Surface Codes are defined by the HIPAA standard electronic dental claim transaction (837D v5010) and the ADA Dental Claim Form.   Surface codes can be used in a variety of combinations to define a multi-surface procedure (ie. MOD for a singular intervention which covers Mesial, Occlusal, and Distal surfaces).   Tooth Surface Codes can be accessed through the [ADA Guide to Dental Procedures Reported with Area of the Oral Cavity or Tooth Anatomy (or Both).](https://www.ada.org/-/media/project/ada-organization/ada/ada-org/files/publications/cdt/final_areaoftheoralcavityandtoothanatomy.pdf?rev=fbd215c7d8c546aa967443e79f9d8e20&hash=2F759947EFD75EF5ABCCBF0F62CE1FE7). \r\n\r\nA Statement of Understanding (SOU) between ADA and HL7 exists [here](http://www.hl7.org/documentcenter/public/mou/ADA%20HL7%20SOU%202021_signed.pdf).",
  "copyright" : "No official copyright statement is available. For general information see paper form located here : [https://www.ada.org/-/media/project/ada-organization/ada/ada-org/files/publications/cdt/v2019adadentalclaimcompletioninstructions_v3_2022feb.pdf](https://www.ada.org/-/media/project/ada-organization/ada/ada-org/files/publications/cdt/v2019adadentalclaimcompletioninstructions_v3_2022feb.pdf)",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/ADAToothSurfaceCodes",
      "preferred" : true,
      "comment" : "This is the URL endorsed by the TSMG and is considered authoritative.",
      "period" : {
        "start" : "2024-08-28"
      }
    }
  ]
}

```
