# FHIR Rendering Manifest - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **FHIR Rendering Manifest**

## List: FHIR Rendering Manifest

## FHIR Rendering Manifest

| | | |
| :--- | :--- | :--- |
| Mode: Working List | Status: Current | Code: UTG Control Manifest |
| Order: Sorted Alphabetically | | |

* **Items**: [CodeSystem Accepting Patients](CodeSystem-accepting-patients.md)
* **Items**: [CodeSystem Care Service Accessibility](CodeSystem-care-service-accessibility.md)
* **Items**: [CodeSystem Adjudication Error Codes](CodeSystem-adjudication-error.md)
* **Items**: [CodeSystem Artifact Version Policy Codes](CodeSystem-artifact-version-policy-codes.md)
* **Items**: [CodeSystem DataAbsentReason](CodeSystem-data-absent-reason.md)
* **Items**: [CodeSystem Artifact Identifier Type Codes](CodeSystem-artifact-identifier-type.md)
* **Items**: [CodeSystem Diagnosis Role](CodeSystem-diagnosis-role.md)
* **Items**: [CodeSystem Form Codes](CodeSystem-forms-codes.md)
* **Items**: [CodeSystem Funds Reservation Codes](CodeSystem-fundsreserve.md)
* **Items**: [CodeSystem Payee Type Codes](CodeSystem-payeetype.md)
* **Items**: [CodeSystem SpecialValues](CodeSystem-special-values.md)
* **Items**: [CodeSystem StatisticSynthesisType](CodeSystem-synthesis-type.md)
* **Items**: [CodeSystem StatisticStudyType](CodeSystem-study-type.md)
* **Items**: [CodeSystem StatisticStatisticType](CodeSystem-statistic-type.md)
* **Items**: [CodeSystem StatisticAttribute Estimate Type](CodeSystem-attribute-estimate-type.md)
* **Items**: [CodeSystem StatisticCertaintyRating](CodeSystem-certainty-rating.md)
* **Items**: [CodeSystem StatisticCertaintySubcomponentType](CodeSystem-certainty-subcomponent-type.md)
* **Items**: [CodeSystem StatisticCertaintySubcomponentRating](CodeSystem-certainty-subcomponent-rating.md)
* **Items**: [CodeSystem Common Tags](CodeSystem-common-tags.md)
* **Items**: [CodeSystem UsageContextType](CodeSystem-usage-context-type.md)
* **Items**: [CodeSystem DoseAndRateType](CodeSystem-dose-rate-type.md)
* **Items**: [CodeSystem DefinitionStatus](CodeSystem-definition-status.md)
* **Items**: [CodeSystem Flag Category](CodeSystem-flag-category.md)
* **Items**: [CodeSystem AllergyIntolerance Verification Status](CodeSystem-allergyintolerance-verification.md)
* **Items**: [CodeSystem AllergyIntolerance Clinical Status Codes](CodeSystem-allergyintolerance-clinical.md)
* **Items**: [CodeSystem Basic Resource Types](CodeSystem-basic-resource-type.md)
* **Items**: [CodeSystem Condition Category Codes](CodeSystem-condition-category.md)
* **Items**: [CodeSystem Condition Clinical Status Codes](CodeSystem-condition-clinical.md)
* **Items**: [CodeSystem ConditionVerificationStatus](CodeSystem-condition-ver-status.md)
* **Items**: [CodeSystem CommunicationCategory](CodeSystem-communication-category.md)
* **Items**: [CodeSystem CommunicationNotDoneReason](CodeSystem-communication-not-done-reason.md)
* **Items**: [CodeSystem CommunicationTopic](CodeSystem-communication-topic.md)
* **Items**: [CodeSystem CRD Coverage Detail Codes](CodeSystem-crd-coverage-detail.md)
* **Items**: [CodeSystem FHIRDeviceStatusReason](CodeSystem-device-status-reason.md)
* **Items**: [CodeSystem DeviceAssociation Relationship Codes](CodeSystem-deviceassociation-relationship.md)
* **Items**: [CodeSystem DeviceAssociation Status Reason Codes](CodeSystem-deviceassociation-status-reason.md)
* **Items**: [CodeSystem sequenceStatus](CodeSystem-variant-state.md)
* **Items**: [CodeSystem chromosome-human](CodeSystem-chromosome-human.md)
* **Items**: [CodeSystem CopyNumberEvent](CodeSystem-copy-number-event.md)
* **Items**: [CodeSystem Encounter type](CodeSystem-encounter-type.md)
* **Items**: [CodeSystem Participant type](CodeSystem-participant-type.md)
* **Items**: [CodeSystem Special arrangements](CodeSystem-encounter-special-arrangements.md)
* **Items**: [CodeSystem Diet](CodeSystem-diet.md)
* **Items**: [CodeSystem Admit source](CodeSystem-admit-source.md)
* **Items**: [CodeSystem Discharge disposition](CodeSystem-discharge-disposition.md)
* **Items**: [CodeSystem Encounter subject status](CodeSystem-encounter-subject-status.md)
* **Items**: [CodeSystem FamilyHistoryAbsentReason](CodeSystem-history-absent-reason.md)
* **Items**: [CodeSystem Goal priority](CodeSystem-goal-priority.md)
* **Items**: [CodeSystem Goal category](CodeSystem-goal-category.md)
* **Items**: [CodeSystem Goal achievement status](CodeSystem-goal-achievement.md)
* **Items**: [CodeSystem NDH Healthcare Service Category](CodeSystem-ndh-healthcare-service-category.md)
* **Items**: [CodeSystem Immunization Subpotent Reason](CodeSystem-immunization-subpotent-reason.md)
* **Items**: [CodeSystem Immunization Program Eligibility](CodeSystem-immunization-program-eligibility.md)
* **Items**: [CodeSystem Immunization Funding Source](CodeSystem-immunization-funding-source.md)
* **Items**: [CodeSystem Immunization Origin Codes](CodeSystem-immunization-origin.md)
* **Items**: [CodeSystem Immunization Evaluation Dose Status codes](CodeSystem-immunization-evaluation-dose-status.md)
* **Items**: [CodeSystem Immunization Evaluation Dose Status Reason codes](CodeSystem-immunization-evaluation-dose-status-reason.md)
* **Items**: [CodeSystem Immunization Recommendation Status Codes](CodeSystem-immunization-recommendation-status.md)
* **Items**: [CodeSystem GuideParameterCode](CodeSystem-guide-parameter-code.md)
* **Items**: [CodeSystem Example Use Codes for List](CodeSystem-list-example-use-codes.md)
* **Items**: [CodeSystem List Empty Reasons](CodeSystem-list-empty-reason.md)
* **Items**: [CodeSystem List Order Codes](CodeSystem-list-order.md)
* **Items**: [CodeSystem Location type](CodeSystem-location-physical-type.md)
* **Items**: [CodeSystem Reason Medication Given Codes](CodeSystem-reason-medication-given.md)
* **Items**: [CodeSystem MedicationAdministration Location Codes](CodeSystem-medication-admin-location.md)
* **Items**: [CodeSystem MedicationAdministration Performer Function Codes](CodeSystem-med-admin-perform-function.md)
* **Items**: [CodeSystem MedicationDispense Performer Function Codes](CodeSystem-medicationdispense-performer-function.md)
* **Items**: [CodeSystem Medication request administration location codes](CodeSystem-medicationrequest-admin-location.md)
* **Items**: [CodeSystem MedicationRequest Status Reason Codes](CodeSystem-medicationrequest-status-reason.md)
* **Items**: [CodeSystem MedicationRequest Course of Therapy Codes](CodeSystem-medicationrequest-course-of-therapy.md)
* **Items**: [CodeSystem MedicationRequest Category Codes](CodeSystem-medicationrequest-category.md)
* **Items**: [CodeSystem MedicationUsage Administration Location Codes](CodeSystem-medication-usage-admin-location.md)
* **Items**: [CodeSystem Example Message Reason Codes](CodeSystem-message-reasons-encounter.md)
* **Items**: [CodeSystem Nutrition intake category codes](CodeSystem-nutrition-intake-category.md)
* **Items**: [CodeSystem Nutrition Intake Status Reason Codes](CodeSystem-nutritionintake-status-reason.md)
* **Items**: [CodeSystem Enteral Formula Additive Type Code](CodeSystem-entformula-additive.md)
* **Items**: [CodeSystem Observation Reference Range Meaning Codes](CodeSystem-referencerange-meaning.md)
* **Items**: [CodeSystem Observation Category Codes](CodeSystem-observation-category.md)
* **Items**: [CodeSystem StatisticsCode](CodeSystem-observation-statistics.md)
* **Items**: [CodeSystem Operation Outcome Codes](CodeSystem-operation-outcome.md)
* **Items**: [CodeSystem Organization type](CodeSystem-organization-type.md)
* **Items**: [CodeSystem Contact entity type](CodeSystem-contactentity-type.md)
* **Items**: [CodeSystem Provenance participant type](CodeSystem-provenance-participant-type.md)
* **Items**: [CodeSystem Practitioner role](CodeSystem-practitioner-role.md)
* **Items**: [CodeSystem Risk Probability](CodeSystem-risk-probability.md)
* **Items**: [CodeSystem AuditEventOutcome](CodeSystem-audit-event-outcome.md)
* **Items**: [CodeSystem Audit event entity type](CodeSystem-audit-entity-type.md)
* **Items**: [CodeSystem AuditEventEntityRole](CodeSystem-object-role.md)
* **Items**: [CodeSystem Audit Event ID](CodeSystem-audit-event-type.md)
* **Items**: [CodeSystem Audit Event Source Type](CodeSystem-security-source-type.md)
* **Items**: [CodeSystem Substance Category Codes](CodeSystem-substance-category.md)
* **Items**: [CodeSystem Appointment cancellation reason](CodeSystem-appointment-cancellation-reason.md)
* **Items**: [CodeSystem Endpoint Payload Type](CodeSystem-endpoint-payload-type.md)
* **Items**: [CodeSystem Endpoint Connection Type](CodeSystem-endpoint-connection-type.md)
* **Items**: [CodeSystem SubscriptionChannel Type Codes](CodeSystem-subscription-channel-type.md)
* **Items**: [CodeSystem SubscriptionTag](CodeSystem-subscription-tag.md)
* **Items**: [CodeSystem Subscription Error Codes](CodeSystem-subscription-error.md)
* **Items**: [CodeSystem ReferralMethod](CodeSystem-service-referral-method.md)
* **Items**: [CodeSystem ServiceProvisionConditions](CodeSystem-service-provision-conditions.md)
* **Items**: [CodeSystem Service category](CodeSystem-service-category.md)
* **Items**: [CodeSystem Service type](CodeSystem-service-type.md)
* **Items**: [CodeSystem Program](CodeSystem-program.md)
* **Items**: [CodeSystem SubscriberPolicyholder Relationship Codes](CodeSystem-subscriber-relationship.md)
* **Items**: [CodeSystem Coverage Class Codes](CodeSystem-coverage-class.md)
* **Items**: [CodeSystem Coverage SelfPay Codes](CodeSystem-coverage-selfpay.md)
* **Items**: [CodeSystem Coverage Copay Type Codes](CodeSystem-coverage-copay-type.md)
* **Items**: [CodeSystem Example Coverage Financial Exception Codes](CodeSystem-ex-coverage-financial-exception.md)
* **Items**: [CodeSystem Missing Tooth Reason Codes](CodeSystem-missingtoothreason.md)
* **Items**: [CodeSystem Modifier type Codes](CodeSystem-modifiers.md)
* **Items**: [CodeSystem Oral Site Codes](CodeSystem-ex-tooth.md)
* **Items**: [CodeSystem USCLS Codes](CodeSystem-ex-USCLS.md)
* **Items**: [CodeSystem Surface Codes](CodeSystem-FDI-surface.md)
* **Items**: [CodeSystem Process Priority Codes](CodeSystem-processpriority.md)
* **Items**: [CodeSystem Claim Type Codes](CodeSystem-claim-type.md)
* **Items**: [CodeSystem Example Service Place Codes](CodeSystem-ex-serviceplace.md)
* **Items**: [CodeSystem Example Claim SubType Codes](CodeSystem-ex-claimsubtype.md)
* **Items**: [CodeSystem Example Related Claim Relationship Codes](CodeSystem-ex-relatedclaimrelationship.md)
* **Items**: [CodeSystem Example Provider Qualification Codes](CodeSystem-ex-providerqualification.md)
* **Items**: [CodeSystem Example Program Reason Codes](CodeSystem-ex-programcode.md)
* **Items**: [CodeSystem Exception Codes](CodeSystem-claim-exception.md)
* **Items**: [CodeSystem Claim Information Category Codes](CodeSystem-claiminformationcategory.md)
* **Items**: [CodeSystem Diagnosis Type Codes](CodeSystem-diagnosistype.md)
* **Items**: [CodeSystem ClaimPayeeResourceType](CodeSystem-ex-payee-resource-type.md)
* **Items**: [CodeSystem Claim Care Team Role Codes](CodeSystem-claimcareteamrole.md)
* **Items**: [CodeSystem Example Diagnosis Related Group Codes](CodeSystem-ex-diagnosisrelatedgroup.md)
* **Items**: [CodeSystem Example Diagnosis Type Codes](CodeSystem-ex-diagnosistype.md)
* **Items**: [CodeSystem Example Revenue Center Codes](CodeSystem-ex-revenue-center.md)
* **Items**: [CodeSystem Example Diagnosis on Admission Codes](CodeSystem-ex-diagnosis-on-admission.md)
* **Items**: [CodeSystem Procedure Type Codes](CodeSystem-procedure-type.md)
* **Items**: [CodeSystem Financial Task Codes](CodeSystem-financialtaskcode.md)
* **Items**: [CodeSystem Financial Task Input Type Codes](CodeSystem-financialtaskinputtype.md)
* **Items**: [CodeSystem Adjudication Value Codes](CodeSystem-adjudication.md)
* **Items**: [CodeSystem Adjudication Reason Codes](CodeSystem-adjudication-reason.md)
* **Items**: [CodeSystem Payment Adjustment Reason Codes](CodeSystem-payment-adjustment-reason.md)
* **Items**: [CodeSystem Benefit Category Codes](CodeSystem-ex-benefitcategory.md)
* **Items**: [CodeSystem Benefit Type Codes](CodeSystem-benefit-type.md)
* **Items**: [CodeSystem Network Type Codes](CodeSystem-benefit-network.md)
* **Items**: [CodeSystem Unit Type Codes](CodeSystem-benefit-unit.md)
* **Items**: [CodeSystem Benefit Term Codes](CodeSystem-benefit-term.md)
* **Items**: [CodeSystem PayeeResourceType](CodeSystem-resource-type-link.md)
* **Items**: [CodeSystem Example Payment Type Codes](CodeSystem-ex-paymenttype.md)
* **Items**: [CodeSystem CoverageEligibilityResponse Auth Support Codes](CodeSystem-coverageeligibilityresponse-ex-auth-support.md)
* **Items**: [CodeSystem Payment Type Codes](CodeSystem-payment-type.md)
* **Items**: [CodeSystem Payment Status Codes](CodeSystem-paymentstatus.md)
* **Items**: [CodeSystem Service Delivery Method](CodeSystem-service-delivery-method.md)
* **Items**: [CodeSystem Example Vision Prescription Product Codes](CodeSystem-ex-visionprescriptionproduct.md)
* **Items**: [CodeSystem Episode of care type](CodeSystem-episodeofcare-type.md)
* **Items**: [CodeSystem Structure Definition Use Codes / Keywords](CodeSystem-definition-use.md)
* **Items**: [CodeSystem Supply Type](CodeSystem-supply-kind.md)
* **Items**: [CodeSystem SupplyRequestReason](CodeSystem-supplyrequest-reason.md)
* **Items**: [CodeSystem Supply Item Type](CodeSystem-supply-item-type.md)
* **Items**: [CodeSystem Test script operation code](CodeSystem-testscript-operation-codes.md)
* **Items**: [CodeSystem Test script profile origin type](CodeSystem-testscript-profile-origin-types.md)
* **Items**: [CodeSystem Test script profile destination type](CodeSystem-testscript-profile-destination-types.md)
* **Items**: [CodeSystem Contract Type Codes](CodeSystem-contract-type.md)
* **Items**: [CodeSystem Contract Subtype Codes](CodeSystem-contractsubtypecodes.md)
* **Items**: [CodeSystem Contract Term Type Codes](CodeSystem-contracttermtypecodes.md)
* **Items**: [CodeSystem Contract Term Subtype Codes](CodeSystem-contracttermsubtypecodes.md)
* **Items**: [CodeSystem Contract Signer Type Codes](CodeSystem-contractsignertypecodes.md)
* **Items**: [CodeSystem Contract Action Codes](CodeSystem-contractaction.md)
* **Items**: [CodeSystem Contract Actor Role Codes](CodeSystem-contractactorrole.md)
* **Items**: [CodeSystem Contract Content Derivation Codes](CodeSystem-contract-content-derivative.md)
* **Items**: [CodeSystem ContractDataMeaning](CodeSystem-contract-data-meaning.md)
* **Items**: [CodeSystem Consent Category Codes](CodeSystem-consentcategorycodes.md)
* **Items**: [CodeSystem Consent Action Codes](CodeSystem-consentaction.md)
* **Items**: [CodeSystem Consent Scope Codes](CodeSystem-consentscope.md)
* **Items**: [CodeSystem Consent PolicyRule Codes](CodeSystem-consentpolicycodes.md)
* **Items**: [CodeSystem Consent Verification Codes](CodeSystem-consentverification.md)
* **Items**: [CodeSystem Professional Credential Status](CodeSystem-professional-credential-status.md)
* **Items**: [CodeSystem LibraryType](CodeSystem-library-type.md)
* **Items**: [CodeSystem Measure Population Type](CodeSystem-measure-population.md)
* **Items**: [CodeSystem Measure Scoring](CodeSystem-measure-scoring.md)
* **Items**: [CodeSystem MeasureType](CodeSystem-measure-type.md)
* **Items**: [CodeSystem MeasureDataUsage](CodeSystem-measure-data-usage.md)
* **Items**: [CodeSystem Organization Alias Type](CodeSystem-organization-alias-type.md)
* **Items**: [CodeSystem CompositeMeasureScoring](CodeSystem-composite-measure-scoring.md)
* **Items**: [CodeSystem MeasureImprovementNotation](CodeSystem-measure-improvement-notation.md)
* **Items**: [CodeSystem ActivityDefinitionCategory](CodeSystem-activity-definition-category.md)
* **Items**: [CodeSystem DefinitionTopic](CodeSystem-definition-topic.md)
* **Items**: [CodeSystem PlanDefinitionType](CodeSystem-plan-definition-type.md)
* **Items**: [CodeSystem ActionType](CodeSystem-action-type.md)
* **Items**: [CodeSystem Example Procedure Type Codes](CodeSystem-ex-procedure-type.md)
* **Items**: [CodeSystem ResearchStudyPhase](CodeSystem-research-study-phase.md)
* **Items**: [CodeSystem ResearchStudyObjectiveType](CodeSystem-research-study-objective-type.md)
* **Items**: [CodeSystem ResearchStudyReasonStopped](CodeSystem-research-study-reason-stopped.md)
* **Items**: [CodeSystem Research Study Status](CodeSystem-research-study-status.md)
* **Items**: [CodeSystem Research Study Party Role](CodeSystem-research-study-party-role.md)
* **Items**: [CodeSystem ResearchStudyPrimaryPurposeType](CodeSystem-research-study-prim-purp-type.md)
* **Items**: [CodeSystem ResearchSubjectStateType](CodeSystem-research-subject-state-type.md)
* **Items**: [CodeSystem ResearchSubjectState](CodeSystem-research-subject-state.md)
* **Items**: [CodeSystem StateChangeReason](CodeSystem-state-change-reason.md)
* **Items**: [CodeSystem AdverseEventCategory](CodeSystem-adverse-event-category.md)
* **Items**: [CodeSystem AdverseEventSeriousness](CodeSystem-adverse-event-seriousness.md)
* **Items**: [CodeSystem AdverseEventCausalityAssessment](CodeSystem-adverse-event-causality-assess.md)
* **Items**: [CodeSystem AdverseEventCausalityMethod](CodeSystem-adverse-event-causality-method.md)
* **Items**: [CodeSystem AdverseEventSeverity](CodeSystem-adverse-event-severity.md)
* **Items**: [CodeSystem ChargeItemCode](CodeSystem-chargeitem-billingcodes.md)
* **Items**: [CodeSystem ContainerCap](CodeSystem-container-cap.md)
* **Items**: [CodeSystem HandlingConditionSet](CodeSystem-handling-condition.md)
* **Items**: [CodeSystem RejectionCriterion](CodeSystem-rejection-criteria.md)
* **Items**: [CodeSystem Insurance plan type](CodeSystem-insurance-plan-type.md)
* **Items**: [CodeSystem Insurance Product Type](CodeSystem-insurance-product-type.md)
* **Items**: [CodeSystem Insuranceplan Plan Type](CodeSystem-insuranceplan-plan-type.md)
* **Items**: [CodeSystem Insurance Coverage Type](CodeSystem-insurance-coverage-type.md)
* **Items**: [CodeSystem Benefit cost applicability](CodeSystem-applicability.md)
* **Items**: [CodeSystem Need](CodeSystem-need.md)
* **Items**: [CodeSystem Validation-type](CodeSystem-validation-type.md)
* **Items**: [CodeSystem Validation-process](CodeSystem-validation-process.md)
* **Items**: [CodeSystem Failure-action](CodeSystem-failure-action.md)
* **Items**: [CodeSystem Primary-source-type](CodeSystem-primary-source-type.md)
* **Items**: [CodeSystem Validation-status](CodeSystem-validation-status.md)
* **Items**: [CodeSystem Can-push-updates](CodeSystem-can-push-updates.md)
* **Items**: [CodeSystem Push-type-available](CodeSystem-push-type-available.md)
* **Items**: [CodeSystem VerificationResult Communication Method](CodeSystem-verificationresult-communication-method.md)
* **Items**: [CodeSystem Medical Management Type](CodeSystem-medical-management-type.md)
* **Items**: [CodeSystem MedicationKnowledge Status Codes](CodeSystem-medicationknowledge-status.md)
* **Items**: [CodeSystem MedicationKnowledge Characteristic Codes](CodeSystem-medicationknowledge-characteristic.md)
* **Items**: [CodeSystem MedicationKnowledge Package Type Codes](CodeSystem-medicationknowledge-package-type.md)
* **Items**: [CodeSystem Organization Affiliation Role](CodeSystem-organization-affiliation-role.md)
* **Items**: [CodeSystem Organization Affiliation Role for HIE](CodeSystem-organization-affiliation-role-for-hie.md)
* **Items**: [CodeSystem DeviceDefinitionParameterGroup](CodeSystem-parameter-group.md)
* **Items**: [CodeSystem CharacteristicMethod](CodeSystem-characteristic-method.md)
* **Items**: [CodeSystem EvidenceDirectness](CodeSystem-directness.md)
* **Items**: [CodeSystem Security Role Type](CodeSystem-extra-security-role-type.md)
* **Items**: [CodeSystem DICOM Audit Message Record Lifecycle Events](CodeSystem-dicom-audit-lifecycle.md)
* **Items**: [CodeSystem ISO 21089 2017 Health Record Lifecycle Events](CodeSystem-iso-21089-lifecycle.md)
* **Items**: [CodeSystem Digital Media Category](CodeSystem-media-category.md)
* **Items**: [CodeSystem SmartCapabilities](CodeSystem-smart-capabilities.md)
* **Items**: [CodeSystem HumanNameAssemblyOrder](CodeSystem-name-assembly-order.md)
* **Items**: [CodeSystem QualityOfEvidenceRating](CodeSystem-evidence-quality.md)
* **Items**: [CodeSystem StrengthOfRecommendationRating](CodeSystem-recommendation-strength.md)
* **Items**: [CodeSystem GoalRelationshipType](CodeSystem-goal-relationship-type.md)
* **Items**: [CodeSystem GoalAcceptanceStatus](CodeSystem-goal-acceptance-status.md)
* **Items**: [CodeSystem CDS Hooks Card Types](CodeSystem-cdshooks-card-type.md)
* **Items**: [CodeSystem ConformanceExpectation](CodeSystem-conformance-expectation.md)
* **Items**: [CodeSystem MaxOccurs](CodeSystem-question-max-occurs.md)
* **Items**: [CodeSystem ChoiceListOrientation](CodeSystem-choice-list-orientation.md)
* **Items**: [CodeSystem QuestionnaireItemUsageMode](CodeSystem-questionnaire-usage-mode.md)
* **Items**: [CodeSystem AllergyIntoleranceSubstanceExposureRisk](CodeSystem-allerg-intol-substance-exp-risk.md)
* **Items**: [CodeSystem AllergyIntoleranceCertainty](CodeSystem-reaction-event-certainty.md)
* **Items**: [CodeSystem HL7Workgroup](CodeSystem-hl7-work-group.md)
* **Items**: [CodeSystem StandardsStatus](CodeSystem-standards-status.md)
* **Items**: [CodeSystem ResourceSecurityCategory](CodeSystem-resource-security-category.md)
* **Items**: [CodeSystem ExpansionParameterSource](CodeSystem-expansion-parameter-source.md)
* **Items**: [CodeSystem ExpansionProcessingRule](CodeSystem-expansion-processing-rule.md)
* **Items**: [CodeSystem Implant Status](CodeSystem-implantStatus.md)
* **Items**: [CodeSystem AlternativeCodeKind](CodeSystem-codesystem-altcode-kind.md)
* **Items**: [CodeSystem ConditionState](CodeSystem-condition-state.md)
* **Items**: [CodeSystem CatalogType](CodeSystem-catalogType.md)
* **Items**: [CodeSystem AlternativeCodeKind](CodeSystem-composition-altcode-kind.md)
* **Items**: [CodeSystem MatchGrade](CodeSystem-match-grade.md)
* **Items**: [CodeSystem Sex Parameter For Clinical Use](CodeSystem-sex-parameter-for-clinical-use.md)
* **Items**: [CodeSystem Software System Type Codes](CodeSystem-software-system-type-codes.md)
* **Items**: [CodeSystem SubscriptionStatusAtEvent](CodeSystem-subscription-status-at-event.md)
* **Items**: [CodeSystem Appropriateness Score](CodeSystem-appropriateness-score.md)
* **Items**: [ValueSet Care Service Accessibility](ValueSet-care-service-accessibility.md)
* **Items**: [ValueSet Accepting Patients](ValueSet-accepting-patients.md)
* **Items**: [CodeSystem Virtual Healthcare Delivery Method](CodeSystem-virtual-healthcare-delivery-method.md)
* **Items**: [CodeSystem Artifact Relationship Type](CodeSystem-artifact-relationship-type.md)
* **Items**: [CodeSystem Device Alert Activation State](CodeSystem-devicealert-activationState.md)
* **Items**: [CodeSystem Device Alert Priority](CodeSystem-devicealert-priority.md)
* **Items**: [CodeSystem Citation Summary Style](CodeSystem-citation-summary-style.md)
* **Items**: [CodeSystem Citation Classification Type](CodeSystem-citation-classification-type.md)
* **Items**: [CodeSystem Cited Artifact Status Type](CodeSystem-cited-artifact-status-type.md)
* **Items**: [CodeSystem Title Type](CodeSystem-title-type.md)
* **Items**: [CodeSystem Cited Artifact Abstract Type](CodeSystem-cited-artifact-abstract-type.md)
* **Items**: [CodeSystem Cited Artifact Part Type](CodeSystem-cited-artifact-part-type.md)
* **Items**: [CodeSystem Citation Artifact Classifier](CodeSystem-citation-artifact-classifier.md)
* **Items**: [CodeSystem Published In Type](CodeSystem-published-in-type.md)
* **Items**: [CodeSystem Cited Medium](CodeSystem-cited-medium.md)
* **Items**: [CodeSystem Artifact Url Classifier](CodeSystem-artifact-url-classifier.md)
* **Items**: [CodeSystem Cited Artifact Classification Type](CodeSystem-cited-artifact-classification-type.md)
* **Items**: [CodeSystem Cited Artifact Contribution Type](CodeSystem-cited-artifact-contribution-type.md)
* **Items**: [CodeSystem Contributor Role](CodeSystem-contributor-role.md)
* **Items**: [CodeSystem Artifact Contribution Instance Type](CodeSystem-artifact-contribution-instance-type.md)
* **Items**: [CodeSystem Contributor Summary Type](CodeSystem-contributor-summary-type.md)
* **Items**: [CodeSystem Contributor Summary Style](CodeSystem-contributor-summary-style.md)
* **Items**: [CodeSystem Contributor Summary Source](CodeSystem-contributor-summary-source.md)
* **Items**: [CodeSystem Evidence Certainty Type](CodeSystem-certainty-type.md)
* **Items**: [CodeSystem Statistic Model Code](CodeSystem-statistic-model-code.md)
* **Items**: [CodeSystem EvidenceVariableRoleSubtype](CodeSystem-variable-role-subtype.md)
* **Items**: [CodeSystem Group Code](CodeSystem-group-code.md)
* **Items**: [CodeSystem Time Period Ranges](CodeSystem-time-period-ranges.md)
* **Items**: [ValueSet Evidence Certainty Type](ValueSet-certainty-type.md)
* **Items**: [ValueSet Statistic Model Code](ValueSet-statistic-model-code.md)
* **Items**: [ValueSet EvidenceVariableRoleSubtype](ValueSet-variable-role-subtype.md)
* **Items**: [ValueSet Citation Summary Style](ValueSet-citation-summary-style.md)
* **Items**: [ValueSet Citation Classification Type](ValueSet-citation-classification-type.md)
* **Items**: [ValueSet Cited Artifact Status Type](ValueSet-cited-artifact-status-type.md)
* **Items**: [ValueSet Title Type](ValueSet-title-type.md)
* **Items**: [ValueSet Cited Artifact Abstract Type](ValueSet-cited-artifact-abstract-type.md)
* **Items**: [ValueSet Cited Artifact Part Type](ValueSet-cited-artifact-part-type.md)
* **Items**: [ValueSet Citation Artifact Classifier](ValueSet-citation-artifact-classifier.md)
* **Items**: [ValueSet Published In Type](ValueSet-published-in-type.md)
* **Items**: [ValueSet Cited Medium](ValueSet-cited-medium.md)
* **Items**: [ValueSet Artifact Url Classifier](ValueSet-artifact-url-classifier.md)
* **Items**: [ValueSet Cited Artifact Classification Type](ValueSet-cited-artifact-classification-type.md)
* **Items**: [ValueSet Cited Artifact Contribution Type](ValueSet-cited-artifact-contribution-type.md)
* **Items**: [ValueSet Contributor Role](ValueSet-contributor-role.md)
* **Items**: [ValueSet Artifact Contribution Instance Type](ValueSet-artifact-contribution-instance-type.md)
* **Items**: [ValueSet Contributor Summary Type](ValueSet-contributor-summary-type.md)
* **Items**: [ValueSet Contributor Summary Style](ValueSet-contributor-summary-style.md)
* **Items**: [ValueSet Contributor Summary Source](ValueSet-contributor-summary-source.md)
* **Items**: [ValueSet ActionType](ValueSet-action-type.md)
* **Items**: [ValueSet Action Participant Role](ValueSet-action-participant-role.md)
* **Items**: [ValueSet ActivityDefinitionCategory](ValueSet-activity-definition-category.md)
* **Items**: [ValueSet AdjudicationError](ValueSet-adjudication-error.md)
* **Items**: [ValueSet Adjudication Reason Codes](ValueSet-adjudication-reason.md)
* **Items**: [ValueSet Adjudication Value Codes](ValueSet-adjudication.md)
* **Items**: [ValueSet AdverseEventCategory](ValueSet-adverse-event-category.md)
* **Items**: [ValueSet AdverseEventCausalityAssessment](ValueSet-adverse-event-causality-assess.md)
* **Items**: [ValueSet AdverseEventCausalityMethod](ValueSet-adverse-event-causality-method.md)
* **Items**: [ValueSet Adverse Event Clinical Research Causality Relatedness](ValueSet-adverse-event-clinical-research-causality-relatedness.md)
* **Items**: [ValueSet Adverse Event Clinical Research Grades](ValueSet-adverse-event-clinical-research-grades.md)
* **Items**: [ValueSet Adverse Event Clinical Research Outcomes](ValueSet-adverse-event-clinical-research-outcomes.md)
* **Items**: [ValueSet Adverse Event Clinical Research Seriousness Criteria](ValueSet-adverse-event-clinical-research-seriousness-criteria.md)
* **Items**: [ValueSet AdverseEventSeriousness](ValueSet-adverse-event-seriousness.md)
* **Items**: [ValueSet AdverseEventSeverity](ValueSet-adverse-event-severity.md)
* **Items**: [ValueSet AllergyIntoleranceSubstanceExposureRisk](ValueSet-allerg-intol-substance-exp-risk.md)
* **Items**: [ValueSet AllergyIntolerance Clinical Status Codes](ValueSet-allergyintolerance-clinical.md)
* **Items**: [ValueSet AllergyIntolerance Verification Status](ValueSet-allergyintolerance-verification.md)
* **Items**: [ValueSet Appointment cancellation reason](ValueSet-appointment-cancellation-reason.md)
* **Items**: [ValueSet Artifact Identifier Type](ValueSet-artifact-identifier-type.md)
* **Items**: [ValueSet Artifact Version Policy](ValueSet-artifact-version-policy.md)
* **Items**: [ValueSet StatisticAttributeEstimateType](ValueSet-attribute-estimate-type.md)
* **Items**: [ValueSet Audit Event Outcome](ValueSet-audit-event-outcome.md)
* **Items**: [ValueSet Audit Event Source Type](ValueSet-audit-source-type.md)
* **Items**: [ValueSet Basic Resource Types](ValueSet-basic-resource-type.md)
* **Items**: [ValueSet Network Type Codes](ValueSet-benefit-network.md)
* **Items**: [ValueSet Benefit Term Codes](ValueSet-benefit-term.md)
* **Items**: [ValueSet Benefit Type Codes](ValueSet-benefit-type.md)
* **Items**: [ValueSet Unit Type Codes](ValueSet-benefit-unit.md)
* **Items**: [ValueSet CatalogType](ValueSet-catalogType.md)
* **Items**: [ValueSet StatisticCertaintyRating](ValueSet-certainty-rating.md)
* **Items**: [ValueSet StatisticCertaintySubcomponentRating](ValueSet-certainty-subcomponent-rating.md)
* **Items**: [ValueSet StatisticCertaintySubcomponentType](ValueSet-certainty-subcomponent-type.md)
* **Items**: [ValueSet CharacteristicMethod](ValueSet-characteristic-method.md)
* **Items**: [ValueSet ChargeItemCode](ValueSet-chargeitem-billingcodes.md)
* **Items**: [ValueSet ChoiceListOrientation](ValueSet-choice-list-orientation.md)
* **Items**: [ValueSet chromosome-human](ValueSet-chromosome-human.md)
* **Items**: [ValueSet Claim Care Team Role Codes](ValueSet-claim-careteamrole.md)
* **Items**: [ValueSet Exception Codes](ValueSet-claim-exception.md)
* **Items**: [ValueSet Claim Information Category Codes](ValueSet-claim-informationcategory.md)
* **Items**: [ValueSet Modifier type Codes](ValueSet-claim-modifiers.md)
* **Items**: [ValueSet Example Claim SubType Codes](ValueSet-claim-subtype.md)
* **Items**: [ValueSet Claim Type Codes](ValueSet-claim-type.md)
* **Items**: [ValueSet AlternativeCodeKind](ValueSet-codesystem-altcode-kind.md)
* **Items**: [ValueSet Common Tags](ValueSet-common-tags.md)
* **Items**: [ValueSet CommunicationCategory](ValueSet-communication-category.md)
* **Items**: [ValueSet CommunicationNotDoneReason](ValueSet-communication-not-done-reason.md)
* **Items**: [ValueSet CommunicationTopic](ValueSet-communication-topic.md)
* **Items**: [ValueSet CompositeMeasureScoring](ValueSet-composite-measure-scoring.md)
* **Items**: [ValueSet AlternativeCodeKind](ValueSet-composition-altcode-kind.md)
* **Items**: [ValueSet Condition Category Codes](ValueSet-condition-category.md)
* **Items**: [ValueSet Condition Clinical Status Codes](ValueSet-condition-clinical.md)
* **Items**: [ValueSet ConditionState](ValueSet-condition-state.md)
* **Items**: [ValueSet ConditionVerificationStatus](ValueSet-condition-ver-status.md)
* **Items**: [ValueSet ConformanceExpectation](ValueSet-conformance-expectation.md)
* **Items**: [ValueSet Consent Action Codes](ValueSet-consent-action.md)
* **Items**: [ValueSet Consent PolicyRule Codes](ValueSet-consent-policy.md)
* **Items**: [ValueSet Consent Scope Codes](ValueSet-consent-scope.md)
* **Items**: [ValueSet Consent Verification Codes](ValueSet-consent-verification.md)
* **Items**: [ValueSet Contact entity type](ValueSet-contactentity-type.md)
* **Items**: [ValueSet ContainerCap](ValueSet-container-cap.md)
* **Items**: [ValueSet Contract Action Codes](ValueSet-contract-action.md)
* **Items**: [ValueSet Contract Actor Role Codes](ValueSet-contract-actorrole.md)
* **Items**: [ValueSet Contract Content Derivation Codes](ValueSet-contract-content-derivative.md)
* **Items**: [ValueSet ContractDataMeaning](ValueSet-contract-data-meaning.md)
* **Items**: [ValueSet Contract Signer Type Codes](ValueSet-contract-signer-type.md)
* **Items**: [ValueSet Contract Subtype Codes](ValueSet-contract-subtype.md)
* **Items**: [ValueSet Contract Term Subtype Codes](ValueSet-contract-term-subtype.md)
* **Items**: [ValueSet Contract Term Type Codes](ValueSet-contract-term-type.md)
* **Items**: [ValueSet Contract Type Codes](ValueSet-contract-type.md)
* **Items**: [ValueSet CopyNumberEvent](ValueSet-copy-number-event.md)
* **Items**: [ValueSet Coverage Class Codes](ValueSet-coverage-class.md)
* **Items**: [ValueSet Coverage Copay Type Codes](ValueSet-coverage-copay-type.md)
* **Items**: [ValueSet Example Coverage Financial Exception Codes](ValueSet-coverage-financial-exception.md)
* **Items**: [ValueSet Coverage SelfPay Codes](ValueSet-coverage-selfpay.md)
* **Items**: [ValueSet CoverageEligibilityResponse Auth Support Codes](ValueSet-coverageeligibilityresponse-ex-auth-support.md)
* **Items**: [ValueSet AMA CPT All Codes](ValueSet-cpt-all.md)
* **Items**: [ValueSet AMA CPT Base Codes](ValueSet-cpt-base.md)
* **Items**: [ValueSet AMA CPT Modifier Codes](ValueSet-cpt-modifiers.md)
* **Items**: [ValueSet AMA CPT Usable Codes](ValueSet-cpt-usable.md)
* **Items**: [ValueSet rofessional Credential Status](ValueSet-professional-credential-status.md)
* **Items**: [ValueSet DefinitionStatus](ValueSet-definition-status.md)
* **Items**: [ValueSet DefinitionTopic](ValueSet-definition-topic.md)
* **Items**: [ValueSet Structure Definition Use Codes / Keywords](ValueSet-definition-use.md)
* **Items**: [ValueSet FHIRDeviceStatusReason](ValueSet-device-status-reason.md)
* **Items**: [ValueSet DiagnosisRole](ValueSet-diagnosis-role.md)
* **Items**: [ValueSet Diagnosis Type Codes](ValueSet-diagnosistype.md)
* **Items**: [ValueSet EvidenceDirectness](ValueSet-directness.md)
* **Items**: [ValueSet DoseAndRateType](ValueSet-dose-rate-type.md)
* **Items**: [ValueSet Types of Edible Substances](ValueSet-edible-substance-type.md)
* **Items**: [ValueSet Admit source](ValueSet-encounter-admit-source.md)
* **Items**: [ValueSet Diet](ValueSet-encounter-diet.md)
* **Items**: [ValueSet Discharge disposition](ValueSet-encounter-discharge-disposition.md)
* **Items**: [ValueSet Special arrangements](ValueSet-encounter-special-arrangements.md)
* **Items**: [ValueSet Encounter subject status](ValueSet-encounter-subject-status.md)
* **Items**: [ValueSet Encounter class](ValueSet-encounter-class.md)
* **Items**: [ValueSet Encounter type](ValueSet-encounter-type.md)
* **Items**: [ValueSet Endpoint Connection Type](ValueSet-endpoint-connection-type.md)
* **Items**: [ValueSet Enteral Formula Additive Type Code](ValueSet-entformula-additive.md)
* **Items**: [ValueSet Episode of care type](ValueSet-episodeofcare-type.md)
* **Items**: [ValueSet QualityOfEvidenceRating](ValueSet-evidence-quality.md)
* **Items**: [ValueSet Benefit Category Codes](ValueSet-ex-benefitcategory.md)
* **Items**: [ValueSet Example Diagnosis on Admission Codes](ValueSet-ex-diagnosis-on-admission.md)
* **Items**: [ValueSet Example Diagnosis Related Group Codes](ValueSet-ex-diagnosisrelatedgroup.md)
* **Items**: [ValueSet Example Diagnosis Type Codes](ValueSet-ex-diagnosistype.md)
* **Items**: [ValueSet ClaimPayeeResourceType](ValueSet-ex-payee-resource-type.md)
* **Items**: [ValueSet FHIR Device Types](ValueSet-device-kind.md)
* **Items**: [ValueSet Example Payment Type Codes](ValueSet-ex-paymenttype.md)
* **Items**: [ValueSet Example Procedure Type Codes](ValueSet-ex-procedure-type.md)
* **Items**: [ValueSet Example Program Reason Codes](ValueSet-ex-program-code.md)
* **Items**: [ValueSet Example Revenue Center Codes](ValueSet-ex-revenue-center.md)
* **Items**: [ValueSet ExpansionParameterSource](ValueSet-expansion-parameter-source.md)
* **Items**: [ValueSet ExpansionProcessingRule](ValueSet-expansion-processing-rule.md)
* **Items**: [ValueSet Financial Task Codes](ValueSet-financial-taskcode.md)
* **Items**: [ValueSet Financial Task Input Type Codes](ValueSet-financial-taskinputtype.md)
* **Items**: [ValueSet Flag Category](ValueSet-flag-category.md)
* **Items**: [ValueSet Forms](ValueSet-forms.md)
* **Items**: [ValueSet Funds Reservation Codes](ValueSet-fundsreserve.md)
* **Items**: [ValueSet GoalAcceptanceStatus](ValueSet-goal-acceptance-status.md)
* **Items**: [ValueSet Goal achievement status](ValueSet-goal-achievement.md)
* **Items**: [ValueSet Goal category](ValueSet-goal-category.md)
* **Items**: [ValueSet Goal priority](ValueSet-goal-priority.md)
* **Items**: [ValueSet GoalRelationshipType](ValueSet-goal-relationship-type.md)
* **Items**: [ValueSet GuideParameterCode](ValueSet-guide-parameter-code.md)
* **Items**: [ValueSet HandlingConditionSet](ValueSet-handling-condition.md)
* **Items**: [ValueSet NDH Healthcare Service Category](ValueSet-ndh-healthcare-service-category.md)
* **Items**: [ValueSet FamilyHistoryAbsentReason](ValueSet-history-absent-reason.md)
* **Items**: [ValueSet HL7Workgroup](ValueSet-hl7-work-group.md)
* **Items**: [ValueSet Image Reference Type](ValueSet-image-reference-type.md)
* **Items**: [ValueSet Immunization Evaluation Dose Status Reason codes](ValueSet-immunization-evaluation-dose-status-reason.md)
* **Items**: [ValueSet Immunization Evaluation Dose Status codes](ValueSet-immunization-evaluation-dose-status.md)
* **Items**: [ValueSet Immunization Function](ValueSet-immunization-function.md)
* **Items**: [ValueSet Immunization Funding Source](ValueSet-immunization-funding-source.md)
* **Items**: [ValueSet Immunization Program Eligibility](ValueSet-immunization-program-eligibility.md)
* **Items**: [ValueSet Immunization Recommendation Status Codes](ValueSet-immunization-recommendation-status.md)
* **Items**: [ValueSet Immunization Subpotent Reason](ValueSet-immunization-subpotent-reason.md)
* **Items**: [ValueSet Implant Status](ValueSet-implantStatus.md)
* **Items**: [ValueSet Benefit cost applicability](ValueSet-insuranceplan-applicability.md)
* **Items**: [ValueSet Insurance plan type](ValueSet-insuranceplan-type.md)
* **Items**: [ValueSet Insurance Product Type](ValueSet-insurance-product-type.md)
* **Items**: [ValueSet Insuranceplan Plan Type](ValueSet-insuranceplan-plan-type.md)
* **Items**: [ValueSet Insurance Coverage Type](ValueSet-insurance-coverage-type.md)
* **Items**: [ValueSet LibraryType](ValueSet-library-type.md)
* **Items**: [ValueSet List Empty Reasons](ValueSet-list-empty-reason.md)
* **Items**: [ValueSet Example Use Codes for List](ValueSet-list-example-codes.md)
* **Items**: [ValueSet List Order Codes](ValueSet-list-order.md)
* **Items**: [ValueSet Location type](ValueSet-location-physical-type.md)
* **Items**: [ValueSet MatchGrade](ValueSet-match-grade.md)
* **Items**: [ValueSet MeasureDataUsage](ValueSet-measure-data-usage.md)
* **Items**: [ValueSet MeasureImprovementNotation](ValueSet-measure-improvement-notation.md)
* **Items**: [ValueSet MeasurePopulationType](ValueSet-measure-population.md)
* **Items**: [ValueSet Measure Scoring](ValueSet-measure-scoring.md)
* **Items**: [ValueSet MeasureType](ValueSet-measure-type.md)
* **Items**: [ValueSet Medication administration performer function codes](ValueSet-med-admin-perform-function.md)
* **Items**: [ValueSet Medical Management Type](ValueSet-medical-management-type.md)
* **Items**: [ValueSet Medication dispense performer function codes](ValueSet-medicationdispense-performer-function.md)
* **Items**: [ValueSet Medication knowledge characteristic codes](ValueSet-medicationknowledge-characteristic.md)
* **Items**: [ValueSet Medication knowledge package type codes](ValueSet-medicationknowledge-package-type.md)
* **Items**: [ValueSet Medication knowledge status codes](ValueSet-medicationknowledge-status.md)
* **Items**: [ValueSet Medication request category codes](ValueSet-medicationrequest-category.md)
* **Items**: [ValueSet Medication request course of therapy codes](ValueSet-medicationrequest-course-of-therapy.md)
* **Items**: [ValueSet Medication request status reason codes](ValueSet-medicationrequest-status-reason.md)
* **Items**: [ValueSet Example Message Reason Codes](ValueSet-message-reason-encounter.md)
* **Items**: [ValueSet Missing Tooth Reason Codes](ValueSet-missing-tooth-reason.md)
* **Items**: [ValueSet Nutrition intake category codes](ValueSet-nutrition-intake-category.md)
* **Items**: [ValueSet AuditEventEntityRole](ValueSet-object-role.md)
* **Items**: [ValueSet Observation Category Codes](ValueSet-observation-category.md)
* **Items**: [ValueSet StatisticsCode](ValueSet-observation-statistics.md)
* **Items**: [ValueSet Organization Affiliation Role](ValueSet-organization-affiliation-role.md)
* **Items**: [ValueSet Organization type](ValueSet-organization-type.md)
* **Items**: [ValueSet Organization Alias Type](ValueSet-organization-alias-type.md)
* **Items**: [ValueSet DeviceDefinitionParameterGroup](ValueSet-parameter-group.md)
* **Items**: [ValueSet Payee Type Codes](ValueSet-payeetype.md)
* **Items**: [ValueSet Payment Adjustment Reason Codes](ValueSet-payment-adjustment-reason.md)
* **Items**: [ValueSet Payment Status Codes](ValueSet-payment-status.md)
* **Items**: [ValueSet Payment Type Codes](ValueSet-payment-type.md)
* **Items**: [ValueSet PlanDefinitionType](ValueSet-plan-definition-type.md)
* **Items**: [ValueSet Procedure Type Codes](ValueSet-procedure-type.md)
* **Items**: [ValueSet Process Priority Codes](ValueSet-process-priority.md)
* **Items**: [ValueSet Program](ValueSet-program.md)
* **Items**: [ValueSet Provenance participant type](ValueSet-provenance-agent-type.md)
* **Items**: [ValueSet Example Provider Qualification Codes](ValueSet-provider-qualification.md)
* **Items**: [ValueSet MaxOccurs](ValueSet-question-max-occurs.md)
* **Items**: [ValueSet QuestionnaireItemUsageMode](ValueSet-questionnaire-usage-mode.md)
* **Items**: [ValueSet AllergyIntoleranceCertainty](ValueSet-reaction-event-certainty.md)
* **Items**: [ValueSet Reason Medication Given Codes](ValueSet-reason-medication-given-codes.md)
* **Items**: [ValueSet StrengthOfRecommendationRating](ValueSet-recommendation-strength.md)
* **Items**: [ValueSet Observation Reference Range Meaning Codes](ValueSet-referencerange-meaning.md)
* **Items**: [ValueSet RejectionCriterion](ValueSet-rejection-criteria.md)
* **Items**: [ValueSet Example Related Claim Relationship Codes](ValueSet-related-claim-relationship.md)
* **Items**: [ValueSet ResearchStudyObjectiveType](ValueSet-research-study-objective-type.md)
* **Items**: [ValueSet Research Study Party Role](ValueSet-research-study-party-role.md)
* **Items**: [ValueSet ResearchStudyPhase](ValueSet-research-study-phase.md)
* **Items**: [ValueSet ResearchStudyPrimaryPurposeType](ValueSet-research-study-prim-purp-type.md)
* **Items**: [ValueSet ResearchStudyReasonStopped](ValueSet-research-study-reason-stopped.md)
* **Items**: [ValueSet Research Study Status](ValueSet-research-study-status.md)
* **Items**: [ValueSet Research Subject Milestones](ValueSet-research-subject-milestones.md)
* **Items**: [ValueSet ResearchSubjectStateType](ValueSet-research-subject-state-type.md)
* **Items**: [ValueSet ResearchSubjectState](ValueSet-research-subject-state.md)
* **Items**: [ValueSet ResourceSecurityCategory](ValueSet-resource-security-category.md)
* **Items**: [ValueSet PayeeResourceType](ValueSet-resource-type-link.md)
* **Items**: [ValueSet Risk Probability](ValueSet-risk-probability.md)
* **Items**: [ValueSet Service category](ValueSet-service-category.md)
* **Items**: [ValueSet Service Delivery Method](ValueSet-service-delivery-method.md)
* **Items**: [ValueSet Example Service Place Codes](ValueSet-service-place.md)
* **Items**: [ValueSet ServiceProvisionConditions](ValueSet-service-provision-conditions.md)
* **Items**: [ValueSet ReferralMethod](ValueSet-service-referral-method.md)
* **Items**: [ValueSet Service type](ValueSet-service-type.md)
* **Items**: [ValueSet USCLS Codes](ValueSet-service-uscls.md)
* **Items**: [ValueSet SmartCapabilities](ValueSet-smart-capabilities.md)
* **Items**: [ValueSet Software System Type](ValueSet-software-system-type.md)
* **Items**: [ValueSet SpecialValues](ValueSet-special-values.md)
* **Items**: [ValueSet StandardsStatus](ValueSet-standards-status.md)
* **Items**: [ValueSet StateChangeReason](ValueSet-state-change-reason.md)
* **Items**: [ValueSet StatisticStatisticType](ValueSet-statistic-type.md)
* **Items**: [ValueSet Study Design](ValueSet-study-design.md)
* **Items**: [ValueSet StatisticStudyType](ValueSet-study-type.md)
* **Items**: [ValueSet SubscriberPolicyholder Relationship Codes](ValueSet-subscriber-relationship.md)
* **Items**: [ValueSet SubscriptionChannel Type Codes](ValueSet-subscription-channel-type.md)
* **Items**: [ValueSet Subscription Error Codes](ValueSet-subscription-error.md)
* **Items**: [ValueSet SubscriptionStatusAtEvent](ValueSet-subscription-status-at-event.md)
* **Items**: [ValueSet SubscriptionTag](ValueSet-subscription-tag.md)
* **Items**: [ValueSet Substance Category Codes](ValueSet-substance-category.md)
* **Items**: [ValueSet Supply Item Type](ValueSet-supplydelivery-type.md)
* **Items**: [ValueSet Supply Type](ValueSet-supplyrequest-kind.md)
* **Items**: [ValueSet SupplyRequestReason](ValueSet-supplyrequest-reason.md)
* **Items**: [ValueSet Surface Codes](ValueSet-surface.md)
* **Items**: [ValueSet StatisticSynthesisType](ValueSet-synthesis-type.md)
* **Items**: [ValueSet Test script operation code](ValueSet-testscript-operation-codes.md)
* **Items**: [ValueSet Test script profile destination type](ValueSet-testscript-profile-destination-types.md)
* **Items**: [ValueSet Test script profile origin type](ValueSet-testscript-profile-origin-types.md)
* **Items**: [ValueSet Oral Site Codes](ValueSet-tooth.md)
* **Items**: [ValueSet Common UCUM units](ValueSet-ucum-common.md)
* **Items**: [ValueSet UCUM Codes](ValueSet-ucum-units.md)
* **Items**: [ValueSet UsageContextType](ValueSet-usage-context-type.md)
* **Items**: [ValueSet sequenceStatus](ValueSet-variant-state.md)
* **Items**: [ValueSet Can-push-updates](ValueSet-verificationresult-can-push-updates.md)
* **Items**: [ValueSet VerificationResult Communication Method](ValueSet-verificationresult-communication-method.md)
* **Items**: [ValueSet Failure-action](ValueSet-verificationresult-failure-action.md)
* **Items**: [ValueSet Need](ValueSet-verificationresult-need.md)
* **Items**: [ValueSet Primary-source-type](ValueSet-verificationresult-primary-source-type.md)
* **Items**: [ValueSet Push-type-available](ValueSet-verificationresult-push-type-available.md)
* **Items**: [ValueSet Validation-process](ValueSet-verificationresult-validation-process.md)
* **Items**: [ValueSet Validation-status](ValueSet-verificationresult-validation-status.md)
* **Items**: [ValueSet Validation-type](ValueSet-verificationresult-validation-type.md)
* **Items**: [ValueSet Example Vision Prescription Product Codes](ValueSet-vision-product.md)
* **Items**: [ValueSet Clinical Discharge Disposition](ValueSet-clinical-discharge-disposition.md)
* **Items**: [ValueSet Appropriateness Score](ValueSet-appropriateness-score.md)
* **Items**: [ValueSet Gender Identity](ValueSet-gender-identity.md)
* **Items**: [ValueSet Personal Pronouns](ValueSet-pronouns.md)
* **Items**: [ValueSet Recorded Sex Or Gender Type](ValueSet-recorded-sex-or-gender-type.md)
* **Items**: [ValueSet Sex Parameter for Clinical Use](ValueSet-sex-parameter-for-clinical-use.md)
* **Items**: [ValueSet Jurisdiction ValueSet](ValueSet-jurisdiction.md)
* **Items**: [ValueSet Virtual Healthcare Delivery Method](ValueSet-virtual-healthcare-delivery-method.md)
* **Items**: [ValueSet DeviceAlert Activation State Codes](ValueSet-devicealert-activationState.md)
* **Items**: [ValueSet DeviceAlert Condition Codes](ValueSet-devicealert-condition.md)
* **Items**: [ValueSet DeviceAlert Priority Codes](ValueSet-devicealert-priority.md)
* **Items**: [ValueSet Artifact Relationship Type](ValueSet-artifact-relationship-type.md)
* **Items**: [ValueSet Group Code](ValueSet-group-code.md)
* **Items**: [ValueSet Time Period Ranges](ValueSet-time-period-ranges.md)



## Resource Content

```json
{
  "resourceType" : "List",
  "id" : "fhir-Rendering",
  "status" : "current",
  "mode" : "working",
  "title" : "FHIR Rendering Manifest",
  "code" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
        "code" : "UTGCTGManifest"
      }
    ]
  },
  "orderedBy" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/list-order",
        "code" : "alphabetic"
      }
    ]
  },
  "entry" : [
    {
      "item" : {
        "reference" : "CodeSystem/accepting-patients",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/care-service-accessibility",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/adjudication-error",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/artifact-version-policy-codes",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/data-absent-reason",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/artifact-identifier-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/diagnosis-role",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/forms-codes",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/fundsreserve",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/payeetype",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/special-values",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/synthesis-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/study-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/statistic-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/attribute-estimate-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/certainty-rating",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/certainty-subcomponent-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/certainty-subcomponent-rating",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/common-tags",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/usage-context-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/dose-rate-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/definition-status",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/flag-category",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/allergyintolerance-verification",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/allergyintolerance-clinical",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/basic-resource-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/condition-category",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/condition-clinical",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/condition-ver-status",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/communication-category",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/communication-not-done-reason",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/communication-topic",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/crd-coverage-detail",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/device-status-reason",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/deviceassociation-relationship",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/deviceassociation-status-reason",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/variant-state",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/chromosome-human",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/copy-number-event",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/encounter-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/participant-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/encounter-special-arrangements",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/diet",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/admit-source",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/discharge-disposition",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/encounter-subject-status",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/history-absent-reason",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/goal-priority",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/goal-category",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/goal-achievement",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/ndh-healthcare-service-category",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/immunization-subpotent-reason",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/immunization-program-eligibility",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/immunization-funding-source",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/immunization-origin",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/immunization-evaluation-dose-status",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/immunization-evaluation-dose-status-reason",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/immunization-recommendation-status",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/guide-parameter-code",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/list-example-use-codes",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/list-empty-reason",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/list-order",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/location-physical-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/reason-medication-given",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/medication-admin-location",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/med-admin-perform-function",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/medicationdispense-performer-function",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/medicationrequest-admin-location",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/medicationrequest-status-reason",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/medicationrequest-course-of-therapy",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/medicationrequest-category",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/medication-usage-admin-location",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/message-reasons-encounter",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/nutrition-intake-category",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/nutritionintake-status-reason",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/entformula-additive",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/referencerange-meaning",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/observation-category",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/observation-statistics",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/operation-outcome",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/organization-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/contactentity-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/provenance-participant-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/practitioner-role",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/risk-probability",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/audit-event-outcome",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/audit-entity-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/object-role",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/audit-event-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/security-source-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/substance-category",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/appointment-cancellation-reason",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/endpoint-payload-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/endpoint-connection-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/subscription-channel-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/subscription-tag",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/subscription-error",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/service-referral-method",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/service-provision-conditions",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/service-category",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/service-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/program",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/subscriber-relationship",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/coverage-class",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/coverage-selfpay",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/coverage-copay-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/ex-coverage-financial-exception",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/missingtoothreason",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/modifiers",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/ex-tooth",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/ex-USCLS",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/FDI-surface",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/processpriority",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/claim-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/ex-serviceplace",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/ex-claimsubtype",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/ex-relatedclaimrelationship",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/ex-providerqualification",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/ex-programcode",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/claim-exception",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/claiminformationcategory",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/diagnosistype",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/ex-payee-resource-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/claimcareteamrole",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/ex-diagnosisrelatedgroup",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/ex-diagnosistype",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/ex-revenue-center",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/ex-diagnosis-on-admission",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/procedure-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/financialtaskcode",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/financialtaskinputtype",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/adjudication",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/adjudication-reason",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/payment-adjustment-reason",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/ex-benefitcategory",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/benefit-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/benefit-network",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/benefit-unit",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/benefit-term",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/resource-type-link",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/ex-paymenttype",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/coverageeligibilityresponse-ex-auth-support",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/payment-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/paymentstatus",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/service-delivery-method",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/ex-visionprescriptionproduct",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/episodeofcare-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/definition-use",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/supply-kind",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/supplyrequest-reason",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/supply-item-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/testscript-operation-codes",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/testscript-profile-origin-types",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/testscript-profile-destination-types",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/contract-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/contractsubtypecodes",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/contracttermtypecodes",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/contracttermsubtypecodes",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/contractsignertypecodes",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/contractaction",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/contractactorrole",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/contract-content-derivative",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/contract-data-meaning",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/consentcategorycodes",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/consentaction",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/consentscope",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/consentpolicycodes",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/consentverification",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/professional-credential-status",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/library-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/measure-population",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/measure-scoring",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/measure-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/measure-data-usage",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/organization-alias-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/composite-measure-scoring",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/measure-improvement-notation",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/activity-definition-category",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/definition-topic",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/plan-definition-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/action-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/ex-procedure-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/research-study-phase",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/research-study-objective-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/research-study-reason-stopped",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/research-study-status",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/research-study-party-role",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/research-study-prim-purp-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/research-subject-state-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/research-subject-state",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/state-change-reason",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/adverse-event-category",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/adverse-event-seriousness",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/adverse-event-causality-assess",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/adverse-event-causality-method",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/adverse-event-severity",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/chargeitem-billingcodes",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/container-cap",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/handling-condition",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/rejection-criteria",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/insurance-plan-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/insurance-product-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/insuranceplan-plan-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/insurance-coverage-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/applicability",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/need",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/validation-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/validation-process",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/failure-action",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/primary-source-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/validation-status",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/can-push-updates",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/push-type-available",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/verificationresult-communication-method",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/medical-management-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/medicationknowledge-status",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/medicationknowledge-characteristic",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/medicationknowledge-package-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/organization-affiliation-role",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/organization-affiliation-role-for-hie",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/parameter-group",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/characteristic-method",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/directness",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/extra-security-role-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/dicom-audit-lifecycle",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/iso-21089-lifecycle",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/media-category",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/smart-capabilities",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/name-assembly-order",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/evidence-quality",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/recommendation-strength",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/goal-relationship-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/goal-acceptance-status",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/cdshooks-card-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/conformance-expectation",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/question-max-occurs",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/choice-list-orientation",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/questionnaire-usage-mode",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/allerg-intol-substance-exp-risk",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/reaction-event-certainty",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/hl7-work-group",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/standards-status",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/resource-security-category",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/expansion-parameter-source",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/expansion-processing-rule",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/implantStatus",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/codesystem-altcode-kind",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/condition-state",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/catalogType",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/composition-altcode-kind",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/match-grade",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/sex-parameter-for-clinical-use",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/software-system-type-codes",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/subscription-status-at-event",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/appropriateness-score",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/care-service-accessibility",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/accepting-patients",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/virtual-healthcare-delivery-method"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/artifact-relationship-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/devicealert-activationState",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/devicealert-priority",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/citation-summary-style",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/citation-classification-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/cited-artifact-status-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/title-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/cited-artifact-abstract-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/cited-artifact-part-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/citation-artifact-classifier",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/published-in-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/cited-medium",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/artifact-url-classifier",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/cited-artifact-classification-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/cited-artifact-contribution-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/contributor-role",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/artifact-contribution-instance-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/contributor-summary-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/contributor-summary-style",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/contributor-summary-source",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/certainty-type",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/statistic-model-code",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/variable-role-subtype",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/group-code",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "CodeSystem/time-period-ranges",
        "type" : "CodeSystem"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/certainty-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/statistic-model-code",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/variable-role-subtype",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/citation-summary-style",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/citation-classification-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/cited-artifact-status-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/title-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/cited-artifact-abstract-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/cited-artifact-part-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/citation-artifact-classifier",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/published-in-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/cited-medium",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/artifact-url-classifier",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/cited-artifact-classification-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/cited-artifact-contribution-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/contributor-role",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/artifact-contribution-instance-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/contributor-summary-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/contributor-summary-style",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/contributor-summary-source",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/action-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/action-participant-role",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/activity-definition-category",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/adjudication-error",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/adjudication-reason",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/adjudication",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/adverse-event-category",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/adverse-event-causality-assess",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/adverse-event-causality-method",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/adverse-event-clinical-research-causality-relatedness",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/adverse-event-clinical-research-grades",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/adverse-event-clinical-research-outcomes",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/adverse-event-clinical-research-seriousness-criteria",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/adverse-event-seriousness",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/adverse-event-severity",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/allerg-intol-substance-exp-risk",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/allergyintolerance-clinical",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/allergyintolerance-verification",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/appointment-cancellation-reason",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/artifact-identifier-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/artifact-version-policy",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/attribute-estimate-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/audit-event-outcome",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/audit-source-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/basic-resource-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/benefit-network",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/benefit-term",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/benefit-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/benefit-unit",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/catalogType",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/certainty-rating",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/certainty-subcomponent-rating",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/certainty-subcomponent-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/characteristic-method",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/chargeitem-billingcodes",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/choice-list-orientation",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/chromosome-human",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/claim-careteamrole",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/claim-exception",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/claim-informationcategory",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/claim-modifiers",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/claim-subtype",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/claim-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/codesystem-altcode-kind",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/common-tags",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/communication-category",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/communication-not-done-reason",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/communication-topic",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/composite-measure-scoring",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/composition-altcode-kind",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/condition-category",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/condition-clinical",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/condition-state",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/condition-ver-status",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/conformance-expectation",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/consent-action",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/consent-policy",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/consent-scope",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/consent-verification",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/contactentity-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/container-cap",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/contract-action",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/contract-actorrole",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/contract-content-derivative",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/contract-data-meaning",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/contract-signer-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/contract-subtype",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/contract-term-subtype",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/contract-term-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/contract-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/copy-number-event",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/coverage-class",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/coverage-copay-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/coverage-financial-exception",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/coverage-selfpay",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/coverageeligibilityresponse-ex-auth-support",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/cpt-all",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/cpt-base",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/cpt-modifiers",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/cpt-usable",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/professional-credential-status",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/definition-status",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/definition-topic",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/definition-use",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/device-status-reason",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/diagnosis-role",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/diagnosistype",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/directness",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/dose-rate-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/edible-substance-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/encounter-admit-source",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/encounter-diet",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/encounter-discharge-disposition",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/encounter-special-arrangements",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/encounter-subject-status",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/encounter-class",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/encounter-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/endpoint-connection-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/entformula-additive",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/episodeofcare-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/evidence-quality",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/ex-benefitcategory",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/ex-diagnosis-on-admission",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/ex-diagnosisrelatedgroup",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/ex-diagnosistype",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/ex-payee-resource-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/device-kind",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/ex-paymenttype",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/ex-procedure-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/ex-program-code",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/ex-revenue-center",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/expansion-parameter-source",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/expansion-processing-rule",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/financial-taskcode",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/financial-taskinputtype",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/flag-category",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/forms",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/fundsreserve",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/goal-acceptance-status",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/goal-achievement",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/goal-category",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/goal-priority",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/goal-relationship-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/guide-parameter-code",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/handling-condition",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/ndh-healthcare-service-category",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/history-absent-reason",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/hl7-work-group",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/image-reference-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/immunization-evaluation-dose-status-reason",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/immunization-evaluation-dose-status",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/immunization-function",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/immunization-funding-source",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/immunization-program-eligibility",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/immunization-recommendation-status",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/immunization-subpotent-reason",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/implantStatus",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/insuranceplan-applicability",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/insuranceplan-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/insurance-product-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/insuranceplan-plan-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/insurance-coverage-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/library-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/list-empty-reason",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/list-example-codes",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/list-order",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/location-physical-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/match-grade",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/measure-data-usage",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/measure-improvement-notation",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/measure-population",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/measure-scoring",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/measure-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/med-admin-perform-function",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/medical-management-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/medicationdispense-performer-function",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/medicationknowledge-characteristic",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/medicationknowledge-package-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/medicationknowledge-status",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/medicationrequest-category",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/medicationrequest-course-of-therapy",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/medicationrequest-status-reason",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/message-reason-encounter",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/missing-tooth-reason",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/nutrition-intake-category",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/object-role",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/observation-category",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/observation-statistics",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/organization-affiliation-role",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/organization-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/organization-alias-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/parameter-group",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/payeetype",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/payment-adjustment-reason",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/payment-status",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/payment-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/plan-definition-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/procedure-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/process-priority",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/program",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/provenance-agent-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/provider-qualification",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/question-max-occurs",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/questionnaire-usage-mode",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/reaction-event-certainty",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/reason-medication-given-codes",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/recommendation-strength",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/referencerange-meaning",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/rejection-criteria",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/related-claim-relationship",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/research-study-objective-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/research-study-party-role",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/research-study-phase",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/research-study-prim-purp-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/research-study-reason-stopped",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/research-study-status",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/research-subject-milestones",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/research-subject-state-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/research-subject-state",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/resource-security-category",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/resource-type-link",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/risk-probability",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/service-category",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/service-delivery-method",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/service-place",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/service-provision-conditions",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/service-referral-method",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/service-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/service-uscls",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/smart-capabilities",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/software-system-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/special-values",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/standards-status",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/state-change-reason",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/statistic-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/study-design",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/study-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/subscriber-relationship",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/subscription-channel-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/subscription-error",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/subscription-status-at-event",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/subscription-tag",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/substance-category",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/supplydelivery-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/supplyrequest-kind",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/supplyrequest-reason",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/surface",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/synthesis-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/testscript-operation-codes",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/testscript-profile-destination-types",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/testscript-profile-origin-types",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/tooth",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/ucum-common",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/ucum-units",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/usage-context-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/variant-state",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/verificationresult-can-push-updates",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/verificationresult-communication-method",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/verificationresult-failure-action",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/verificationresult-need",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/verificationresult-primary-source-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/verificationresult-push-type-available",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/verificationresult-validation-process",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/verificationresult-validation-status",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/verificationresult-validation-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/vision-product",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/clinical-discharge-disposition",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/appropriateness-score",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/gender-identity",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/pronouns",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/recorded-sex-or-gender-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/sex-parameter-for-clinical-use",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/jurisdiction",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/virtual-healthcare-delivery-method",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/devicealert-activationState",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/devicealert-condition",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/devicealert-priority",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/artifact-relationship-type",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/group-code",
        "type" : "ValueSet"
      }
    },
    {
      "item" : {
        "reference" : "ValueSet/time-period-ranges",
        "type" : "ValueSet"
      }
    }
  ]
}

```
