# Orderable Drug Form - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Orderable Drug Form**

## CodeSystem: Orderable Drug Form 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-orderableDrugForm | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:OrderableDrugForm |
| *Other Identifiers:*OID:2.16.840.1.113883.5.85 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
**OpenIssue:** Missing description. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AdministrableDrugForm](ValueSet-v3-AdministrableDrugForm.md)
* [AerosolDrugForm](ValueSet-v3-AerosolDrugForm.md)
* [BarDrugForm](ValueSet-v3-BarDrugForm.md)
* [BarSoapDrugForm](ValueSet-v3-BarSoapDrugForm.md)
* [BuccalTablet](ValueSet-v3-BuccalTablet.md)
* [CapsuleDrugForm](ValueSet-v3-CapsuleDrugForm.md)
* [CreamDrugForm](ValueSet-v3-CreamDrugForm.md)
* [DispensableDrugForm](ValueSet-v3-DispensableDrugForm.md)
* [DropsDrugForm](ValueSet-v3-DropsDrugForm.md)
* [EntericCoatedCapsule](ValueSet-v3-EntericCoatedCapsule.md)
* [EntericCoatedTablet](ValueSet-v3-EntericCoatedTablet.md)
* [ExtendedReleaseCapsule](ValueSet-v3-ExtendedReleaseCapsule.md)
* [ExtendedReleaseSuspension](ValueSet-v3-ExtendedReleaseSuspension.md)
* [ExtendedReleaseTablet](ValueSet-v3-ExtendedReleaseTablet.md)
* [FoamDrugForm](ValueSet-v3-FoamDrugForm.md)
* [GasDrugForm](ValueSet-v3-GasDrugForm.md)
* [GasLiquidMixture](ValueSet-v3-GasLiquidMixture.md)
* [GasSolidSpray](ValueSet-v3-GasSolidSpray.md)
* [GelDrugForm](ValueSet-v3-GelDrugForm.md)
* [InhalantDrugForm](ValueSet-v3-InhalantDrugForm.md)
* [IrrigationSolution](ValueSet-v3-IrrigationSolution.md)
* [Liquid](ValueSet-v3-Liquid.md)
* [LiquidCleanser](ValueSet-v3-LiquidCleanser.md)
* [LiquidLiquidEmulsion](ValueSet-v3-LiquidLiquidEmulsion.md)
* [LiquidSolidSuspension](ValueSet-v3-LiquidSolidSuspension.md)
* [LotionDrugForm](ValueSet-v3-LotionDrugForm.md)
* [OilDrugForm](ValueSet-v3-OilDrugForm.md)
* [OintmentDrugForm](ValueSet-v3-OintmentDrugForm.md)
* [OralCapsule](ValueSet-v3-OralCapsule.md)
* [OralSolution](ValueSet-v3-OralSolution.md)
* [OralSuspension](ValueSet-v3-OralSuspension.md)
* [OralTablet](ValueSet-v3-OralTablet.md)
* [OrderableDrugForm](ValueSet-v3-OrderableDrugForm.md)
* [PadDrugForm](ValueSet-v3-PadDrugForm.md)
* [PasteDrugForm](ValueSet-v3-PasteDrugForm.md)
* [PatchDrugForm](ValueSet-v3-PatchDrugForm.md)
* [PillDrugForm](ValueSet-v3-PillDrugForm.md)
* [PowderDrugForm](ValueSet-v3-PowderDrugForm.md)
* [SolidDrugForm](ValueSet-v3-SolidDrugForm.md)
* [SolutionDrugForm](ValueSet-v3-SolutionDrugForm.md)
* [SuppositoryDrugForm](ValueSet-v3-SuppositoryDrugForm.md)
* [SuspensionDrugForm](ValueSet-v3-SuspensionDrugForm.md)
* [SwabDrugForm](ValueSet-v3-SwabDrugForm.md)
* [TabletDrugForm](ValueSet-v3-TabletDrugForm.md)
* [TopicalPowder](ValueSet-v3-TopicalPowder.md)
* [TopicalSolution](ValueSet-v3-TopicalSolution.md)
* [TransdermalPatch](ValueSet-v3-TransdermalPatch.md)
* [VaginalCream](ValueSet-v3-VaginalCream.md)
* [VaginalFoam](ValueSet-v3-VaginalFoam.md)
* [VaginalGel](ValueSet-v3-VaginalGel.md)
* [VaginalOintment](ValueSet-v3-VaginalOintment.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-orderableDrugForm",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-orderableDrugForm",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.85"
    }
  ],
  "version" : "3.0.0",
  "name" : "OrderableDrugForm",
  "title" : "Orderable Drug Form",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "*OpenIssue:* Missing description.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state.  Normally is not populated unless the state is retired..",
      "type" : "code"
    },
    {
      "code" : "notSelectable",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "description" : "Indicates that the code is abstract - only intended to be used as a selector for other concepts",
      "type" : "boolean"
    },
    {
      "code" : "subsumedBy",
      "uri" : "http://hl7.org/fhir/concept-properties#parent",
      "description" : "The concept code of a parent concept",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "_AdministrableDrugForm",
      "display" : "AdministrableDrugForm",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21101"
        }
      ]
    },
    {
      "code" : "_DispensableDrugForm",
      "display" : "DispensableDrugForm",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21102"
        }
      ]
    },
    {
      "code" : "APPFUL",
      "display" : "Applicatorful",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14572"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_AdministrableDrugForm"
        }
      ]
    },
    {
      "code" : "DROP",
      "display" : "Drops",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14420"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_AdministrableDrugForm"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SOL"
        }
      ]
    },
    {
      "code" : "PUFF",
      "display" : "Puff",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14571"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_AdministrableDrugForm"
        }
      ]
    },
    {
      "code" : "SCOOP",
      "display" : "Scoops",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14574"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_AdministrableDrugForm"
        }
      ]
    },
    {
      "code" : "SPRY",
      "display" : "Sprays",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14573"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_AdministrableDrugForm"
        }
      ]
    },
    {
      "code" : "_GasDrugForm",
      "display" : "GasDrugForm",
      "definition" : "Any elastic aeriform fluid in which the molecules are separated from one another and have free paths.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21103"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_DispensableDrugForm"
        }
      ]
    },
    {
      "code" : "_GasLiquidMixture",
      "display" : "GasLiquidMixture",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21104"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_DispensableDrugForm"
        }
      ]
    },
    {
      "code" : "_GasSolidSpray",
      "display" : "GasSolidSpray",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21105"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_DispensableDrugForm"
        }
      ]
    },
    {
      "code" : "_Liquid",
      "display" : "Liquid",
      "definition" : "A state of substance that is an intermediate one entered into as matter goes from solid to gas; liquids are also intermediate in that they have neither the orderliness of a crystal nor the randomness of a gas. (Note: This term should not be used to describe solutions, only pure chemicals in their liquid state.)",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21106"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_DispensableDrugForm"
        }
      ]
    },
    {
      "code" : "_LiquidLiquidEmulsion",
      "display" : "LiquidLiquidEmulsion",
      "definition" : "A two-phase system in which one liquid is dispersed throughout another liquid in the form of small droplets.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21107"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_DispensableDrugForm"
        }
      ]
    },
    {
      "code" : "_LiquidSolidSuspension",
      "display" : "LiquidSolidSuspension",
      "definition" : "A liquid preparation which consists of solid particles dispersed throughout a liquid phase in which the particles are not soluble.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21108"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_DispensableDrugForm"
        }
      ]
    },
    {
      "code" : "_SolidDrugForm",
      "display" : "SolidDrugForm",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21109"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_DispensableDrugForm"
        }
      ]
    },
    {
      "code" : "GASINHL",
      "display" : "Gas for Inhalation",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14569"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_GasDrugForm"
        }
      ]
    },
    {
      "code" : "AER",
      "display" : "Aerosol",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14551"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_GasLiquidMixture"
        }
      ]
    },
    {
      "code" : "DERMSPRY",
      "display" : "Dermal Spray",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14556"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_GasLiquidMixture"
        }
      ]
    },
    {
      "code" : "FOAM",
      "display" : "Foam",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14546"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_GasLiquidMixture"
        }
      ]
    },
    {
      "code" : "RECSPRY",
      "display" : "Rectal Spray",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14557"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_GasLiquidMixture"
        }
      ]
    },
    {
      "code" : "VAGSPRY",
      "display" : "Vaginal Spray",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14558"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_GasLiquidMixture"
        }
      ]
    },
    {
      "code" : "INHL",
      "display" : "Inhalant",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14560"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_GasSolidSpray"
        }
      ]
    },
    {
      "code" : "PWDSPRY",
      "display" : "Powder Spray",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14567"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_GasSolidSpray"
        }
      ]
    },
    {
      "code" : "SPRYADAPT",
      "display" : "Spray with Adaptor",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14566"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_GasSolidSpray"
        }
      ]
    },
    {
      "code" : "LIQCLN",
      "display" : "Liquid Cleanser",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14414"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Liquid"
        }
      ]
    },
    {
      "code" : "OIL",
      "display" : "Oil",
      "definition" : "An unctuous, combustible substance which is liquid, or easily liquefiable, on warming, and is soluble in ether but insoluble in water. Such substances, depending on their origin, are classified as animal, mineral, or vegetable oils.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14417"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Liquid"
        }
      ]
    },
    {
      "code" : "SOL",
      "display" : "Solution",
      "definition" : "A liquid preparation that contains one or more chemical substances dissolved, i.e., molecularly dispersed, in a suitable solvent or mixture of mutually miscible solvents.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14419"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_Liquid"
        }
      ]
    },
    {
      "code" : "CRM",
      "display" : "Cream",
      "definition" : "A semisolid dosage form containing one or more drug substances dissolved or dispersed in a suitable base; more recently, the term has been restricted to products consisting of oil-in-water emulsions or aqueous microcrystalline dispersions of long chain fatty acids or alcohols that are water washable and more cosmetically and aesthetically acceptable.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14466"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_LiquidLiquidEmulsion"
        }
      ]
    },
    {
      "code" : "LTN",
      "display" : "Lotion",
      "definition" : "The term \"lotion\" has been used to categorize many topical suspensions, solutions and emulsions intended for application to the skin.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14464"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_LiquidLiquidEmulsion"
        }
      ]
    },
    {
      "code" : "OINT",
      "display" : "Ointment",
      "definition" : "A semisolid preparation intended for external application to the skin or mucous membranes.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14475"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_LiquidLiquidEmulsion"
        }
      ]
    },
    {
      "code" : "GEL",
      "display" : "Gel",
      "definition" : "A semisolid system consisting of either suspensions made up of small inorganic particles or large organic molecules interpenetrated by a liquid.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14442"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_LiquidSolidSuspension"
        }
      ]
    },
    {
      "code" : "PASTE",
      "display" : "Paste",
      "definition" : "A semisolid dosage form that contains one or more drug substances intended for topical application.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14451"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_LiquidSolidSuspension"
        }
      ]
    },
    {
      "code" : "SUSP",
      "display" : "Suspension",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14454"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_LiquidSolidSuspension"
        }
      ]
    },
    {
      "code" : "BAR",
      "display" : "Bar",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14485"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SolidDrugForm"
        }
      ]
    },
    {
      "code" : "BEAD",
      "display" : "Beads",
      "definition" : "A solid dosage form in the shape of a small ball.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14489"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SolidDrugForm"
        }
      ]
    },
    {
      "code" : "CAKE",
      "display" : "Cake",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14490"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SolidDrugForm"
        }
      ]
    },
    {
      "code" : "CEMENT",
      "display" : "Cement",
      "definition" : "A substance that serves to produce solid union between two surfaces.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14491"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SolidDrugForm"
        }
      ]
    },
    {
      "code" : "CRYS",
      "display" : "Crystals",
      "definition" : "A naturally produced angular solid of definite form in which the ultimate units from which it is built up are systematically arranged; they are usually evenly spaced on a regular space lattice.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14492"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SolidDrugForm"
        }
      ]
    },
    {
      "code" : "DISK",
      "display" : "Disk",
      "definition" : "A circular plate-like organ or structure.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14493"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SolidDrugForm"
        }
      ]
    },
    {
      "code" : "FLAKE",
      "display" : "Flakes",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14494"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SolidDrugForm"
        }
      ]
    },
    {
      "code" : "GRAN",
      "display" : "Granules",
      "definition" : "A small particle or grain.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14495"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SolidDrugForm"
        }
      ]
    },
    {
      "code" : "GUM",
      "display" : "ChewingGum",
      "definition" : "A sweetened and flavored insoluble plastic material of various shapes which when chewed, releases a drug substance into the oral cavity.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14496"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SolidDrugForm"
        }
      ]
    },
    {
      "code" : "PAD",
      "display" : "Pad",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14497"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SolidDrugForm"
        }
      ]
    },
    {
      "code" : "PATCH",
      "display" : "Patch",
      "definition" : "A drug delivery system that contains an adhesived backing and that permits its ingredients to diffuse from some portion of it (e.g., the backing itself, a reservoir, the adhesive, or some other component) into the body from the external site where it is applied.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14499"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SolidDrugForm"
        }
      ]
    },
    {
      "code" : "PELLET",
      "display" : "Pellet",
      "definition" : "A small sterile solid mass consisting of a highly purified drug (with or without excipients) made by the formation of granules, or by compression and molding.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14533"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SolidDrugForm"
        }
      ]
    },
    {
      "code" : "PILL",
      "display" : "Pill",
      "definition" : "A small, round solid dosage form containing a medicinal agent intended for oral administration.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14506"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SolidDrugForm"
        }
      ]
    },
    {
      "code" : "POWD",
      "display" : "Powder",
      "definition" : "An intimate mixture of dry, finely divided drugs and/or chemicals that may be intended for internal or external use.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14534"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SolidDrugForm"
        }
      ]
    },
    {
      "code" : "SUPP",
      "display" : "Suppository",
      "definition" : "A solid body of various weights and shapes, adapted for introduction into the rectal, vaginal, or urethral orifice of the human body; they usually melt, soften, or dissolve at body temperature.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14538"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SolidDrugForm"
        }
      ]
    },
    {
      "code" : "SWAB",
      "display" : "Swab",
      "definition" : "A wad of absorbent material usually wound around one end of a small stick and used for applying medication or for removing material from an area.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14542"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SolidDrugForm"
        }
      ]
    },
    {
      "code" : "WAFER",
      "display" : "Wafer",
      "definition" : "A thin slice of material containing a medicinal agent.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14544"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SolidDrugForm"
        }
      ]
    },
    {
      "code" : "BAINHL",
      "display" : "Breath Activated Inhaler",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14553"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "AER"
        }
      ]
    },
    {
      "code" : "INHLSOL",
      "display" : "Inhalant Solution",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14555"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "AER"
        }
      ]
    },
    {
      "code" : "MDINHL",
      "display" : "Metered Dose Inhaler",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14552"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "AER"
        }
      ]
    },
    {
      "code" : "NASSPRY",
      "display" : "Nasal Spray",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14554"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "AER"
        }
      ]
    },
    {
      "code" : "BARSOAP",
      "display" : "Bar Soap",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14486"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "BAR"
        }
      ]
    },
    {
      "code" : "CHEWBAR",
      "display" : "Chewable Bar",
      "definition" : "A solid dosage form usually in the form of a rectangle that is meant to be chewed.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14488"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "BAR"
        }
      ]
    },
    {
      "code" : "MEDBAR",
      "display" : "Medicated Bar Soap",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14487"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "BARSOAP"
        }
      ]
    },
    {
      "code" : "SRBUCTAB",
      "display" : "Sustained Release Buccal Tablet",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14519"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "BUCTAB"
        }
      ]
    },
    {
      "code" : "ORCAP",
      "display" : "Oral Capsule",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14508"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "CAP"
        }
      ]
    },
    {
      "code" : "NASCRM",
      "display" : "Nasal Cream",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14467"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "CRM"
        }
      ]
    },
    {
      "code" : "OPCRM",
      "display" : "Ophthalmic Cream",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14468"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "CRM"
        }
      ]
    },
    {
      "code" : "ORCRM",
      "display" : "Oral Cream",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14469"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "CRM"
        }
      ]
    },
    {
      "code" : "OTCRM",
      "display" : "Otic Cream",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14470"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "CRM"
        }
      ]
    },
    {
      "code" : "RECCRM",
      "display" : "Rectal Cream",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14471"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "CRM"
        }
      ]
    },
    {
      "code" : "TOPCRM",
      "display" : "Topical Cream",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14472"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "CRM"
        }
      ]
    },
    {
      "code" : "VAGCRM",
      "display" : "Vaginal Cream",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14473"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "CRM"
        }
      ]
    },
    {
      "code" : "NDROP",
      "display" : "Nasal Drops",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14422"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "DROP"
        }
      ]
    },
    {
      "code" : "OPDROP",
      "display" : "Ophthalmic Drops",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14421"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "DROP"
        }
      ]
    },
    {
      "code" : "ORDROP",
      "display" : "Oral Drops",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14423"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "DROP"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ORALSOL"
        }
      ]
    },
    {
      "code" : "OTDROP",
      "display" : "Otic Drops",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14424"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "DROP"
        }
      ]
    },
    {
      "code" : "ERECTAB",
      "display" : "Extended Release Enteric Coated Tablet",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14525"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ECTAB"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ERTAB"
        }
      ]
    },
    {
      "code" : "ERENTCAP",
      "display" : "Extended Release Enteric Coated Capsule",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14510"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ENTCAP"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ERCAP"
        }
      ]
    },
    {
      "code" : "ERCAP12",
      "display" : "12 Hour Extended Release Capsule",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14513"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ERCAP"
        }
      ]
    },
    {
      "code" : "ERCAP24",
      "display" : "24 Hour Extended Release Capsule",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14514"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ERCAP"
        }
      ]
    },
    {
      "code" : "ERECCAP",
      "display" : "Extended Release Enteric Coated Capsule",
      "definition" : "*Rationale:* Duplicate of code ERENTCAP. Use code ERENTCAP instead.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "14512"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ERCAP"
        }
      ]
    },
    {
      "code" : "ERSUSP12",
      "display" : "12 Hour Extended-Release Suspension",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14459"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ERSUSP"
        }
      ]
    },
    {
      "code" : "ERSUSP24",
      "display" : "24 Hour Extended Release Suspension",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14460"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ERSUSP"
        }
      ]
    },
    {
      "code" : "ERTAB12",
      "display" : "12 Hour Extended Release Tablet",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14528"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ERTAB"
        }
      ]
    },
    {
      "code" : "ERTAB24",
      "display" : "24 Hour Extended Release Tablet",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14527"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ERTAB"
        }
      ]
    },
    {
      "code" : "FOAMAPL",
      "display" : "Foam with Applicator",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14547"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "FOAM"
        }
      ]
    },
    {
      "code" : "RECFORM",
      "display" : "Rectal foam",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14548"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "FOAM"
        }
      ]
    },
    {
      "code" : "VAGFOAM",
      "display" : "Vaginal foam",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14549"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "FOAM"
        }
      ]
    },
    {
      "code" : "GELAPL",
      "display" : "Gel with Applicator",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14443"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "GEL"
        }
      ]
    },
    {
      "code" : "NASGEL",
      "display" : "Nasal Gel",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14444"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "GEL"
        }
      ]
    },
    {
      "code" : "OPGEL",
      "display" : "Ophthalmic Gel",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14445"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "GEL"
        }
      ]
    },
    {
      "code" : "OTGEL",
      "display" : "Otic Gel",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14446"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "GEL"
        }
      ]
    },
    {
      "code" : "TOPGEL",
      "display" : "Topical Gel",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14447"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "GEL"
        }
      ]
    },
    {
      "code" : "URETHGEL",
      "display" : "Urethral Gel",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14448"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "GEL"
        }
      ]
    },
    {
      "code" : "VAGGEL",
      "display" : "Vaginal Gel",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14449"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "GEL"
        }
      ]
    },
    {
      "code" : "BAINHLPWD",
      "display" : "Breath Activated Powder Inhaler",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14562"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "INHL"
        }
      ]
    },
    {
      "code" : "INHLPWD",
      "display" : "Inhalant Powder",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14561"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "INHL"
        }
      ]
    },
    {
      "code" : "MDINHLPWD",
      "display" : "Metered Dose Powder Inhaler",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14563"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "INHL"
        }
      ]
    },
    {
      "code" : "NASINHL",
      "display" : "Nasal Inhalant",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14564"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "INHL"
        }
      ]
    },
    {
      "code" : "ORINHL",
      "display" : "Oral Inhalant",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14565"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "INHL"
        }
      ]
    },
    {
      "code" : "DOUCHE",
      "display" : "Douche",
      "definition" : "A liquid preparation, intended for the irrigative cleansing of the vagina, that is prepared from powders, liquid solutions, or liquid concentrates and contains one or more chemical substances dissolved in a suitable solvent or mutually miscible solvents.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14428"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "IRSOL"
        }
      ]
    },
    {
      "code" : "ENEMA",
      "display" : "Enema",
      "definition" : "A rectal preparation for therapeutic, diagnostic, or nutritive purposes.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14429"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "IRSOL"
        }
      ]
    },
    {
      "code" : "OPIRSOL",
      "display" : "Ophthalmic Irrigation Solution",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14430"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "IRSOL"
        }
      ]
    },
    {
      "code" : "LIQSOAP",
      "display" : "Medicated Liquid Soap",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14415"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "LIQCLN"
        }
      ]
    },
    {
      "code" : "SHMP",
      "display" : "Shampoo",
      "definition" : "A liquid soap or detergent used to clean the hair and scalp and is often used as a vehicle for dermatologic agents.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14416"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "LIQCLN"
        }
      ]
    },
    {
      "code" : "TOPLTN",
      "display" : "Topical Lotion",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14465"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "LTN"
        }
      ]
    },
    {
      "code" : "TOPOIL",
      "display" : "Topical Oil",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14418"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OIL"
        }
      ]
    },
    {
      "code" : "NASOINT",
      "display" : "Nasal Ointment",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14479"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OINT"
        }
      ]
    },
    {
      "code" : "OINTAPL",
      "display" : "Ointment with Applicator",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14476"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OINT"
        }
      ]
    },
    {
      "code" : "OPOINT",
      "display" : "Ophthalmic Ointment",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14477"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OINT"
        }
      ]
    },
    {
      "code" : "OTOINT",
      "display" : "Otic Ointment",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14478"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OINT"
        }
      ]
    },
    {
      "code" : "RECOINT",
      "display" : "Rectal Ointment",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14480"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OINT"
        }
      ]
    },
    {
      "code" : "TOPOINT",
      "display" : "Topical Ointment",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14481"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OINT"
        }
      ]
    },
    {
      "code" : "VAGOINT",
      "display" : "Vaginal Ointment",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14482"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OINT"
        }
      ]
    },
    {
      "code" : "ELIXIR",
      "display" : "Elixir",
      "definition" : "A clear, pleasantly flavored, sweetened hydroalcoholic liquid containing dissolved medicinal agents; it is intended for oral use.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14432"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ORALSOL"
        }
      ]
    },
    {
      "code" : "RINSE",
      "display" : "Mouthwash/Rinse",
      "definition" : "An aqueous solution which is most often used for its deodorant, refreshing, or antiseptic effect.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14434"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ORALSOL"
        }
      ]
    },
    {
      "code" : "SYRUP",
      "display" : "Syrup",
      "definition" : "An oral solution containing high concentrations of sucrose or other sugars; the term has also been used to include any other liquid dosage form prepared in a sweet and viscid vehicle, including oral suspensions.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14433"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ORALSOL"
        }
      ]
    },
    {
      "code" : "ENTCAP",
      "display" : "Enteric Coated Capsule",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14509"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ORCAP"
        }
      ]
    },
    {
      "code" : "ERCAP",
      "display" : "Extended Release Capsule",
      "definition" : "A solid dosage form in which the drug is enclosed within either a hard or soft soluble container made from a suitable form of gelatin, and which releases a drug (or drugs) in such a manner to allow a reduction in dosing frequency as compared to that drug (or drugs) presented as a conventional dosage form.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14511"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ORCAP"
        }
      ]
    },
    {
      "code" : "ERSUSP",
      "display" : "Extended-Release Suspension",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14458"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ORSUSP"
        }
      ]
    },
    {
      "code" : "BUCTAB",
      "display" : "Buccal Tablet",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14518"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ORTAB"
        }
      ]
    },
    {
      "code" : "CAPLET",
      "display" : "Caplet",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14517"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ORTAB"
        }
      ]
    },
    {
      "code" : "CHEWTAB",
      "display" : "Chewable Tablet",
      "definition" : "A solid dosage form containing medicinal substances with or without suitable diluents that is intended to be chewed, producing a pleasant tasting residue in the oral cavity that is easily swallowed and does not leave a bitter or unpleasant after-taste.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14520"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ORTAB"
        }
      ]
    },
    {
      "code" : "CPTAB",
      "display" : "Coated Particles Tablet",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14521"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ORTAB"
        }
      ]
    },
    {
      "code" : "DISINTAB",
      "display" : "Disintegrating Tablet",
      "definition" : "A solid dosage form containing medicinal substances which disintegrates rapidly, usually within a matter of seconds, when placed upon the tongue.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14523"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ORTAB"
        }
      ]
    },
    {
      "code" : "DRTAB",
      "display" : "Delayed Release Tablet",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14522"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ORTAB"
        }
      ]
    },
    {
      "code" : "ECTAB",
      "display" : "Enteric Coated Tablet",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14524"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ORTAB"
        }
      ]
    },
    {
      "code" : "ERTAB",
      "display" : "Extended Release Tablet",
      "definition" : "A solid dosage form containing a drug which allows at least a reduction in dosing frequency as compared to that drug presented in conventional dosage form.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14526"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ORTAB"
        }
      ]
    },
    {
      "code" : "ORTROCHE",
      "display" : "Lozenge/Oral Troche",
      "definition" : "A solid preparation containing one or more medicaments, usually in a flavored, sweetened base which is intended to dissolve or disintegrate slowly in the mouth.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14530"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ORTAB"
        }
      ]
    },
    {
      "code" : "SLTAB",
      "display" : "Sublingual Tablet",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14531"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ORTAB"
        }
      ]
    },
    {
      "code" : "MEDPAD",
      "display" : "Medicated Pad",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14498"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "PAD"
        }
      ]
    },
    {
      "code" : "PUD",
      "display" : "Pudding",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14453"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "PASTE"
        }
      ]
    },
    {
      "code" : "TPASTE",
      "display" : "Toothpaste",
      "definition" : "A paste formulation intended to clean and/or polish the teeth, and which may contain certain additional agents.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14452"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "PASTE"
        }
      ]
    },
    {
      "code" : "TPATCH",
      "display" : "Transdermal Patch",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14500"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "PATCH"
        }
      ]
    },
    {
      "code" : "CAP",
      "display" : "Capsule",
      "definition" : "A solid dosage form in which the drug is enclosed within either a hard or soft soluble container or \"shell\" made from a suitable form of gelatin.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14507"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "PILL"
        }
      ]
    },
    {
      "code" : "TAB",
      "display" : "Tablet",
      "definition" : "A solid dosage form containing medicinal substances with or without suitable diluents.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14515"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "PILL"
        }
      ]
    },
    {
      "code" : "TOPPWD",
      "display" : "Topical Powder",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14535"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "POWD"
        }
      ]
    },
    {
      "code" : "IPSOL",
      "display" : "Intraperitoneal Solution",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14425"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SOL"
        }
      ]
    },
    {
      "code" : "IRSOL",
      "display" : "Irrigation Solution",
      "definition" : "A sterile solution intended to bathe or flush open wounds or body cavities; they're used topically, never parenterally.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14427"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SOL"
        }
      ]
    },
    {
      "code" : "IVSOL",
      "display" : "Intravenous Solution",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14426"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SOL"
        }
      ]
    },
    {
      "code" : "ORALSOL",
      "display" : "Oral Solution",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14431"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SOL"
        }
      ]
    },
    {
      "code" : "RECSOL",
      "display" : "Rectal Solution",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14436"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SOL"
        }
      ]
    },
    {
      "code" : "TOPSOL",
      "display" : "Topical Solution",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14437"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SOL"
        }
      ]
    },
    {
      "code" : "RECSUPP",
      "display" : "Rectal Suppository",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14539"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SUPP"
        }
      ]
    },
    {
      "code" : "URETHSUPP",
      "display" : "Urethral suppository",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14541"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SUPP"
        }
      ]
    },
    {
      "code" : "VAGSUPP",
      "display" : "Vaginal Suppository",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14540"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SUPP"
        }
      ]
    },
    {
      "code" : "ITSUSP",
      "display" : "Intrathecal Suspension",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14455"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SUSP"
        }
      ]
    },
    {
      "code" : "OPSUSP",
      "display" : "Ophthalmic Suspension",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14456"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SUSP"
        }
      ]
    },
    {
      "code" : "ORSUSP",
      "display" : "Oral Suspension",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14457"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SUSP"
        }
      ]
    },
    {
      "code" : "OTSUSP",
      "display" : "Otic Suspension",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14461"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SUSP"
        }
      ]
    },
    {
      "code" : "RECSUSP",
      "display" : "Rectal Suspension",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14462"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SUSP"
        }
      ]
    },
    {
      "code" : "MEDSWAB",
      "display" : "Medicated swab",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14543"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SWAB"
        }
      ]
    },
    {
      "code" : "ORTAB",
      "display" : "Oral Tablet",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14516"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "TAB"
        }
      ]
    },
    {
      "code" : "VAGTAB",
      "display" : "Vaginal Tablet",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14532"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "TAB"
        }
      ]
    },
    {
      "code" : "RECPWD",
      "display" : "Rectal Powder",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14536"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "TOPPWD"
        }
      ]
    },
    {
      "code" : "VAGPWD",
      "display" : "Vaginal Powder",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14537"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "TOPPWD"
        }
      ]
    },
    {
      "code" : "LIN",
      "display" : "Liniment",
      "definition" : "A solution or mixture of various substances in oil, alcoholic solutions of soap, or emulsions intended for external application.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14438"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "TOPSOL"
        }
      ]
    },
    {
      "code" : "MUCTOPSOL",
      "display" : "Mucous Membrane Topical Solution",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14440"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "TOPSOL"
        }
      ]
    },
    {
      "code" : "TINC",
      "display" : "Tincture",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14439"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "TOPSOL"
        }
      ]
    },
    {
      "code" : "TPATH16",
      "display" : "16 Hour Transdermal Patch",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14501"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "TPATCH"
        }
      ]
    },
    {
      "code" : "TPATH24",
      "display" : "24 Hour Transdermal Patch",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14502"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "TPATCH"
        }
      ]
    },
    {
      "code" : "TPATH2WK",
      "display" : "Biweekly Transdermal Patch",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14505"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "TPATCH"
        }
      ]
    },
    {
      "code" : "TPATH72",
      "display" : "72 Hour Transdermal Patch",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14503"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "TPATCH"
        }
      ]
    },
    {
      "code" : "TPATHWK",
      "display" : "Weekly Transdermal Patch",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14504"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "TPATCH"
        }
      ]
    },
    {
      "code" : "VAGCRMAPL",
      "display" : "Vaginal Cream with Applicator",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14474"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "VAGCRM"
        }
      ]
    },
    {
      "code" : "VAGFOAMAPL",
      "display" : "Vaginal foam with applicator",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14550"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "VAGFOAM"
        }
      ]
    },
    {
      "code" : "VGELAPL",
      "display" : "Vaginal Gel with Applicator",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14450"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "VAGGEL"
        }
      ]
    },
    {
      "code" : "VAGOINTAPL",
      "display" : "Vaginal Ointment with Applicator",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14483"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "VAGOINT"
        }
      ]
    }
  ]
}

```
