# SubstitutionCondition - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SubstitutionCondition**

## CodeSystem: SubstitutionCondition 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-SubstitutionCondition | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:SubstitutionCondition |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1071 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Identifies what sort of change is permitted or has occurred between the item that was ordered/requested and the one that was/will be provided. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Conditional](ValueSet-v3-Conditional.md)
* [SubstitutionCondition](ValueSet-v3-SubstitutionCondition.md)
* [XSubstitutionConditionNoneOrUnconditional](ValueSet-v3-xSubstitutionConditionNoneOrUnconditional.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-SubstitutionCondition",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-SubstitutionCondition",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1071"
    }
  ],
  "version" : "3.0.0",
  "name" : "SubstitutionCondition",
  "title" : "SubstitutionCondition",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Identifies what sort of change is permitted or has occurred between the item that was ordered/requested and the one that was/will be provided.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "notSelectable",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "description" : "Indicates that the code is abstract - only intended to be used as a selector for other concepts",
      "type" : "boolean"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "_Conditional",
      "display" : "Conditional",
      "definition" : "Some conditions may be attached to an allowable substitution. An allowable substitution is based on a match to any other attributes that may be specified.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21285"
        }
      ],
      "concept" : [
        {
          "code" : "CONFIRM",
          "display" : "Confirm first",
          "definition" : "Confirmation with Contact Person prior to making any substitutions has or will occur.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "17721"
            }
          ]
        },
        {
          "code" : "NOTIFY",
          "display" : "Notify first",
          "definition" : "Notification to the Contact Person, prior to substitution and through normal institutional procedures, has or will be made.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "17722"
            }
          ]
        }
      ]
    },
    {
      "code" : "NOSUB",
      "display" : "No substitution",
      "definition" : "Substitution is not permitted.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21383"
        }
      ]
    },
    {
      "code" : "UNCOND",
      "display" : "Unconditional",
      "definition" : "No conditions are required.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17723"
        }
      ]
    }
  ]
}

```
