# ResponseModality - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ResponseModality**

## CodeSystem: ResponseModality 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-ResponseModality | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ResponseModality |
| *Other Identifiers:*OID:2.16.840.1.113883.5.109 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Defines the timing and grouping of the response instances. 
**OpenIssue:** Description copied from Concept Domain of same name. Must be verified. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ResponseModality](ValueSet-v3-ResponseModality.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-ResponseModality",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-ResponseModality",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.109"
    }
  ],
  "version" : "3.0.0",
  "name" : "ResponseModality",
  "title" : "ResponseModality",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Defines the timing and grouping of the response instances.\r\n\r\n*OpenIssue:* Description copied from Concept Domain of same name. Must be verified.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "B",
      "display" : "Batch",
      "definition" : "Query response to be sent as an HL7 Batch.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10153"
        }
      ]
    },
    {
      "code" : "R",
      "display" : "Real Time",
      "definition" : "Query response to occur in real time.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10151"
        }
      ]
    },
    {
      "code" : "T",
      "display" : "Bolus",
      "definition" : "Query response to sent as a series of responses at the same time without the use of batch formatting.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10152"
        }
      ]
    }
  ]
}

```
