# RelationalOperator - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **RelationalOperator**

## CodeSystem: RelationalOperator 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-RelationalOperator | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:RelationalOperator |
| *Other Identifiers:*OID:2.16.840.1.113883.5.105 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Identifies common relational operators used in selection criteria. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [RelationalOperator](ValueSet-v3-RelationalOperator.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-RelationalOperator",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-RelationalOperator",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.105"
    }
  ],
  "version" : "3.0.0",
  "name" : "RelationalOperator",
  "title" : "RelationalOperator",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Identifies common relational operators used in selection criteria.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "CT",
      "display" : "Contains",
      "definition" : "Specified set of things includes value being evaluated.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10170"
        }
      ]
    },
    {
      "code" : "EQ",
      "display" : "Equal",
      "definition" : "Equal condition applied to comparisons.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10164"
        }
      ]
    },
    {
      "code" : "GE",
      "display" : "Greater than or equal",
      "definition" : "Greater than or equal condition applied to comparisons.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10169"
        }
      ]
    },
    {
      "code" : "GN",
      "display" : "Generic",
      "definition" : "A generic comparison selects a record for inclusion in the response if the beginning of the designated element value matches the select string.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10171"
        }
      ]
    },
    {
      "code" : "GT",
      "display" : "Greater than",
      "definition" : "Greater than condition applied to comparisons.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10167"
        }
      ]
    },
    {
      "code" : "LE",
      "display" : "Less than or equal",
      "definition" : "Less than or equal condition applied to comparisons.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10168"
        }
      ]
    },
    {
      "code" : "LT",
      "display" : "Less than",
      "definition" : "Less than condition applied to comparisons.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10166"
        }
      ]
    },
    {
      "code" : "NE",
      "display" : "Not Equal",
      "definition" : "Not equal condition applied to comparisons.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10165"
        }
      ]
    }
  ]
}

```
