# ProcessingMode - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ProcessingMode**

## CodeSystem: ProcessingMode 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-ProcessingMode | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ProcessingMode |
| *Other Identifiers:*OID:2.16.840.1.113883.5.101 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
This attribute defines whether the message is being sent in current processing, archive mode, initial load mode, restore from archive mode, etc. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ProcessingMode](ValueSet-v3-ProcessingMode.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-ProcessingMode",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-ProcessingMode",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.101"
    }
  ],
  "version" : "3.0.0",
  "name" : "ProcessingMode",
  "title" : "ProcessingMode",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This attribute defines whether the message is being sent in current processing, archive mode, initial load mode, restore from archive mode, etc.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "A",
      "display" : "Archive",
      "definition" : "Identifies archive mode of processing.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10121"
        }
      ]
    },
    {
      "code" : "I",
      "display" : "Initial load",
      "definition" : "Identifies initial load mode of processing.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10123"
        }
      ]
    },
    {
      "code" : "R",
      "display" : "Restore from archive",
      "definition" : "Identifies restore mode of processing.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10122"
        }
      ]
    },
    {
      "code" : "T",
      "display" : "Current processing",
      "definition" : "Identifies on-line mode of processing.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10124"
        }
      ]
    }
  ]
}

```
