# MessageCondition - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MessageCondition**

## CodeSystem: MessageCondition 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-MessageCondition | *Version*:2.0.1 | |
| Retired as of 2019-03-20 | *Responsible:*Health Level 7 | *Computable Name*:MessageCondition |
| *Other Identifiers:*OID:2.16.840.1.113883.5.80 | | |

 
**Deprecation Comment:** Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used.This isn't referenced in the RIM and is a copy of old v2 codes. It's superseded by AcknowledgementDetailCode 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-MessageCondition",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-MessageCondition",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.80"
    }
  ],
  "version" : "2.0.1",
  "name" : "MessageCondition",
  "title" : "MessageCondition",
  "status" : "retired",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level 7",
  "contact" : [
    {
      "name" : "Health Level Seven"
    }
  ],
  "description" : "**Deprecation Comment:** Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used.This isn't referenced in the RIM and is a copy of old v2 codes. It's superseded by AcknowledgementDetailCode",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "0",
      "display" : "Message accepted",
      "definition" : "Success. Optional, as in version 2.x the AA conveys success. Used for systems that must always return a status code.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10131"
        }
      ]
    },
    {
      "code" : "100",
      "display" : "Sequence error",
      "definition" : "The message elements were not in the proper order, or required elements are missing.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10132"
        }
      ]
    },
    {
      "code" : "101",
      "display" : "Missing required element.",
      "definition" : "A required message element is missing.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10133"
        }
      ]
    },
    {
      "code" : "102",
      "display" : "Data type error",
      "definition" : "An element is represented by a data type that is not compatible with that which is allowable.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10134"
        }
      ]
    },
    {
      "code" : "103",
      "display" : "Table value not found",
      "definition" : "The value received for a common HL7 or user defined table was not found to match allowable table values.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10135"
        }
      ]
    },
    {
      "code" : "200",
      "display" : "Unsupported message type",
      "definition" : "The message type is not supported.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10136"
        }
      ]
    },
    {
      "code" : "201",
      "display" : "Unsupported interaction",
      "definition" : "The identified interaction is not supported.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10137"
        }
      ]
    },
    {
      "code" : "202",
      "display" : "Unsupported ProcessingID",
      "definition" : "The ProcessingID is not supported.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10138"
        }
      ]
    },
    {
      "code" : "203",
      "display" : "Unsupported VersionID",
      "definition" : "The VersionID is not supported.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10139"
        }
      ]
    },
    {
      "code" : "204",
      "display" : "Unknown key identifier",
      "definition" : "The identifier for a patient, order, etc. was not found. Occurs for transactions other than additions.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10140"
        }
      ]
    },
    {
      "code" : "205",
      "display" : "Duplicate key identifier",
      "definition" : "The identifier for a patient, order, etc. already exists. Occurs in response to addition transactions (e.g. new Admit, new Order, etc.).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10141"
        }
      ]
    },
    {
      "code" : "206",
      "display" : "Application record locked",
      "definition" : "The transaction could not be performed at the application storage level, e.g. database locked.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10142"
        }
      ]
    },
    {
      "code" : "207",
      "display" : "Application internal error",
      "definition" : "A catchall for internal errors not explicitly covered by other error codes.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10143"
        }
      ]
    }
  ]
}

```
