# MaterialForm - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MaterialForm**

## CodeSystem: MaterialForm 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-MaterialForm | *Version*:2.0.1 | |
| Retired as of 2019-03-20 | *Responsible:*HL7 | *Computable Name*:MaterialForm |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1127 | | |

 
A value representing the state (solid, liquid, gas) and nature of the material. 
**Open Issue:** There exist no codes in the repository for this coding system; should it be removed? 

 This Code system is referenced in the content logical definition of the following value sets: 

* [MaterialForm](ValueSet-v3-materialForm.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-MaterialForm",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-MaterialForm",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1127"
    }
  ],
  "version" : "2.0.1",
  "name" : "MaterialForm",
  "title" : "MaterialForm",
  "status" : "retired",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "HL7",
  "contact" : [
    {
      "name" : "Health Level Seven"
    }
  ],
  "description" : "A value representing the state (solid, liquid, gas) and nature of the material.\r\n\r\n*Open Issue:*  There exist no codes in the repository for this coding system; should it be removed?",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    }
  ]
}

```
