# ManufacturerModelNameExample - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ManufacturerModelNameExample**

## CodeSystem: ManufacturerModelNameExample (Experimental) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-ManufacturerModelNameExample | *Version*:2.0.0 | |
| Active as of 2022-10-11 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ManufacturerModelNameExample |
| *Other Identifiers:*OID:2.16.840.1.113883.5.156 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
This code system serves to capture the ManufacturerModelName concept domain used to convey a coded name for a device. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ManufacturerModelNameExample](ValueSet-v3-ManufacturerModelNameExample.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-ManufacturerModelNameExample",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-ManufacturerModelNameExample",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.156"
    }
  ],
  "version" : "2.0.0",
  "name" : "ManufacturerModelNameExample",
  "title" : "ManufacturerModelNameExample",
  "status" : "active",
  "experimental" : true,
  "date" : "2022-10-11",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This code system serves to capture the ManufacturerModelName concept domain used to convey a coded name for a device.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : false,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "examplemodel1",
      "display" : "example model name 1",
      "definition" : "an example coded name for a device",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "30000"
        }
      ]
    },
    {
      "code" : "examplemodel2",
      "display" : "example model name 2",
      "definition" : "an example coded name for a device",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "30001"
        }
      ]
    }
  ]
}

```
