# MDFSubjectAreaPrefix - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MDFSubjectAreaPrefix**

## CodeSystem: MDFSubjectAreaPrefix 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-MDFSubjectAreaPrefix | *Version*:2.0.1 | |
| Retired as of 2019-03-20 | *Responsible:*Health Level 7 | *Computable Name*:MDFSubjectAreaPrefix |
| *Other Identifiers:*OID:2.16.840.1.113883.5.78 | | |

 
The standard prefixes used in Rose for RIM subject areas that determine the role or function of each subject area. 
**Deprecation Comment:** Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used. 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-MDFSubjectAreaPrefix",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-MDFSubjectAreaPrefix",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.78"
    }
  ],
  "version" : "2.0.1",
  "name" : "MDFSubjectAreaPrefix",
  "title" : "MDFSubjectAreaPrefix",
  "status" : "retired",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level 7",
  "contact" : [
    {
      "name" : "Health Level Seven"
    }
  ],
  "description" : "The standard prefixes used in Rose for RIM subject areas that determine the role or function of each subject area.\r\n\r\n**Deprecation Comment:** Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used.",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "COI",
      "display" : "Class of Interest",
      "definition" : "Holds classes that are of interest to the committee identified by the rest of the Subject Area Name.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10031"
        }
      ]
    },
    {
      "code" : "DIM",
      "display" : "Domain model",
      "definition" : "Holds a sub-set of the RIM that is the domain information model for the committee identified by the rest of the Subject Area name.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10032"
        }
      ]
    },
    {
      "code" : "RIM",
      "display" : "RIM content",
      "definition" : "Is one of a set of subject areas that hold the classes defined in the Reference Information Model (RIM).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10033"
        }
      ]
    },
    {
      "code" : "STW",
      "display" : "Stewardship",
      "definition" : "Holds classes whose steward is the committee identified by the remaining portions of the Subject Area Name.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10030"
        }
      ]
    }
  ]
}

```
