# ExposureMode - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExposureMode**

## CodeSystem: ExposureMode 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-ExposureMode | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ExposureMode |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1113 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code for the mechanism by which the exposure agent was exchanged or potentially exchanged by the participants involved in the exposure. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ExposureMode](ValueSet-v3-ExposureMode.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-ExposureMode",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-ExposureMode",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1113"
    }
  ],
  "version" : "3.0.0",
  "name" : "ExposureMode",
  "title" : "ExposureMode",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code for the mechanism by which the exposure agent was exchanged or potentially exchanged by the participants involved in the exposure.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "notSelectable",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "description" : "Indicates that the code is abstract - only intended to be used as a selector for other concepts",
      "type" : "boolean"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "_ExposureMode",
      "display" : "ExposureMode",
      "definition" : "Code for the mechanism by which the exposure agent was exchanged or potentially exchanged by the participants involved in the exposure.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22377"
        }
      ],
      "concept" : [
        {
          "code" : "AIRBORNE",
          "display" : "airborne",
          "definition" : "**Description:** Communication of an agent from a living subject or environmental source to a living subject through indirect contact via oral or nasal inhalation.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22379"
            }
          ]
        },
        {
          "code" : "CONTACT",
          "display" : "contact",
          "definition" : "**Description:** Communication of an agent from a living subject or environmental source to a living subject through direct physical contact.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22381"
            }
          ]
        },
        {
          "code" : "FOODBORNE",
          "display" : "foodborne",
          "definition" : "**Description:** Communication of an agent from a food source to a living subject via oral consumption.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22380"
            }
          ]
        },
        {
          "code" : "WATERBORNE",
          "display" : "waterborne",
          "definition" : "**Description:** Communication of an agent to a living subject by contact and/or consumption via an aqueous medium",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22378"
            }
          ]
        }
      ]
    }
  ]
}

```
