# EntityNamePartQualifier - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EntityNamePartQualifier**

## CodeSystem: EntityNamePartQualifier 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-EntityNamePartQualifier | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:EntityNamePartQualifier |
| *Other Identifiers:*OID:2.16.840.1.113883.5.43 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
**OpenIssue:** Needs description 

 This Code system is referenced in the content logical definition of the following value sets: 

* [EntityNamePartQualifier](ValueSet-v3-EntityNamePartQualifier.md)
* [OrganizationNamePartQualifier](ValueSet-v3-OrganizationNamePartQualifier.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-EntityNamePartQualifier",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-EntityNamePartQualifier",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.43"
    }
  ],
  "version" : "3.0.0",
  "name" : "EntityNamePartQualifier",
  "title" : "EntityNamePartQualifier",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "*OpenIssue:* Needs description",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state.  Normally is not populated unless the state is retired..",
      "type" : "code"
    },
    {
      "code" : "notSelectable",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "description" : "Indicates that the code is abstract - only intended to be used as a selector for other concepts",
      "type" : "boolean"
    },
    {
      "code" : "subsumedBy",
      "uri" : "http://hl7.org/fhir/concept-properties#parent",
      "description" : "The concept code of a parent concept",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "_OrganizationNamePartQualifier",
      "display" : "OrganizationNamePartQualifier",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21072"
        }
      ]
    },
    {
      "code" : "PharmaceuticalEntityNamePartQualifiers",
      "display" : "PharmaceuticalEntityNamePartQualifiers",
      "definition" : "**Description:** Medication Name Parts are a means of specifying a range of acceptable \"official\" forms of the name of a product. They are used as patterns against which input name strings may be matched for automatic identification of products from input text reports. While they cover the concepts held under \"doseForm\" or \"route\" or \"strength\" the name parts are not the same and do not fit into a controlled vocabulary in the same way. By specifying up to 8 name parts a much larger range of possible names can be generated.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22979"
        }
      ]
    },
    {
      "code" : "_PersonNamePartQualifier",
      "display" : "PersonNamePartQualifier",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21076"
        }
      ]
    },
    {
      "code" : "AC",
      "display" : "academic",
      "definition" : "Indicates that a prefix like \"Dr.\" or a suffix like \"M.D.\" or \"Ph.D.\" is an academic title.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10668"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_OrganizationNamePartQualifier"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PersonNamePartAffixTypes"
        }
      ]
    },
    {
      "code" : "AD",
      "display" : "adopted",
      "definition" : "The name the person was given at the time of adoption.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21320"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_OrganizationNamePartQualifier"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PersonNamePartChangeQualifier"
        }
      ]
    },
    {
      "code" : "BR",
      "display" : "birth",
      "definition" : "A name that a person had shortly after being born. Usually for family names but may be used to mark given names at birth that may have changed later.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10661"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_OrganizationNamePartQualifier"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PersonNamePartChangeQualifier"
        }
      ]
    },
    {
      "code" : "CL",
      "display" : "callme",
      "definition" : "A callme name is (usually a given name) that is preferred when a person is directly addressed.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10673"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_OrganizationNamePartQualifier"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PersonNamePartMiscQualifier"
        }
      ]
    },
    {
      "code" : "IN",
      "display" : "initial",
      "definition" : "Indicates that a name part is just an initial. Initials do not imply a trailing period since this would not work with non-Latin scripts. Initials may consist of more than one letter, e.g., \"Ph.\" could stand for \"Philippe\" or \"Th.\" for \"Thomas\".",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17938"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_OrganizationNamePartQualifier"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PersonNamePartQualifier"
        }
      ]
    },
    {
      "code" : "LS",
      "display" : "Legal status",
      "definition" : "For organizations a suffix indicating the legal status, e.g., \"Inc.\", \"Co.\", \"AG\", \"GmbH\", \"B.V.\" \"S.A.\", \"Ltd.\" etc.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "15890"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_OrganizationNamePartQualifier"
        }
      ]
    },
    {
      "code" : "NB",
      "display" : "nobility",
      "definition" : "In Europe and Asia, there are still people with nobility titles (aristocrats). German \"von\" is generally a nobility title, not a mere voorvoegsel. Others are \"Earl of\" or \"His Majesty King of...\" etc. Rarely used nowadays, but some systems do keep track of this.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10670"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_OrganizationNamePartQualifier"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PersonNamePartAffixTypes"
        }
      ]
    },
    {
      "code" : "PR",
      "display" : "professional",
      "definition" : "Primarily in the British Imperial culture people tend to have an abbreviation of their professional organization as part of their credential suffices.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10669"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_OrganizationNamePartQualifier"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PersonNamePartAffixTypes"
        }
      ]
    },
    {
      "code" : "SP",
      "display" : "spouse",
      "definition" : "The name assumed from the partner in a marital relationship (hence the \"SP\"). Usually the spouse's family name. Note that no inference about gender can be made from the existence of spouse names.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10665"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_OrganizationNamePartQualifier"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PersonNamePartChangeQualifier"
        }
      ]
    },
    {
      "code" : "TITLE",
      "display" : "title",
      "definition" : "Indicates that a prefix or a suffix is a title that applies to the whole name, not just the adjacent name part.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21462"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_OrganizationNamePartQualifier"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PersonNamePartQualifier"
        }
      ]
    },
    {
      "code" : "VV",
      "display" : "voorvoegsel",
      "definition" : "A Dutch \"voorvoegsel\" is something like \"van\" or \"de\" that might have indicated nobility in the past but no longer so. Similar prefixes exist in other languages such as Spanish, French or Portugese.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10667"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_OrganizationNamePartQualifier"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PersonNamePartAffixTypes"
        }
      ]
    },
    {
      "code" : "_PersonNamePartAffixTypes",
      "display" : "PersonNamePartAffixTypes",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21073"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PersonNamePartQualifier"
        }
      ]
    },
    {
      "code" : "_PersonNamePartChangeQualifier",
      "display" : "PersonNamePartChangeQualifier",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21074"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PersonNamePartQualifier"
        }
      ]
    },
    {
      "code" : "_PersonNamePartMiscQualifier",
      "display" : "PersonNamePartMiscQualifier",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21075"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PersonNamePartQualifier"
        }
      ]
    },
    {
      "code" : "CON",
      "display" : "container name",
      "definition" : "**Description:** This refers to the container if present in the medicinal product name.\r\n\r\nEXAMPLES:\r\n\r\n *  For Optaflu suspension for injection in pre-filled syringe Influenza vaccine (surface antigen, inactivated, prepared in cell culture) (2007/2008 season): pre-filled syringe",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22985"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "PharmaceuticalEntityNamePartQualifiers"
        }
      ]
    },
    {
      "code" : "DEV",
      "display" : "device name",
      "definition" : "**Description:** This refers to the qualifiers in the name for devices and is at the moment mainly applicable to insulins and inhalation products.\r\n\r\nEXAMPLES:\r\n\r\n *  For the medicinal product Actrapid FlexPen 100 IU/ml Solution for injection Subcutaneous use: FlexPen.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22986"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "PharmaceuticalEntityNamePartQualifiers"
        }
      ]
    },
    {
      "code" : "FLAV",
      "display" : "FlavorName",
      "definition" : "**Description:** This refers to a flavor of the medicinal product if present in the medicinal product name.\r\n\r\n**Examples:**\r\n\r\n *  For 'CoughCure Linctus Orange Flavor', the flavor part is \"Orange\"\r\n *  For 'Wonderdrug Syrup Cherry Flavor', the flavor part is \"Cherry\"",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23314"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "PharmaceuticalEntityNamePartQualifiers"
        }
      ]
    },
    {
      "code" : "FORMUL",
      "display" : "FormulationPartName",
      "definition" : "**Description:** This refers to the formulation of the medicinal product if present in the medicinal product name.\r\n\r\n**Examples:**\r\n\r\n *  For 'SpecialMed Sugar Free Cough Syrup', the formulation name part is \"Sugar Free\"\r\n *  For 'QuickCure Gluten-free Bulk Fibre', the formulation name part is \"gluten-free\"",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23312"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "PharmaceuticalEntityNamePartQualifiers"
        }
      ]
    },
    {
      "code" : "FRM",
      "display" : "form name",
      "definition" : "**Description:** This refers to the pharmaceutical form/ if present in the medicinal product name.\r\n\r\nEXAMPLES:\r\n\r\n *  For Agenerase 50 mg soft capsules: Soft Capsules\r\n *  For Ludiomil 25mg-Filmtabletten: Filmtabletten\r\n *  For Optaflu suspension for injection in pre-filled syringe Influenza vaccine (surface antigen, inactivated, prepared in cell culture) (2007/2008 season): suspension for injection",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22983"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "PharmaceuticalEntityNamePartQualifiers"
        }
      ]
    },
    {
      "code" : "INV",
      "display" : "invented name",
      "definition" : "**Description:** This refers to the product name without the trademark or the name of the marketing authorization holder or any other descriptor reflected in the product name and, if appropriate, whether it is intended e.g. for babies, children or adults.\r\n\r\nEXAMPLES:\r\n\r\n *  Agenerase\r\n *  Optaflu\r\n *  Ludiomil",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22980"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "PharmaceuticalEntityNamePartQualifiers"
        }
      ]
    },
    {
      "code" : "POPUL",
      "display" : "TargetPopulationName",
      "definition" : "**Description:** This refers to the target population for the medicinal product if present in the medicinal product name\r\n\r\n**Examples:**\r\n\r\n *  For 'Broncho-Drug 3.5 mg-capsules for children', the target population part is \"children\"\r\n *  For 'Adult Chesty Cough Syrup', the target population part is \"adult\"",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23311"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "PharmaceuticalEntityNamePartQualifiers"
        }
      ]
    },
    {
      "code" : "SCI",
      "display" : "scientific name",
      "definition" : "**Description:** This refers to the product common or scientific name without the trademark or the name of the marketing authorization holder or any other descriptor reflected in the product name.\r\n\r\nEXAMPLES:\r\n\r\n *  For Agenerase: N/A\r\n *  For Optaflu: Influenza vaccine (surface antigen, inactivated, prepared in cell culture) (2007/2008 season)\r\n *  For Ludiomil: N/A",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22981"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "PharmaceuticalEntityNamePartQualifiers"
        }
      ]
    },
    {
      "code" : "STR",
      "display" : "strength name",
      "definition" : "**Description:** This refers to the strength if present in the medicinal product name. The use of decimal points should be accommodated if required.\r\n\r\nEXAMPLES:\r\n\r\n *  For Agenerase 50 mg soft capsules: 50mg\r\n *  For Ludiomil 25mg-Filmtabletten: 25 mg\r\n *  For Optaflu suspension for injection in pre-filled syringe Influenza vaccine (surface antigen, inactivated, prepared in cell culture) (2007/2008 season): N/A",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22982"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "PharmaceuticalEntityNamePartQualifiers"
        }
      ]
    },
    {
      "code" : "TIME",
      "display" : "TimeOrPeriodName",
      "definition" : "**Description:** This refers to a time or time period that may be specified in the text of the medicinal product name\r\n\r\n**Example:**\r\n\r\n *  For an influenza vaccine 'Drug-FLU season 2008/2009', the time/period part is \"2008/2009 season\"",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23313"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "PharmaceuticalEntityNamePartQualifiers"
        }
      ]
    },
    {
      "code" : "TMK",
      "display" : "trademark name",
      "definition" : "**Description:** This refers to trademark/company element if present in the medicinal product name.\r\n\r\nEXAMPLES:\r\n\r\n *  for Insulin Human Winthrop Comb 15: Winthrop",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22987"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "PharmaceuticalEntityNamePartQualifiers"
        }
      ]
    },
    {
      "code" : "USE",
      "display" : "intended use name",
      "definition" : "**Description:** This refers to the intended use if present in the medicinal product name without the trademark or the name of the marketing authorization holder or any other descriptor reflected in the product name.\r\n\r\n**Examples:**\r\n\r\n *  For 'Drug-BI Caplets - Heartburn Relief', the intended use part is: \"Heartburn Relief\"\r\n *  For 'Medicine Honey Syrup for Soothing Coughs' the intended use part is \"Soothing Coughs\"",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22984"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "PharmaceuticalEntityNamePartQualifiers"
        }
      ]
    }
  ]
}

```
