# Possible Concept Code Relationships - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Possible Concept Code Relationships**

## CodeSystem: Possible Concept Code Relationships 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-ConceptCodeRelationship | *Version*:2.0.1 | |
| Retired as of 2019-03-20 | *Responsible:*HL7 | *Computable Name*:ConceptCodeRelationship |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1088 | | |

 
**Deprecation Comment:** Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used. 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-ConceptCodeRelationship",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-ConceptCodeRelationship",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1088"
    }
  ],
  "version" : "2.0.1",
  "name" : "ConceptCodeRelationship",
  "title" : "Possible Concept Code Relationships",
  "status" : "retired",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "HL7",
  "contact" : [
    {
      "name" : "Health Level Seven"
    }
  ],
  "description" : "**Deprecation Comment:** Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used.",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "inverseRelationship",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-inverse-relationship",
      "description" : "Property applies to the ConceptCodeRelationship code system. For each concept, it identifies the name of the inverse relationship.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "hasPart",
      "display" : "has part",
      "definition" : "The target concept is a part or portion of the source concept.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19971"
        },
        {
          "code" : "inverseRelationship",
          "valueCode" : "partOf"
        }
      ]
    },
    {
      "code" : "hasSubtype",
      "display" : "has subtype",
      "definition" : "Target concept is a subtype / subclass or the source (or the target concept implies the source",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19970"
        },
        {
          "code" : "inverseRelationship",
          "valueCode" : "isA"
        }
      ]
    },
    {
      "code" : "smallerThan",
      "display" : "is smaller than",
      "definition" : "The source concept code is \"less than\" the target concept in a strictly ordinal sense.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19972"
        },
        {
          "code" : "inverseRelationship",
          "valueCode" : "greaterThan"
        }
      ]
    }
  ]
}

```
