# AmericanIndianAlaskaNativeLanguages - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AmericanIndianAlaskaNativeLanguages**

## CodeSystem: AmericanIndianAlaskaNativeLanguages 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-AmericanIndianAlaskaNativeLanguages | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AmericanIndianAlaskaNativeLanguages |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1054 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
American Indian and Alaska Native languages currently being used in the United States. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Abenakian](ValueSet-v3-Abenakian.md)
* [Aleut](ValueSet-v3-Aleut.md)
* [Algic](ValueSet-v3-Algic.md)
* [Algonquian](ValueSet-v3-Algonquian.md)
* [AmericanIndianAlaskaNativeLanguages](ValueSet-v3-AmericanIndianAlaskaNativeLanguages.md)
* [Apachean](ValueSet-v3-Apachean.md)
* [ArapahoGrosVentre](ValueSet-v3-ArapahoGrosVentre.md)
* [Arapahoan](ValueSet-v3-Arapahoan.md)
* [Athapaskan](ValueSet-v3-Athapaskan.md)
* [AthapaskanEyak](ValueSet-v3-AthapaskanEyak.md)
* [Caddoan](ValueSet-v3-Caddoan.md)
* [Cahitan](ValueSet-v3-Cahitan.md)
* [CaliforniaAthapaskan](ValueSet-v3-CaliforniaAthapaskan.md)
* [CentralAlaskaYukon](ValueSet-v3-CentralAlaskaYukon.md)
* [CentralMuskogean](ValueSet-v3-CentralMuskogean.md)
* [CentralNumic](ValueSet-v3-CentralNumic.md)
* [CentralSalish](ValueSet-v3-CentralSalish.md)
* [Chimakuan](ValueSet-v3-Chimakuan.md)
* [Chinookan](ValueSet-v3-Chinookan.md)
* [ChiwereWinnebago](ValueSet-v3-ChiwereWinnebago.md)
* [CochimiYuman](ValueSet-v3-CochimiYuman.md)
* [Coosan](ValueSet-v3-Coosan.md)
* [Cree](ValueSet-v3-Cree.md)
* [CreeMontagnais](ValueSet-v3-CreeMontagnais.md)
* [Cupan](ValueSet-v3-Cupan.md)
* [Dakotan](ValueSet-v3-Dakotan.md)
* [Delawaran](ValueSet-v3-Delawaran.md)
* [DeltaCalifornia](ValueSet-v3-DeltaCalifornia.md)
* [Dhegiha](ValueSet-v3-Dhegiha.md)
* [Diegueno](ValueSet-v3-Diegueno.md)
* [EasternAlgonquin](ValueSet-v3-EasternAlgonquin.md)
* [EasternApachean](ValueSet-v3-EasternApachean.md)
* [EasternMiwok](ValueSet-v3-EasternMiwok.md)
* [EskimoAleut](ValueSet-v3-EskimoAleut.md)
* [Eskimoan](ValueSet-v3-Eskimoan.md)
* [Hokan](ValueSet-v3-Hokan.md)
* [InteriorSalish](ValueSet-v3-InteriorSalish.md)
* [InuitInupiaq](ValueSet-v3-InuitInupiaq.md)
* [Iroquoian](ValueSet-v3-Iroquoian.md)
* [Kalapuyan](ValueSet-v3-Kalapuyan.md)
* [Keresan](ValueSet-v3-Keresan.md)
* [KiowaTanoan](ValueSet-v3-KiowaTanoan.md)
* [KoyukonIngalik](ValueSet-v3-KoyukonIngalik.md)
* [KutchinHan](ValueSet-v3-KutchinHan.md)
* [Maiduan](ValueSet-v3-Maiduan.md)
* [MississippiValley](ValueSet-v3-MississippiValley.md)
* [MissouriRiver](ValueSet-v3-MissouriRiver.md)
* [Miwokan](ValueSet-v3-Miwokan.md)
* [Muskogean](ValueSet-v3-Muskogean.md)
* [Nadene](ValueSet-v3-Nadene.md)
* [Nootkan](ValueSet-v3-Nootkan.md)
* [NorthernCaddoan](ValueSet-v3-NorthernCaddoan.md)
* [NorthernIroquoian](ValueSet-v3-NorthernIroquoian.md)
* [Numic](ValueSet-v3-Numic.md)
* [Ojibwayan](ValueSet-v3-Ojibwayan.md)
* [OregonAthapaskan](ValueSet-v3-OregonAthapaskan.md)
* [PacificCoastAthapaskan](ValueSet-v3-PacificCoastAthapaskan.md)
* [Pai](ValueSet-v3-Pai.md)
* [Palaihnihan](ValueSet-v3-Palaihnihan.md)
* [Penutian](ValueSet-v3-Penutian.md)
* [Pidgin](ValueSet-v3-Pidgin.md)
* [PlateauPenutian](ValueSet-v3-PlateauPenutian.md)
* [Pomoan](ValueSet-v3-Pomoan.md)
* [Ritwan](ValueSet-v3-Ritwan.md)
* [River](ValueSet-v3-River.md)
* [Sahaptian](ValueSet-v3-Sahaptian.md)
* [Salishan](ValueSet-v3-Salishan.md)
* [SaukFoxKickapoo](ValueSet-v3-SaukFoxKickapoo.md)
* [SerranoGabrielino](ValueSet-v3-SerranoGabrielino.md)
* [Shasta](ValueSet-v3-Shasta.md)
* [Siouan](ValueSet-v3-Siouan.md)
* [SiouanCatawba](ValueSet-v3-SiouanCatawba.md)
* [SirenikskiYupik](ValueSet-v3-SirenikskiYupik.md)
* [SouthernAlaska](ValueSet-v3-SouthernAlaska.md)
* [SouthernCaddoan](ValueSet-v3-SouthernCaddoan.md)
* [SouthernNumic](ValueSet-v3-SouthernNumic.md)
* [Takelman](ValueSet-v3-Takelman.md)
* [Takic](ValueSet-v3-Takic.md)
* [Tanana](ValueSet-v3-Tanana.md)
* [TananaTutchone](ValueSet-v3-TananaTutchone.md)
* [Taracahitan](ValueSet-v3-Taracahitan.md)
* [Tepiman](ValueSet-v3-Tepiman.md)
* [Tiwa](ValueSet-v3-Tiwa.md)
* [Tsamosan](ValueSet-v3-Tsamosan.md)
* [Tsimshianic](ValueSet-v3-Tsimshianic.md)
* [UpperChinook](ValueSet-v3-UpperChinook.md)
* [Utian](ValueSet-v3-Utian.md)
* [UtoAztecan](ValueSet-v3-UtoAztecan.md)
* [Wakashan](ValueSet-v3-Wakashan.md)
* [WesternApachean](ValueSet-v3-WesternApachean.md)
* [WesternMiwok](ValueSet-v3-WesternMiwok.md)
* [WesternMuskogean](ValueSet-v3-WesternMuskogean.md)
* [WesternNumic](ValueSet-v3-WesternNumic.md)
* [Wintuan](ValueSet-v3-Wintuan.md)
* [Yokutsan](ValueSet-v3-Yokutsan.md)
* [Yukian](ValueSet-v3-Yukian.md)
* [Yuman](ValueSet-v3-Yuman.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-AmericanIndianAlaskaNativeLanguages",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-AmericanIndianAlaskaNativeLanguages",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1054"
    }
  ],
  "version" : "3.0.0",
  "name" : "AmericanIndianAlaskaNativeLanguages",
  "title" : "AmericanIndianAlaskaNativeLanguages",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "American Indian and Alaska Native languages currently being used in the United States.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "notSelectable",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "description" : "Indicates that the code is abstract - only intended to be used as a selector for other concepts",
      "type" : "boolean"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "_Algic",
      "display" : "Algic",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "20952"
        }
      ],
      "concept" : [
        {
          "code" : "_Algonquian",
          "display" : "Algonquian",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "20953"
            }
          ],
          "concept" : [
            {
              "code" : "_Arapahoan",
              "display" : "Arapahoan",
              "property" : [
                {
                  "code" : "notSelectable",
                  "valueBoolean" : true
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "20955"
                }
              ],
              "concept" : [
                {
                  "code" : "_ArapahoGrosVentre",
                  "display" : "ArapahoGrosVentre",
                  "property" : [
                    {
                      "code" : "notSelectable",
                      "valueBoolean" : true
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "20956"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "x-ARP",
                      "display" : "Arapaho",
                      "designation" : [
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Arrapahoe"
                        }
                      ],
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "18151"
                        }
                      ]
                    },
                    {
                      "code" : "x-ATS",
                      "display" : "Gros Ventre",
                      "designation" : [
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "A'ananin"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Ahahnelin"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Ahe"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Atsina"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Fall Indians"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "White Clay People"
                        }
                      ],
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "18144"
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "code" : "_CreeMontagnais",
              "display" : "CreeMontagnais",
              "property" : [
                {
                  "code" : "notSelectable",
                  "valueBoolean" : true
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "20972"
                }
              ],
              "concept" : [
                {
                  "code" : "_Cree",
                  "display" : "Cree",
                  "property" : [
                    {
                      "code" : "notSelectable",
                      "valueBoolean" : true
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "20971"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "x-CRP",
                      "display" : "Western Cree",
                      "designation" : [
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Mitchif"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Plains Cree"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Western Swampy Cree"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Woods Cree"
                        }
                      ],
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "18137"
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "code" : "_EasternAlgonquin",
              "display" : "EasternAlgonquin",
              "property" : [
                {
                  "code" : "notSelectable",
                  "valueBoolean" : true
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "20979"
                }
              ],
              "concept" : [
                {
                  "code" : "_Abenakian",
                  "display" : "Abenakian",
                  "property" : [
                    {
                      "code" : "notSelectable",
                      "valueBoolean" : true
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "20950"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "x-AAQ",
                      "display" : "Eastern Abenaki",
                      "designation" : [
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Eastern Abnaki"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Penobscot"
                        }
                      ],
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "18177"
                        }
                      ]
                    },
                    {
                      "code" : "x-ABE",
                      "display" : "Western Abenaki",
                      "designation" : [
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Abenaki"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Abenaqui"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "St. Francis"
                        }
                      ],
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "18180"
                        }
                      ]
                    },
                    {
                      "code" : "x-MAC",
                      "display" : "Maliseet-Passamaquoddy",
                      "designation" : [
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Malecite-Passamaquoddy"
                        }
                      ],
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "18175"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "_Delawaran",
                  "display" : "Delawaran",
                  "property" : [
                    {
                      "code" : "notSelectable",
                      "valueBoolean" : true
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "20975"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "x-DEL",
                      "display" : "Unami Delaware",
                      "designation" : [
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Delaware"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Lenape"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Lenni-Lenape"
                        }
                      ],
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "18185"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "x-MIC",
                  "display" : "Micmac",
                  "designation" : [
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Restigouche"
                    }
                  ],
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "18172"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "_Ojibwayan",
              "display" : "Ojibwayan",
              "property" : [
                {
                  "code" : "notSelectable",
                  "valueBoolean" : true
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21003"
                }
              ],
              "concept" : [
                {
                  "code" : "x-OJB",
                  "display" : "Southern Ojibwa",
                  "designation" : [
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Chippewa"
                    },
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Mississippi Ojibwa"
                    },
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Saulteaux"
                    },
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Western Ojibwa"
                    }
                  ],
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "18157"
                    }
                  ]
                },
                {
                  "code" : "x-POT",
                  "display" : "Potawatami",
                  "designation" : [
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Pottawotomi"
                    }
                  ],
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "18162"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "_SaukFoxKickapoo",
              "display" : "SaukFoxKickapoo",
              "property" : [
                {
                  "code" : "notSelectable",
                  "valueBoolean" : true
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21016"
                }
              ],
              "concept" : [
                {
                  "code" : "x-KIC",
                  "display" : "Kickapoo",
                  "designation" : [
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Kikapu"
                    }
                  ],
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "18168"
                    }
                  ]
                },
                {
                  "code" : "x-SAC",
                  "display" : "Mesquakie",
                  "designation" : [
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Sac and Fox"
                    },
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Sauk-Fox"
                    }
                  ],
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "18165"
                    }
                  ]
                },
                {
                  "code" : "x-SJW",
                  "display" : "Shawnee",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "18170"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "x-BLC",
              "display" : "Blackfoot",
              "designation" : [
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Pikanii"
                }
              ],
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18133"
                }
              ]
            },
            {
              "code" : "x-CHY",
              "display" : "Cheyenne",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18153"
                }
              ]
            },
            {
              "code" : "x-MEZ",
              "display" : "Menominee",
              "designation" : [
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Menomini"
                }
              ],
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18154"
                }
              ]
            }
          ]
        },
        {
          "code" : "_Ritwan",
          "display" : "Ritwan",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21012"
            }
          ],
          "concept" : [
            {
              "code" : "x-YUR",
              "display" : "Yurok",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18190"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "_Caddoan",
      "display" : "Caddoan",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "20959"
        }
      ],
      "concept" : [
        {
          "code" : "_NorthernCaddoan",
          "display" : "NorthernCaddoan",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21000"
            }
          ],
          "concept" : [
            {
              "code" : "x-ARI",
              "display" : "Arikara",
              "designation" : [
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Arikaree"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Arikari"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Arikaris"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Ree"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Ris"
                }
              ],
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18225"
                }
              ]
            },
            {
              "code" : "x-PAW",
              "display" : "Pawnee",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18231"
                }
              ]
            },
            {
              "code" : "x-WIC",
              "display" : "Wichita",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18232"
                }
              ]
            }
          ]
        },
        {
          "code" : "_SouthernCaddoan",
          "display" : "SouthernCaddoan",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21023"
            }
          ],
          "concept" : [
            {
              "code" : "x-CAD",
              "display" : "Caddo",
              "designation" : [
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Caddoe"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Kado"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Kadohadacho"
                }
              ],
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18234"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "_Chimakuan",
      "display" : "Chimakuan",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "20966"
        }
      ],
      "concept" : [
        {
          "code" : "x-QUI",
          "display" : "Quileute",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "18239"
            }
          ]
        }
      ]
    },
    {
      "code" : "_EskimoAleut",
      "display" : "EskimoAleut",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "20982"
        }
      ],
      "concept" : [
        {
          "code" : "_Aleut",
          "display" : "Aleut",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "20951"
            }
          ],
          "concept" : [
            {
              "code" : "x-ALW",
              "display" : "Aleut",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18222"
                }
              ]
            }
          ]
        },
        {
          "code" : "_Eskimoan",
          "display" : "Eskimoan",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "20983"
            }
          ],
          "concept" : [
            {
              "code" : "_InuitInupiaq",
              "display" : "InuitInupiaq",
              "property" : [
                {
                  "code" : "notSelectable",
                  "valueBoolean" : true
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "20986"
                }
              ],
              "concept" : [
                {
                  "code" : "x-ESI",
                  "display" : "North Alaskan Inuktitut",
                  "designation" : [
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Inupiaq"
                    },
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Inupiat Eskimo"
                    },
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Inupik"
                    },
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "North Alaskan Eskimo"
                    },
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "North Alaskan Inupiaq"
                    }
                  ],
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "18211"
                    }
                  ]
                },
                {
                  "code" : "x-ESK",
                  "display" : "Northwest Alaska Inuktitut",
                  "designation" : [
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Inupiatun"
                    },
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Northwest Alaska Inupiat Eskimo"
                    },
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Seward Peninsula Inupiaq"
                    }
                  ],
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "18217"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "_SirenikskiYupik",
              "display" : "SirenikskiYupik",
              "property" : [
                {
                  "code" : "notSelectable",
                  "valueBoolean" : true
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21021"
                }
              ],
              "concept" : [
                {
                  "code" : "x-EMS",
                  "display" : "Pacific Yupik Gulf",
                  "designation" : [
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Aleut"
                    },
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Alutiiq"
                    },
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Chugach Eskimo"
                    },
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Koniag-Chugach"
                    },
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Pacific Yupik"
                    },
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "South Alaska Eskimo"
                    },
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Sugcestun"
                    },
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Sugpiak Eskimo"
                    },
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Sugpiaq Eskimo"
                    },
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Suk"
                    }
                  ],
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "18199"
                    }
                  ]
                },
                {
                  "code" : "x-ESS",
                  "display" : "Central Siberian Yupik",
                  "designation" : [
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "St. Lawrence Island Eskimo"
                    }
                  ],
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "18194"
                    }
                  ]
                },
                {
                  "code" : "x-ESU",
                  "display" : "Central Alaskan Yupik",
                  "designation" : [
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Central Yupik"
                    },
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "West Alaska Eskimo"
                    }
                  ],
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "18196"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "_Hokan",
      "display" : "Hokan",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "20984"
        }
      ],
      "concept" : [
        {
          "code" : "_CochimiYuman",
          "display" : "CochimiYuman",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "20969"
            }
          ],
          "concept" : [
            {
              "code" : "_Yuman",
              "display" : "Yuman",
              "property" : [
                {
                  "code" : "notSelectable",
                  "valueBoolean" : true
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21045"
                }
              ],
              "concept" : [
                {
                  "code" : "_DeltaCalifornia",
                  "display" : "DeltaCalifornia",
                  "property" : [
                    {
                      "code" : "notSelectable",
                      "valueBoolean" : true
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "20976"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "_Diegueno",
                      "display" : "Diegueno",
                      "property" : [
                        {
                          "code" : "notSelectable",
                          "valueBoolean" : true
                        },
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "20978"
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "x-DIH",
                          "display" : "Kumeyaay",
                          "designation" : [
                            {
                              "language" : "en",
                              "use" : {
                                "system" : "http://snomed.info/sct",
                                "code" : "900000000000013009"
                              },
                              "value" : "Campo"
                            },
                            {
                              "language" : "en",
                              "use" : {
                                "system" : "http://snomed.info/sct",
                                "code" : "900000000000013009"
                              },
                              "value" : "Diegueño"
                            },
                            {
                              "language" : "en",
                              "use" : {
                                "system" : "http://snomed.info/sct",
                                "code" : "900000000000013009"
                              },
                              "value" : "Kamia"
                            },
                            {
                              "language" : "en",
                              "use" : {
                                "system" : "http://snomed.info/sct",
                                "code" : "900000000000013009"
                              },
                              "value" : "Kumiái"
                            }
                          ],
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "18293"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "code" : "x-COC",
                      "display" : "Cocopa",
                      "designation" : [
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Cocopah"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Cucapá"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Delta River Yuman"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Kikima"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Kwikapa"
                        }
                      ],
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "18298"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "_Pai",
                  "display" : "Pai",
                  "property" : [
                    {
                      "code" : "notSelectable",
                      "valueBoolean" : true
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "21006"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "x-YUF",
                      "display" : "Havasupai",
                      "designation" : [
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Upland Yuman"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Upper Colorado River Yuman"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Walapai"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Yavapai"
                        }
                      ],
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "18277"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "_River",
                  "display" : "River",
                  "property" : [
                    {
                      "code" : "notSelectable",
                      "valueBoolean" : true
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "21013"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "x-MOV",
                      "display" : "Mohave",
                      "designation" : [
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Mojave"
                        }
                      ],
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "18289"
                        }
                      ]
                    },
                    {
                      "code" : "x-MRC",
                      "display" : "Maricopa",
                      "designation" : [
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Cocomaricopa"
                        }
                      ],
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "18287"
                        }
                      ]
                    },
                    {
                      "code" : "x-YUM",
                      "display" : "Quechan",
                      "designation" : [
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Kechan"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Quecl"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Yuma"
                        }
                      ],
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "18283"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "_Palaihnihan",
          "display" : "Palaihnihan",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21007"
            }
          ],
          "concept" : [
            {
              "code" : "x-ACH",
              "display" : "Achumawi",
              "designation" : [
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Achomawi"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Pitt River"
                }
              ],
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18249"
                }
              ]
            },
            {
              "code" : "x-ATW",
              "display" : "Atsugewi",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18252"
                }
              ]
            }
          ]
        },
        {
          "code" : "_Pomoan",
          "display" : "Pomoan",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21011"
            }
          ],
          "concept" : [
            {
              "code" : "x-KJU",
              "display" : "Kashaya",
              "designation" : [
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Southwestern Pomo"
                }
              ],
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18272"
                }
              ]
            },
            {
              "code" : "x-PEF",
              "display" : "Northeastern Pomo",
              "designation" : [
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Salt Pomo"
                }
              ],
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18254"
                }
              ]
            },
            {
              "code" : "x-PEO",
              "display" : "Southeastern Pomo",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18256"
                }
              ]
            },
            {
              "code" : "x-PEQ",
              "display" : "Southern Pomo",
              "designation" : [
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Lower Lake Pomo"
                }
              ],
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18270"
                }
              ]
            },
            {
              "code" : "x-POO",
              "display" : "Central Pomo",
              "designation" : [
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Ballo-Kai-Pomo"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Cabanapo"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Habenapo"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "H'hana"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Kábinapek"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Khabenapo"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Khana"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Kulanapan"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Kulanapo"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Venaambakaia"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Venambakaiia"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Yokaia"
                }
              ],
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18257"
                }
              ]
            }
          ]
        },
        {
          "code" : "_Shasta",
          "display" : "Shasta",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21018"
            }
          ],
          "concept" : [
            {
              "code" : "x-SHT",
              "display" : "Shasta",
              "designation" : [
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Sastean"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Shastan"
                }
              ],
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18245"
                }
              ]
            }
          ]
        },
        {
          "code" : "x-KYH",
          "display" : "Karok",
          "designation" : [
            {
              "language" : "en",
              "use" : {
                "system" : "http://snomed.info/sct",
                "code" : "900000000000013009"
              },
              "value" : "Karuk"
            }
          ],
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "18242"
            }
          ]
        },
        {
          "code" : "x-WAS",
          "display" : "Washoe",
          "designation" : [
            {
              "language" : "en",
              "use" : {
                "system" : "http://snomed.info/sct",
                "code" : "900000000000013009"
              },
              "value" : "Washo"
            }
          ],
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "18304"
            }
          ]
        }
      ]
    },
    {
      "code" : "_Iroquoian",
      "display" : "Iroquoian",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "20987"
        }
      ],
      "concept" : [
        {
          "code" : "_NorthernIroquoian",
          "display" : "NorthernIroquoian",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21001"
            }
          ],
          "concept" : [
            {
              "code" : "x-CAY",
              "display" : "Cayuga",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18310"
                }
              ]
            },
            {
              "code" : "x-MOH",
              "display" : "Mohawk",
              "designation" : [
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Kanien'kehaka"
                }
              ],
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18313"
                }
              ]
            },
            {
              "code" : "x-ONE",
              "display" : "Oneida",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18315"
                }
              ]
            },
            {
              "code" : "x-ONO",
              "display" : "Onondaga",
              "designation" : [
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Onandaga"
                }
              ],
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18311"
                }
              ]
            },
            {
              "code" : "x-SEE",
              "display" : "Seneca",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18309"
                }
              ]
            },
            {
              "code" : "x-TUS",
              "display" : "Tuscarora",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18308"
                }
              ]
            }
          ]
        },
        {
          "code" : "x-CER",
          "display" : "Cherokee",
          "designation" : [
            {
              "language" : "en",
              "use" : {
                "system" : "http://snomed.info/sct",
                "code" : "900000000000013009"
              },
              "value" : "Tsalagi"
            },
            {
              "language" : "en",
              "use" : {
                "system" : "http://snomed.info/sct",
                "code" : "900000000000013009"
              },
              "value" : "Tslagi"
            }
          ],
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "18316"
            }
          ]
        }
      ]
    },
    {
      "code" : "_Keresan",
      "display" : "Keresan",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "20989"
        }
      ],
      "concept" : [
        {
          "code" : "x-KEE",
          "display" : "Rio Grande Keresan",
          "designation" : [
            {
              "language" : "en",
              "use" : {
                "system" : "http://snomed.info/sct",
                "code" : "900000000000013009"
              },
              "value" : "Eastern Keres Pueblo"
            },
            {
              "language" : "en",
              "use" : {
                "system" : "http://snomed.info/sct",
                "code" : "900000000000013009"
              },
              "value" : "Eastern Keresan"
            }
          ],
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "18324"
            }
          ]
        },
        {
          "code" : "x-KJQ",
          "display" : "Acoma-Laguna",
          "designation" : [
            {
              "language" : "en",
              "use" : {
                "system" : "http://snomed.info/sct",
                "code" : "900000000000013009"
              },
              "value" : "Western Keres"
            },
            {
              "language" : "en",
              "use" : {
                "system" : "http://snomed.info/sct",
                "code" : "900000000000013009"
              },
              "value" : "Western Keres Pueblo"
            },
            {
              "language" : "en",
              "use" : {
                "system" : "http://snomed.info/sct",
                "code" : "900000000000013009"
              },
              "value" : "Western Keresan"
            }
          ],
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "18320"
            }
          ]
        }
      ]
    },
    {
      "code" : "_KiowaTanoan",
      "display" : "KiowaTanoan",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "20990"
        }
      ],
      "concept" : [
        {
          "code" : "_Tiwa",
          "display" : "Tiwa",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21031"
            }
          ],
          "concept" : [
            {
              "code" : "x-TAO",
              "display" : "Northern Tiwa",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18332"
                }
              ]
            },
            {
              "code" : "x-TIX",
              "display" : "Southern Tiwa",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18333"
                }
              ]
            }
          ]
        },
        {
          "code" : "x-KIO",
          "display" : "Kiowa",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "18328"
            }
          ]
        },
        {
          "code" : "x-TEW",
          "display" : "Tewa",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "18334"
            }
          ]
        },
        {
          "code" : "x-TOW",
          "display" : "Jemez",
          "designation" : [
            {
              "language" : "en",
              "use" : {
                "system" : "http://snomed.info/sct",
                "code" : "900000000000013009"
              },
              "value" : "Towa"
            }
          ],
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "18329"
            }
          ]
        }
      ]
    },
    {
      "code" : "_Muskogean",
      "display" : "Muskogean",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "20997"
        }
      ],
      "concept" : [
        {
          "code" : "_CentralMuskogean",
          "display" : "CentralMuskogean",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "20963"
            }
          ],
          "concept" : [
            {
              "code" : "x-AKZ",
              "display" : "Alabama",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18343"
                }
              ]
            },
            {
              "code" : "x-CKU",
              "display" : "Koasati",
              "designation" : [
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Coushatta"
                }
              ],
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18348"
                }
              ]
            },
            {
              "code" : "x-MIK",
              "display" : "Mikasuki",
              "designation" : [
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Hitchiti"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Miccosukee"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Mikasuki Seminole"
                }
              ],
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18344"
                }
              ]
            }
          ]
        },
        {
          "code" : "_WesternMuskogean",
          "display" : "WesternMuskogean",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21040"
            }
          ],
          "concept" : [
            {
              "code" : "x-CCT",
              "display" : "Choctaw",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18341"
                }
              ]
            },
            {
              "code" : "x-CIC",
              "display" : "Chickasaw",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18340"
                }
              ]
            }
          ]
        },
        {
          "code" : "x-CRK",
          "display" : "Creek",
          "designation" : [
            {
              "language" : "en",
              "use" : {
                "system" : "http://snomed.info/sct",
                "code" : "900000000000013009"
              },
              "value" : "Muskogee"
            }
          ],
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "18350"
            }
          ]
        }
      ]
    },
    {
      "code" : "_Nadene",
      "display" : "Nadene",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "20998"
        }
      ],
      "concept" : [
        {
          "code" : "_AthapaskanEyak",
          "display" : "AthapaskanEyak",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "20958"
            }
          ],
          "concept" : [
            {
              "code" : "_Athapaskan",
              "display" : "Athapaskan",
              "property" : [
                {
                  "code" : "notSelectable",
                  "valueBoolean" : true
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "20957"
                }
              ],
              "concept" : [
                {
                  "code" : "_Apachean",
                  "display" : "Apachean",
                  "property" : [
                    {
                      "code" : "notSelectable",
                      "valueBoolean" : true
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "20954"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "_EasternApachean",
                      "display" : "EasternApachean",
                      "property" : [
                        {
                          "code" : "notSelectable",
                          "valueBoolean" : true
                        },
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "20980"
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "x-APJ",
                          "display" : "Jicarilla",
                          "designation" : [
                            {
                              "language" : "en",
                              "use" : {
                                "system" : "http://snomed.info/sct",
                                "code" : "900000000000013009"
                              },
                              "value" : "Jicarilla Apache"
                            }
                          ],
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "18408"
                            }
                          ]
                        },
                        {
                          "code" : "x-APL",
                          "display" : "Lipan",
                          "designation" : [
                            {
                              "language" : "en",
                              "use" : {
                                "system" : "http://snomed.info/sct",
                                "code" : "900000000000013009"
                              },
                              "value" : "Lipan Apache"
                            }
                          ],
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "18410"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "code" : "_WesternApachean",
                      "display" : "WesternApachean",
                      "property" : [
                        {
                          "code" : "notSelectable",
                          "valueBoolean" : true
                        },
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "21038"
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "x-APM",
                          "display" : "Mescalero-Chiricahua",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "18406"
                            }
                          ]
                        },
                        {
                          "code" : "x-APW",
                          "display" : "Western Apache",
                          "designation" : [
                            {
                              "language" : "en",
                              "use" : {
                                "system" : "http://snomed.info/sct",
                                "code" : "900000000000013009"
                              },
                              "value" : "Coyotero"
                            }
                          ],
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "18404"
                            }
                          ]
                        },
                        {
                          "code" : "x-NAV",
                          "display" : "Dine",
                          "designation" : [
                            {
                              "language" : "en",
                              "use" : {
                                "system" : "http://snomed.info/sct",
                                "code" : "900000000000013009"
                              },
                              "value" : "Navajo"
                            }
                          ],
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "18401"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "code" : "x-APK",
                      "display" : "Kiowa Apache",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "18412"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "_CentralAlaskaYukon",
                  "display" : "CentralAlaskaYukon",
                  "property" : [
                    {
                      "code" : "notSelectable",
                      "valueBoolean" : true
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "20962"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "_KoyukonIngalik",
                      "display" : "KoyukonIngalik",
                      "property" : [
                        {
                          "code" : "notSelectable",
                          "valueBoolean" : true
                        },
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "20991"
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "x-HOI",
                          "display" : "Holikachuk",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "18368"
                            }
                          ]
                        },
                        {
                          "code" : "x-ING",
                          "display" : "Degexit'an",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "18367"
                            }
                          ]
                        },
                        {
                          "code" : "x-KOY",
                          "display" : "Koyukon",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "18369"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "code" : "_KutchinHan",
                      "display" : "KutchinHan",
                      "property" : [
                        {
                          "code" : "notSelectable",
                          "valueBoolean" : true
                        },
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "20992"
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "x-HAA",
                          "display" : "Han",
                          "designation" : [
                            {
                              "language" : "en",
                              "use" : {
                                "system" : "http://snomed.info/sct",
                                "code" : "900000000000013009"
                              },
                              "value" : "Dawson"
                            },
                            {
                              "language" : "en",
                              "use" : {
                                "system" : "http://snomed.info/sct",
                                "code" : "900000000000013009"
                              },
                              "value" : "Han-Kutchin"
                            },
                            {
                              "language" : "en",
                              "use" : {
                                "system" : "http://snomed.info/sct",
                                "code" : "900000000000013009"
                              },
                              "value" : "Moosehide"
                            }
                          ],
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "18382"
                            }
                          ]
                        },
                        {
                          "code" : "x-KUC",
                          "display" : "Kutchin",
                          "designation" : [
                            {
                              "language" : "en",
                              "use" : {
                                "system" : "http://snomed.info/sct",
                                "code" : "900000000000013009"
                              },
                              "value" : "Gwich'in"
                            }
                          ],
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "18380"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "code" : "_TananaTutchone",
                      "display" : "TananaTutchone",
                      "property" : [
                        {
                          "code" : "notSelectable",
                          "valueBoolean" : true
                        },
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "21028"
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "_Tanana",
                          "display" : "Tanana",
                          "property" : [
                            {
                              "code" : "notSelectable",
                              "valueBoolean" : true
                            },
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "21027"
                            }
                          ],
                          "concept" : [
                            {
                              "code" : "x-TAA",
                              "display" : "Lower Tanana",
                              "property" : [
                                {
                                  "code" : "status",
                                  "valueCode" : "active"
                                },
                                {
                                  "code" : "internalId",
                                  "valueCode" : "18375"
                                }
                              ]
                            },
                            {
                              "code" : "x-TAU",
                              "display" : "Upper Tanana",
                              "designation" : [
                                {
                                  "language" : "en",
                                  "use" : {
                                    "system" : "http://snomed.info/sct",
                                    "code" : "900000000000013009"
                                  },
                                  "value" : "Nabesna"
                                }
                              ],
                              "property" : [
                                {
                                  "code" : "status",
                                  "valueCode" : "active"
                                },
                                {
                                  "code" : "internalId",
                                  "valueCode" : "18377"
                                }
                              ]
                            },
                            {
                              "code" : "x-TCB",
                              "display" : "Tanacross",
                              "property" : [
                                {
                                  "code" : "status",
                                  "valueCode" : "active"
                                },
                                {
                                  "code" : "internalId",
                                  "valueCode" : "18376"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "code" : "x-KUU",
                          "display" : "Upper Kuskokwim",
                          "designation" : [
                            {
                              "language" : "en",
                              "use" : {
                                "system" : "http://snomed.info/sct",
                                "code" : "900000000000013009"
                              },
                              "value" : "Mcgrath Ingalik"
                            }
                          ],
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "18372"
                            }
                          ]
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "_PacificCoastAthapaskan",
                  "display" : "PacificCoastAthapaskan",
                  "property" : [
                    {
                      "code" : "notSelectable",
                      "valueBoolean" : true
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "21005"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "_CaliforniaAthapaskan",
                      "display" : "CaliforniaAthapaskan",
                      "property" : [
                        {
                          "code" : "notSelectable",
                          "valueBoolean" : true
                        },
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "20961"
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "x-HUP",
                          "display" : "Hupa",
                          "designation" : [
                            {
                              "language" : "en",
                              "use" : {
                                "system" : "http://snomed.info/sct",
                                "code" : "900000000000013009"
                              },
                              "value" : "Hoopa"
                            }
                          ],
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "18392"
                            }
                          ]
                        },
                        {
                          "code" : "x-KTW",
                          "display" : "Cahto",
                          "designation" : [
                            {
                              "language" : "en",
                              "use" : {
                                "system" : "http://snomed.info/sct",
                                "code" : "900000000000013009"
                              },
                              "value" : "Batem-da-kai-ee"
                            },
                            {
                              "language" : "en",
                              "use" : {
                                "system" : "http://snomed.info/sct",
                                "code" : "900000000000013009"
                              },
                              "value" : "Kai Po-mo"
                            },
                            {
                              "language" : "en",
                              "use" : {
                                "system" : "http://snomed.info/sct",
                                "code" : "900000000000013009"
                              },
                              "value" : "Kato"
                            },
                            {
                              "language" : "en",
                              "use" : {
                                "system" : "http://snomed.info/sct",
                                "code" : "900000000000013009"
                              },
                              "value" : "Tlokeang"
                            }
                          ],
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "18394"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "code" : "_OregonAthapaskan",
                      "display" : "OregonAthapaskan",
                      "property" : [
                        {
                          "code" : "notSelectable",
                          "valueBoolean" : true
                        },
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "21004"
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "x-TOL",
                          "display" : "Tolowa",
                          "designation" : [
                            {
                              "language" : "en",
                              "use" : {
                                "system" : "http://snomed.info/sct",
                                "code" : "900000000000013009"
                              },
                              "value" : "Smith River"
                            }
                          ],
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "18389"
                            }
                          ]
                        },
                        {
                          "code" : "x-TUU",
                          "display" : "Tututni",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "18388"
                            }
                          ]
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "_SouthernAlaska",
                  "display" : "SouthernAlaska",
                  "property" : [
                    {
                      "code" : "notSelectable",
                      "valueBoolean" : true
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "21022"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "x-AHT",
                      "display" : "Ahtna",
                      "designation" : [
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Ahtena"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Atna"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Copper River"
                        }
                      ],
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "18360"
                        }
                      ]
                    },
                    {
                      "code" : "x-TFN",
                      "display" : "Tanaina",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "18364"
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "code" : "x-EYA",
              "display" : "Eyak",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18357"
                }
              ]
            }
          ]
        },
        {
          "code" : "x-TLI",
          "display" : "Tlingit",
          "designation" : [
            {
              "language" : "en",
              "use" : {
                "system" : "http://snomed.info/sct",
                "code" : "900000000000013009"
              },
              "value" : "Thlinget"
            },
            {
              "language" : "en",
              "use" : {
                "system" : "http://snomed.info/sct",
                "code" : "900000000000013009"
              },
              "value" : "Tlinkit"
            }
          ],
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "18353"
            }
          ]
        }
      ]
    },
    {
      "code" : "_Penutian",
      "display" : "Penutian",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21008"
        }
      ],
      "concept" : [
        {
          "code" : "_Chinookan",
          "display" : "Chinookan",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "20967"
            }
          ],
          "concept" : [
            {
              "code" : "_UpperChinook",
              "display" : "UpperChinook",
              "property" : [
                {
                  "code" : "notSelectable",
                  "valueBoolean" : true
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21034"
                }
              ],
              "concept" : [
                {
                  "code" : "x-WAC",
                  "display" : "Kiksht",
                  "designation" : [
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Cascades-Wasco-Wishram"
                    },
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Multnomah-Clackamas"
                    },
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Upper Chinook"
                    },
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Wasco-Wishram"
                    }
                  ],
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "18416"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "_Coosan",
          "display" : "Coosan",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "20970"
            }
          ],
          "concept" : [
            {
              "code" : "x-COS",
              "display" : "Hanis",
              "designation" : [
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Coos"
                }
              ],
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18422"
                }
              ]
            }
          ]
        },
        {
          "code" : "_Maiduan",
          "display" : "Maiduan",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "20993"
            }
          ],
          "concept" : [
            {
              "code" : "x-MAI",
              "display" : "Northwest Maidu",
              "designation" : [
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Concow"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Digger"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Holólupai"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Konkau"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Konkow"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Maiduan"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Meidoo"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Michopdo"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Nákum"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Secumne"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Sekumne"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Tsamak"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Yuba"
                }
              ],
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18438"
                }
              ]
            },
            {
              "code" : "x-NMU",
              "display" : "Northeast Maidu",
              "designation" : [
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Mountain Maidu"
                }
              ],
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18436"
                }
              ]
            },
            {
              "code" : "x-NSZ",
              "display" : "Nisenan",
              "designation" : [
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Neeshenam"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Nishinam"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Pujuni"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Southern Maidu"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Wapumni"
                }
              ],
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18452"
                }
              ]
            }
          ]
        },
        {
          "code" : "_PlateauPenutian",
          "display" : "PlateauPenutian",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21010"
            }
          ],
          "concept" : [
            {
              "code" : "_Sahaptian",
              "display" : "Sahaptian",
              "property" : [
                {
                  "code" : "notSelectable",
                  "valueBoolean" : true
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21014"
                }
              ],
              "concept" : [
                {
                  "code" : "x-UMA",
                  "display" : "Umatilla",
                  "designation" : [
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Columbia River Sahaptin"
                    }
                  ],
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "18503"
                    }
                  ]
                },
                {
                  "code" : "x-WAA",
                  "display" : "Walla Walla",
                  "designation" : [
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Northeast Sahaptin"
                    }
                  ],
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "18505"
                    }
                  ]
                },
                {
                  "code" : "x-WAR",
                  "display" : "Tenino",
                  "designation" : [
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Warm Springs"
                    }
                  ],
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "18501"
                    }
                  ]
                },
                {
                  "code" : "x-YAK",
                  "display" : "Yakima",
                  "designation" : [
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Northwest Sahaptin"
                    },
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Yakima And Klikitat"
                    }
                  ],
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "18507"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "x-KLA",
              "display" : "Klamath-Modoc",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18499"
                }
              ]
            },
            {
              "code" : "x-NEZ",
              "display" : "Nez Perce",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18510"
                }
              ]
            }
          ]
        },
        {
          "code" : "_Takelman",
          "display" : "Takelman",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21025"
            }
          ],
          "concept" : [
            {
              "code" : "_Kalapuyan",
              "display" : "Kalapuyan",
              "property" : [
                {
                  "code" : "notSelectable",
                  "valueBoolean" : true
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "20988"
                }
              ],
              "concept" : [
                {
                  "code" : "x-KAL",
                  "display" : "Central Kalapuyan",
                  "designation" : [
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Kalapuya"
                    },
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Lukamiute"
                    },
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Santiam"
                    },
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Wapatu"
                    }
                  ],
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "18426"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "_Tsimshianic",
          "display" : "Tsimshianic",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21033"
            }
          ],
          "concept" : [
            {
              "code" : "x-TSI",
              "display" : "Coast Tsimshain",
              "designation" : [
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Chimmezyan"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Coast And Southern Tsimshian"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Sm'algyax"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Tsimpshean"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Zimshian"
                }
              ],
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18512"
                }
              ]
            }
          ]
        },
        {
          "code" : "_Utian",
          "display" : "Utian",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21035"
            }
          ],
          "concept" : [
            {
              "code" : "_Miwokan",
              "display" : "Miwokan",
              "property" : [
                {
                  "code" : "notSelectable",
                  "valueBoolean" : true
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "20996"
                }
              ],
              "concept" : [
                {
                  "code" : "_EasternMiwok",
                  "display" : "EasternMiwok",
                  "property" : [
                    {
                      "code" : "notSelectable",
                      "valueBoolean" : true
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "20981"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "x-CSM",
                      "display" : "Central Sierra Miwok",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "18467"
                        }
                      ]
                    },
                    {
                      "code" : "x-NSQ",
                      "display" : "Northern Sierra Miwok",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "18466"
                        }
                      ]
                    },
                    {
                      "code" : "x-PMW",
                      "display" : "Plains Miwok",
                      "designation" : [
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Valley Miwok"
                        }
                      ],
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "18464"
                        }
                      ]
                    },
                    {
                      "code" : "x-SKD",
                      "display" : "Southern Sierra Miwok",
                      "designation" : [
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Meewoc"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Mewoc"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Me-Wuk"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Miwoc"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Miwokan"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Mokélumne"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Moquelumnan"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "San Raphael"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Talatui"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Talutui"
                        }
                      ],
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "18468"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "_WesternMiwok",
                  "display" : "WesternMiwok",
                  "property" : [
                    {
                      "code" : "notSelectable",
                      "valueBoolean" : true
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "21039"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "x-CSI",
                      "display" : "Coast Miwok",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "18461"
                        }
                      ]
                    },
                    {
                      "code" : "x-LMW",
                      "display" : "Lake Miwok",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "18462"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "_Wintuan",
          "display" : "Wintuan",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21042"
            }
          ],
          "concept" : [
            {
              "code" : "x-WIT",
              "display" : "Wintu-Nomlaki",
              "designation" : [
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Wintu"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Wintun"
                }
              ],
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18432"
                }
              ]
            }
          ]
        },
        {
          "code" : "_Yokutsan",
          "display" : "Yokutsan",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21043"
            }
          ],
          "concept" : [
            {
              "code" : "x-ENH",
              "display" : "Kings River",
              "designation" : [
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Aiticha"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Choinimni"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Chukaimina"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Entimbich"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Kocheyali"
                }
              ],
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18489"
                }
              ]
            },
            {
              "code" : "x-GSH",
              "display" : "Gashowu",
              "designation" : [
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Goshowi"
                }
              ],
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18480"
                }
              ]
            },
            {
              "code" : "x-PYL",
              "display" : "Poso Creek",
              "designation" : [
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Kumachisi"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Paleuyami"
                }
              ],
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18495"
                }
              ]
            },
            {
              "code" : "x-TKH",
              "display" : "Tule-Kaweah",
              "designation" : [
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Bokninuwad"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Kawia"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Wükchamni"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Yawdanchi"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Yokod"
                }
              ],
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18483"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "_Pidgin",
      "display" : "Pidgin",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21009"
        }
      ],
      "concept" : [
        {
          "code" : "x-CHH",
          "display" : "Chinook Wawa",
          "designation" : [
            {
              "language" : "en",
              "use" : {
                "system" : "http://snomed.info/sct",
                "code" : "900000000000013009"
              },
              "value" : "Chinook Jargon"
            },
            {
              "language" : "en",
              "use" : {
                "system" : "http://snomed.info/sct",
                "code" : "900000000000013009"
              },
              "value" : "Chinook Pidgin"
            },
            {
              "language" : "en",
              "use" : {
                "system" : "http://snomed.info/sct",
                "code" : "900000000000013009"
              },
              "value" : "Tshinuk Wawa"
            }
          ],
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "18519"
            }
          ]
        }
      ]
    },
    {
      "code" : "_Salishan",
      "display" : "Salishan",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21015"
        }
      ],
      "concept" : [
        {
          "code" : "_CentralSalish",
          "display" : "CentralSalish",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "20965"
            }
          ],
          "concept" : [
            {
              "code" : "x-CLM",
              "display" : "Clallam",
              "designation" : [
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Klallam"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Na'klallam"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "S'klallam"
                }
              ],
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18528"
                }
              ]
            },
            {
              "code" : "x-LUT",
              "display" : "Lushootseed",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18532"
                }
              ]
            },
            {
              "code" : "x-STR",
              "display" : "Northern Straits",
              "designation" : [
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Straits"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Straits Salish"
                }
              ],
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18525"
                }
              ]
            }
          ]
        },
        {
          "code" : "_InteriorSalish",
          "display" : "InteriorSalish",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "20985"
            }
          ],
          "concept" : [
            {
              "code" : "x-COL",
              "display" : "Columbian",
              "designation" : [
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Columbia-Wenatchi"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Wenatchee-Columbia"
                }
              ],
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18545"
                }
              ]
            },
            {
              "code" : "x-CRD",
              "display" : "Coeur D'alene",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18544"
                }
              ]
            },
            {
              "code" : "x-FLA",
              "display" : "Kalispel",
              "designation" : [
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Flathead-Kalispel"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Kalispel-Flathead"
                }
              ],
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18541"
                }
              ]
            },
            {
              "code" : "x-OKA",
              "display" : "Okanagan",
              "designation" : [
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Okanagan-Colville"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Okanagon"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Okanogan"
                }
              ],
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18548"
                }
              ]
            }
          ]
        },
        {
          "code" : "_Tsamosan",
          "display" : "Tsamosan",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21032"
            }
          ],
          "concept" : [
            {
              "code" : "x-CEA",
              "display" : "Lower Chehalis",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18535"
                }
              ]
            },
            {
              "code" : "x-CJH",
              "display" : "Upper Chehalis",
              "designation" : [
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Chehalis"
                }
              ],
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18536"
                }
              ]
            },
            {
              "code" : "x-COW",
              "display" : "Cowlitz",
              "designation" : [
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Lower Cowlitz"
                }
              ],
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18538"
                }
              ]
            },
            {
              "code" : "x-QUN",
              "display" : "Quinault",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18534"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "_SiouanCatawba",
      "display" : "SiouanCatawba",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21020"
        }
      ],
      "concept" : [
        {
          "code" : "_Siouan",
          "display" : "Siouan",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21019"
            }
          ],
          "concept" : [
            {
              "code" : "_MississippiValley",
              "display" : "MississippiValley",
              "property" : [
                {
                  "code" : "notSelectable",
                  "valueBoolean" : true
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "20994"
                }
              ],
              "concept" : [
                {
                  "code" : "_ChiwereWinnebago",
                  "display" : "ChiwereWinnebago",
                  "property" : [
                    {
                      "code" : "notSelectable",
                      "valueBoolean" : true
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "20968"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "x-IOW",
                      "display" : "Chiwere",
                      "designation" : [
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Iowa-Oto"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Iowa-Otoe"
                        }
                      ],
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "18594"
                        }
                      ]
                    },
                    {
                      "code" : "x-WIN",
                      "display" : "Hocak",
                      "designation" : [
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Hocak Wazijaci"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Hocank"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Hochank"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Hochunk"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Winnebago"
                        }
                      ],
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "18597"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "_Dakotan",
                  "display" : "Dakotan",
                  "property" : [
                    {
                      "code" : "notSelectable",
                      "valueBoolean" : true
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "20974"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "x-ASB",
                      "display" : "Assiniboine",
                      "designation" : [
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Assiniboin"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Hohe"
                        }
                      ],
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "18577"
                        }
                      ]
                    },
                    {
                      "code" : "x-DHG",
                      "display" : "Dakota",
                      "designation" : [
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Dakhota"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Santee"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Santee-Sisseton"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Sioux"
                        }
                      ],
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "18568"
                        }
                      ]
                    },
                    {
                      "code" : "x-LKT",
                      "display" : "Lakota",
                      "designation" : [
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Teton"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Lakhota"
                        }
                      ],
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "18564"
                        }
                      ]
                    },
                    {
                      "code" : "x-NKT",
                      "display" : "Nakota",
                      "designation" : [
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Nakoda"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Yankton"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Yankton-Yanktonais"
                        }
                      ],
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "18573"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "_Dhegiha",
                  "display" : "Dhegiha",
                  "property" : [
                    {
                      "code" : "notSelectable",
                      "valueBoolean" : true
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "20977"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "x-KAA",
                      "display" : "Kansa",
                      "designation" : [
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Kanze"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Kaw"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Konze"
                        }
                      ],
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "18584"
                        }
                      ]
                    },
                    {
                      "code" : "x-OMA",
                      "display" : "Omaha-Ponca",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "18581"
                        }
                      ]
                    },
                    {
                      "code" : "x-OSA",
                      "display" : "Osage",
                      "designation" : [
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Wazhazhe"
                        }
                      ],
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "18582"
                        }
                      ]
                    },
                    {
                      "code" : "x-QUA",
                      "display" : "Quapaw",
                      "designation" : [
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Alkansea"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Arkansas"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Capa"
                        },
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "Ogaxpa"
                        }
                      ],
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "18588"
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "code" : "_MissouriRiver",
              "display" : "MissouriRiver",
              "property" : [
                {
                  "code" : "notSelectable",
                  "valueBoolean" : true
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "20995"
                }
              ],
              "concept" : [
                {
                  "code" : "x-CRO",
                  "display" : "Crow",
                  "designation" : [
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Apsaaloke"
                    }
                  ],
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "18559"
                    }
                  ]
                },
                {
                  "code" : "x-HID",
                  "display" : "Hidatsa",
                  "designation" : [
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Hinatsa"
                    },
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Hiraca"
                    },
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Minitari"
                    }
                  ],
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "18555"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "x-MHQ",
              "display" : "Mandan",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18561"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "_UtoAztecan",
      "display" : "UtoAztecan",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21036"
        }
      ],
      "concept" : [
        {
          "code" : "_Numic",
          "display" : "Numic",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21002"
            }
          ],
          "concept" : [
            {
              "code" : "_CentralNumic",
              "display" : "CentralNumic",
              "property" : [
                {
                  "code" : "notSelectable",
                  "valueBoolean" : true
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "20964"
                }
              ],
              "concept" : [
                {
                  "code" : "x-COM",
                  "display" : "Comanche",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "18616"
                    }
                  ]
                },
                {
                  "code" : "x-PAR",
                  "display" : "Panamint",
                  "designation" : [
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Koso"
                    }
                  ],
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "18612"
                    }
                  ]
                },
                {
                  "code" : "x-SHH",
                  "display" : "Shoshone",
                  "designation" : [
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Shoshoni"
                    }
                  ],
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "18614"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "_SouthernNumic",
              "display" : "SouthernNumic",
              "property" : [
                {
                  "code" : "notSelectable",
                  "valueBoolean" : true
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21024"
                }
              ],
              "concept" : [
                {
                  "code" : "x-KAW",
                  "display" : "Kawaiisu",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "18618"
                    }
                  ]
                },
                {
                  "code" : "x-UTE",
                  "display" : "Ute-Southern Paiute",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "18619"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "_WesternNumic",
              "display" : "WesternNumic",
              "property" : [
                {
                  "code" : "notSelectable",
                  "valueBoolean" : true
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21041"
                }
              ],
              "concept" : [
                {
                  "code" : "x-MON",
                  "display" : "Mono",
                  "designation" : [
                    {
                      "language" : "en",
                      "use" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "900000000000013009"
                      },
                      "value" : "Paviotso"
                    }
                  ],
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "18608"
                    }
                  ]
                },
                {
                  "code" : "x-PAO",
                  "display" : "Northern Paiute-Bannock",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "18609"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "_Takic",
          "display" : "Takic",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21026"
            }
          ],
          "concept" : [
            {
              "code" : "_Cupan",
              "display" : "Cupan",
              "property" : [
                {
                  "code" : "notSelectable",
                  "valueBoolean" : true
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "20973"
                }
              ],
              "concept" : [
                {
                  "code" : "x-CHL",
                  "display" : "Cahuilla",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "18625"
                    }
                  ]
                },
                {
                  "code" : "x-CUP",
                  "display" : "Cupeno",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "18626"
                    }
                  ]
                },
                {
                  "code" : "x-LUI",
                  "display" : "Luiseno",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "18627"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "_SerranoGabrielino",
              "display" : "SerranoGabrielino",
              "property" : [
                {
                  "code" : "notSelectable",
                  "valueBoolean" : true
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21017"
                }
              ],
              "concept" : [
                {
                  "code" : "x-SER",
                  "display" : "Serrano",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "18623"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "_Taracahitan",
          "display" : "Taracahitan",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21029"
            }
          ],
          "concept" : [
            {
              "code" : "_Cahitan",
              "display" : "Cahitan",
              "property" : [
                {
                  "code" : "notSelectable",
                  "valueBoolean" : true
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "20960"
                }
              ],
              "concept" : [
                {
                  "code" : "x-YAQ",
                  "display" : "Yaqui",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "18638"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "_Tepiman",
          "display" : "Tepiman",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21030"
            }
          ],
          "concept" : [
            {
              "code" : "x-PAP",
              "display" : "Papago-Pima",
              "designation" : [
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Nebome"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Nevome"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "O'odham"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "O'othham"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Upper Piman"
                }
              ],
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18630"
                }
              ]
            }
          ]
        },
        {
          "code" : "x-HOP",
          "display" : "Hopi",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "18628"
            }
          ]
        },
        {
          "code" : "x-TUB",
          "display" : "Tubatululabal",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "18620"
            }
          ]
        }
      ]
    },
    {
      "code" : "_Wakashan",
      "display" : "Wakashan",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21037"
        }
      ],
      "concept" : [
        {
          "code" : "_Nootkan",
          "display" : "Nootkan",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "20999"
            }
          ],
          "concept" : [
            {
              "code" : "x-MYH",
              "display" : "Makah",
              "designation" : [
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Kweedishchaaht"
                },
                {
                  "language" : "en",
                  "use" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "900000000000013009"
                  },
                  "value" : "Kwe-Nee-Chee-Aht"
                }
              ],
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "18643"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "_Yukian",
      "display" : "Yukian",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21044"
        }
      ],
      "concept" : [
        {
          "code" : "x-WAO",
          "display" : "Wappo",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "18648"
            }
          ]
        },
        {
          "code" : "x-YUK",
          "display" : "Yuki",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "18647"
            }
          ]
        }
      ]
    },
    {
      "code" : "x-HAI",
      "display" : "Haida",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "18240"
        }
      ]
    },
    {
      "code" : "x-KUN",
      "display" : "Kootenai",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "system" : "http://snomed.info/sct",
            "code" : "900000000000013009"
          },
          "value" : "Ktunaxa"
        },
        {
          "language" : "en",
          "use" : {
            "system" : "http://snomed.info/sct",
            "code" : "900000000000013009"
          },
          "value" : "Kutenai"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "18335"
        }
      ]
    },
    {
      "code" : "x-PSD",
      "display" : "Plains Indian Sign Language",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "18651"
        }
      ]
    },
    {
      "code" : "x-YUC",
      "display" : "Yuchi",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "18639"
        }
      ]
    },
    {
      "code" : "x-ZUN",
      "display" : "Zuni",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "system" : "http://snomed.info/sct",
            "code" : "900000000000013009"
          },
          "value" : "Zuñi"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "18649"
        }
      ]
    }
  ]
}

```
