# ActReason - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ActReason**

## CodeSystem: ActReason 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-ActReason | *Version*:3.1.0 | |
| Active as of 2024-02-28 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ActReason |
| *Other Identifiers:*OID:2.16.840.1.113883.5.8 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
A set of codes specifying the motivation, cause, or rationale of an Act, when such rationale is not reasonably represented as an ActRelationship of type "has reason" linking to another Act. 
**Examples:** Example reasons that might qualify for being coded in this field might be: "routine requirement", "infectious disease reporting requirement", "on patient request", "required by law". 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ActAccommodationReason](ValueSet-v3-ActAccommodationReason.md)
* [ActAntigenInvalidReason](ValueSet-v3-ActAntigenInvalidReason.md)
* [ActConsentInformationAccessOverrideReason](ValueSet-v3-ActConsentInformationAccessOverrideReason.md)
* [ActCoverageReason](ValueSet-v3-ActCoverageReason.md)
* [ActHealthInformationManagementReason](ValueSet-v3-ActHealthInformationManagementReason.md)
* [ActIneligibilityReason](ValueSet-v3-ActIneligibilityReason.md)
* [ActNoImmunizationReason](ValueSet-v3-ActNoImmunizationReason.md)
* [ActReason](ValueSet-v3-ActReason.md)
* [ActSupplyFulfillmentRefusalReason](ValueSet-v3-ActSupplyFulfillmentRefusalReason.md)
* [ClinicalResearchEventReason](ValueSet-v3-ClinicalResearchEventReason.md)
* [ClinicalResearchObservationReason](ValueSet-v3-ClinicalResearchObservationReason.md)
* [ClinicalResearchReason](ValueSet-v3-ClinicalResearchReason.md)
* [CombinedPharmacyOrderSuspendReasonCode](ValueSet-v3-CombinedPharmacyOrderSuspendReasonCode.md)
* [ControlActNullificationReasonCode](ValueSet-v3-ControlActNullificationReasonCode.md)
* [ControlActNullificationRefusalReasonType](ValueSet-v3-ControlActNullificationRefusalReasonType.md)
* [ControlActReason](ValueSet-v3-ControlActReason.md)
* [CoverageEligibilityReason](ValueSet-v3-CoverageEligibilityReason.md)
* [EligibilityActReasonCode](ValueSet-v3-EligibilityActReasonCode.md)
* [GeneralPurposeOfUse](ValueSet-v3-GeneralPurposeOfUse.md)
* [GenericUpdateReasonCode](ValueSet-v3-GenericUpdateReasonCode.md)
* [MedicationOrderAbortReasonCode](ValueSet-v3-MedicationOrderAbortReasonCode.md)
* [MedicationOrderReleaseReasonCode](ValueSet-v3-MedicationOrderReleaseReasonCode.md)
* [ModifyPrescriptionReasonType](ValueSet-v3-ModifyPrescriptionReasonType.md)
* [PatientProfileQueryReasonCode](ValueSet-v3-PatientProfileQueryReasonCode.md)
* [PharmacySupplyEventAbortReason](ValueSet-v3-PharmacySupplyEventAbortReason.md)
* [PharmacySupplyEventStockReasonCode](ValueSet-v3-PharmacySupplyEventStockReasonCode.md)
* [PharmacySupplyRequestFulfillerRevisionRefusalReasonCode](ValueSet-v3-PharmacySupplyRequestFulfillerRevisionRefusalReasonCode.md)
* [PharmacySupplyRequestRenewalRefusalReasonCode](ValueSet-v3-PharmacySupplyRequestRenewalRefusalReasonCode.md)
* [PurposeOfUse](ValueSet-v3-PurposeOfUse.md)
* [RefusalReasonCode](ValueSet-v3-RefusalReasonCode.md)
* [SchedulingActReason](ValueSet-v3-SchedulingActReason.md)
* [StatusRevisionRefusalReasonCode](ValueSet-v3-StatusRevisionRefusalReasonCode.md)
* [SubstanceAdminSubstitutionNotAllowedReason](ValueSet-v3-SubstanceAdminSubstitutionNotAllowedReason.md)
* [SubstanceAdminSubstitutionReason](ValueSet-v3-SubstanceAdminSubstitutionReason.md)
* [SubstanceAdministrationPermissionRefusalReasonCode](ValueSet-v3-SubstanceAdministrationPermissionRefusalReasonCode.md)
* [SupplyOrderAbortReasonCode](ValueSet-v3-SupplyOrderAbortReasonCode.md)
* [TransferActReason](ValueSet-v3-TransferActReason.md)
* [UpdateRefusalReasonCode](ValueSet-v3-UpdateRefusalReasonCode.md)
* [XActEncounterReason](ValueSet-v3-xActEncounterReason.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-ActReason",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.8"
    }
  ],
  "version" : "3.1.0",
  "name" : "ActReason",
  "title" : "ActReason",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-02-28",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "A set of codes specifying the motivation, cause, or rationale of an Act, when such rationale is not reasonably represented as an ActRelationship of type \"has reason\" linking to another Act.\r\n\r\n*Examples:* Example reasons that might qualify for being coded in this field might be: \"routine requirement\", \"infectious disease reporting requirement\", \"on patient request\", \"required by law\".",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state.  Normally is not populated unless the state is retired..",
      "type" : "code"
    },
    {
      "code" : "notSelectable",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "description" : "Indicates that the code is abstract - only intended to be used as a selector for other concepts",
      "type" : "boolean"
    },
    {
      "code" : "HL7usageNotes",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#HL7usageNotes",
      "description" : "HL7 Concept Usage Notes",
      "type" : "string"
    },
    {
      "code" : "subsumedBy",
      "uri" : "http://hl7.org/fhir/concept-properties#parent",
      "description" : "The concept code of a parent concept",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "_ActAccommodationReason",
      "display" : "ActAccommodationReason",
      "definition" : "Identifies the reason the patient is assigned to this accommodation type",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "20937"
        }
      ]
    },
    {
      "code" : "_ActCoverageReason",
      "display" : "ActCoverageReason",
      "definition" : "**Description:**Codes used to specify reasons or criteria relating to coverage provided under a policy or program. May be used to convey reasons pertaining to coverage contractual provisions, including criteria for eligibility, coverage limitations, coverage maximums, or financial participation required of covered parties.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22164"
        }
      ]
    },
    {
      "code" : "_ActInformationManagementReason",
      "display" : "ActInformationManagementReason",
      "definition" : "**Description:**The rationale or purpose for an act relating to information management, such as archiving information for the purpose of complying with an enterprise data retention policy.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22675"
        }
      ]
    },
    {
      "code" : "_ActInvalidReason",
      "display" : "ActInvalidReason",
      "definition" : "**Description:** Types of reasons why a substance is invalid for use.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23235"
        }
      ]
    },
    {
      "code" : "_ActInvoiceCancelReason",
      "display" : "ActInvoiceCancelReason",
      "definition" : "Domain specifies the codes used to describe reasons why a Provider is cancelling an Invoice or Invoice Grouping.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "20941"
        }
      ]
    },
    {
      "code" : "_ActNoImmunizationReason",
      "display" : "ActNoImmunizationReason",
      "definition" : "A coded description of the reason for why a patient did not receive a scheduled immunization.\r\n\r\n(important for public health strategy",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21529"
        }
      ]
    },
    {
      "code" : "_ActSupplyFulfillmentRefusalReason",
      "display" : "ActSupplyFulfillmentRefusalReason",
      "definition" : "Indicates why a fulfiller refused to fulfill a supply order, and considered it important to notify other providers of their decision. E.g. \"Suspect fraud\", \"Possible abuse\", \"Contraindicated\".\r\n\r\n(used when capturing 'refusal to fill' annotations)",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21530"
        }
      ]
    },
    {
      "code" : "_ClinicalResearchEventReason",
      "display" : "ClinicalResearchEventReason",
      "definition" : "**Definition:**Specifies the reason that an event occurred in a clinical research study.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22391"
        }
      ]
    },
    {
      "code" : "_ClinicalResearchObservationReason",
      "display" : "ClinicalResearchObservationReason",
      "definition" : "**Definition:**SSpecifies the reason that a test was performed or observation collected in a clinical research study.\r\n\r\n**Note:**This set of codes are not strictly reasons, but are used in the currently Normative standard. Future revisions of the specification will model these as ActRelationships and thes codes may subsequently be retired. Thus, these codes should not be used for new specifications.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22392"
        }
      ]
    },
    {
      "code" : "_CombinedPharmacyOrderSuspendReasonCode",
      "display" : "CombinedPharmacyOrderSuspendReasonCode",
      "definition" : "**Description:**Indicates why the prescription should be suspended.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22393"
        }
      ]
    },
    {
      "code" : "_ControlActNullificationReasonCode",
      "display" : "ControlActNullificationReasonCode",
      "definition" : "**Description:**Identifies reasons for nullifying (retracting) a particular control act.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22809"
        }
      ]
    },
    {
      "code" : "_ControlActNullificationRefusalReasonType",
      "display" : "ControlActNullificationRefusalReasonType",
      "definition" : "**Description:** Reasons to refuse a transaction to be undone.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23277"
        }
      ]
    },
    {
      "code" : "_ControlActReason",
      "display" : "ControlActReason",
      "definition" : "Identifies why a specific query, request, or other trigger event occurred.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21491"
        }
      ]
    },
    {
      "code" : "_GenericUpdateReasonCode",
      "display" : "GenericUpdateReasonCode",
      "definition" : "**Description:**Identifies why a change is being made to a record.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22395"
        }
      ]
    },
    {
      "code" : "_PatientProfileQueryReasonCode",
      "display" : "patient profile query reason",
      "definition" : "**Definition:**A collection of concepts identifying why the patient's profile is being queried.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21715"
        }
      ]
    },
    {
      "code" : "_PharmacySupplyRequestFulfillerRevisionRefusalReasonCode",
      "display" : "PharmacySupplyRequestFulfillerRevisionRefusalReasonCode",
      "definition" : "**Definition:**Indicates why the request to transfer a prescription from one dispensing facility to another has been refused.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22863"
        }
      ]
    },
    {
      "code" : "_RefusalReasonCode",
      "display" : "RefusalReasonCode",
      "definition" : "**Description:** Identifies why a request to add (or activate) a record is being refused. Examples include the receiving system not able to match the identifier and find that record in the receiving system, having no permission, or a detected issue exists which precludes the requested action.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22906"
        }
      ]
    },
    {
      "code" : "_SchedulingActReason",
      "display" : "SchedulingActReason",
      "definition" : "Reasons for cancelling or rescheduling an Appointment",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "20942"
        }
      ]
    },
    {
      "code" : "_StatusRevisionRefusalReasonCode",
      "display" : "StatusRevisionRefusalReasonCode",
      "definition" : "Indicates why the act revision (status update) is being refused.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23014"
        }
      ]
    },
    {
      "code" : "_SubstanceAdministrationPermissionRefusalReasonCode",
      "display" : "SubstanceAdministrationPermissionRefusalReasonCode",
      "definition" : "**Definition:**Indicates why the requested authorization to prescribe or dispense a medication has been refused.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22856"
        }
      ]
    },
    {
      "code" : "_SubstanceAdminSubstitutionNotAllowedReason",
      "display" : "SubstanceAdminSubstitutionNotAllowedReason",
      "definition" : "Reasons why substitution of a substance administration request is not permitted.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21531"
        }
      ]
    },
    {
      "code" : "_SubstanceAdminSubstitutionReason",
      "display" : "SubstanceAdminSubstitutionReason",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "20943"
        }
      ]
    },
    {
      "code" : "_TransferActReason",
      "display" : "TransferActReason",
      "definition" : "The explanation for why a patient is moved from one location to another within the organization",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "20944"
        }
      ]
    },
    {
      "code" : "_ActAdjudicationReason",
      "display" : "ActAdjudicationReason",
      "definition" : "Explanatory codes that describe reasons why an Adjudicator has financially adjusted an invoice (claim).\r\n\r\nA companion domain (ActAdjudicationInformationCode) includes information reasons which do not have a financial impact on an invoice (claim).\r\n\r\nExample adjudication reason code is AA-CLAIM-0011 - Only Basic Procedure/Test Eligible.\r\n\r\nCodes from this domain further rationalizes ActAdjudicationCodes (e.g. AA - Adjudicated with Adjustment), which are used to describe the process of adjudicating an invoice. For AS - Adjudicated as Submitted, there should be no specification of ActAdjudicationReason codes, as there are no financial adjustments against the invoice.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "20938"
        }
      ]
    },
    {
      "code" : "_ActBillableServiceReason",
      "display" : "ActBillableServiceReason",
      "definition" : "**Definition:** This domain is used to document reasons for providing a billable service; the billable services may include both clinical services and social services.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "22209"
        }
      ]
    },
    {
      "code" : "_ActCoverageLevelRasonCode",
      "display" : "ActCoverageLevelRasonCode",
      "definition" : "**Description:**Represents the reason for the level of coverage provided under the policy or program in terms of the types of entities that may play covered parties based on their personal relationships or employment status.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "22081"
        }
      ]
    },
    {
      "code" : "_ActImmunizationReason",
      "display" : "ActImmunizationReason",
      "definition" : "**Description:**A coded description of the reason for why a patient was administered an immunization.\r\n\r\n**Examples:**Post Exposure - Reason, Universal Immunization Program, Outbreak Control, Universal School Program",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "22077"
        }
      ]
    },
    {
      "code" : "_ConrolActNullificationReasonCode",
      "display" : "ConrolActNullificationReasonCode",
      "definition" : "**Description:**Identifies reasons for nullifying (retracting) a particular control act.\r\n\r\n**Examples:**\"Entered in error\", \"altered decision\", etc.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "22394"
        }
      ]
    },
    {
      "code" : "_NonPerformanceReasonCode",
      "display" : "NonPerformanceReasonCode",
      "definition" : "The reason the action wasn't performed, e.g. why the medication was not taken. If an action wasn\"t performed, it is often clinically important to know why the action wasn\"t taken.\r\n\r\n*Examples:*Patient refused, clinically inappropriate, absolute contraindication etc.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21569"
        }
      ]
    },
    {
      "code" : "_ReasonForNotEvaluatingDevice",
      "display" : "ReasonForNotEvaluatingDevice",
      "definition" : "Code assigned to indicate the rationale for not performing an evaluation investigation on a device for which a defect has been reported.\r\n\r\nExamples include: device received in a condition that made analysis impossible, device evaluation anticipated but not yet begun, device not made by company.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21408"
        }
      ]
    },
    {
      "code" : "_ReferralReasonCode",
      "display" : "ReferralReasonCode",
      "definition" : "The reason a referral was made.\r\n\r\n*Examples:*Specialized Medical Assistance, Other Care Requirements.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21568"
        }
      ]
    },
    {
      "code" : "BONUS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "17436"
        }
      ]
    },
    {
      "code" : "CHD",
      "display" : "Children only",
      "definition" : "**Description:**The level of coverage under the policy or program is available only to children",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "22082"
        }
      ]
    },
    {
      "code" : "DEP",
      "display" : "Dependents only",
      "definition" : "**Description:**The level of coverage under the policy or program is available only to a subscriber's dependents.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "22083"
        }
      ]
    },
    {
      "code" : "ECH",
      "display" : "Employee and children",
      "definition" : "**Description:**The level of coverage under the policy or program is available to an employee and his or her children.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "22084"
        }
      ]
    },
    {
      "code" : "EDU",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "17438"
        }
      ]
    },
    {
      "code" : "EMP",
      "display" : "Employee only",
      "definition" : "**Description:**The level of coverage under the policy or program is available only to an employee.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "22085"
        }
      ]
    },
    {
      "code" : "ESP",
      "display" : "Employee and spouse",
      "definition" : "**Description:**The level of coverage under the policy or program is available to an employee and his or her spouse.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "22086"
        }
      ]
    },
    {
      "code" : "FAM",
      "display" : "Family",
      "definition" : "**Description:**The level of coverage under the policy or program is available to a subscriber's family.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "22087"
        }
      ]
    },
    {
      "code" : "IND",
      "display" : "Individual",
      "definition" : "**Description:**The level of coverage under the policy or program is available to an individual.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "22088"
        }
      ]
    },
    {
      "code" : "INVOICE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "19726"
        }
      ]
    },
    {
      "code" : "PROA",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "17435"
        }
      ]
    },
    {
      "code" : "RECOV",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "17437"
        }
      ]
    },
    {
      "code" : "RETRO",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "17434"
        }
      ]
    },
    {
      "code" : "SPC",
      "display" : "Spouse and children",
      "definition" : "**Description:**The level of coverage under the policy or program is available to a subscriber's spouse and children",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "22089"
        }
      ]
    },
    {
      "code" : "SPO",
      "display" : "Spouse only",
      "definition" : "**Description:**The level of coverage under the policy or program is available only to a subscribers spouse",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "22090"
        }
      ]
    },
    {
      "code" : "TRAN",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "19727"
        }
      ]
    },
    {
      "code" : "ACCREQNA",
      "display" : "Accommodation Requested Not Available",
      "definition" : "Accommodation requested is not available.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17429"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActAccommodationReason"
        }
      ]
    },
    {
      "code" : "FLRCNV",
      "display" : "Floor Convenience",
      "definition" : "Accommodation is assigned for floor convenience.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17430"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActAccommodationReason"
        }
      ]
    },
    {
      "code" : "MEDNEC",
      "display" : "Medical Necessity",
      "definition" : "Required for medical reasons(s).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17428"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActAccommodationReason"
        }
      ]
    },
    {
      "code" : "PAT",
      "display" : "Patient request",
      "definition" : "The Patient requested the action",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14880"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActAccommodationReason"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SchedulingActReason"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SubstanceAdminSubstitutionNotAllowedReason"
        }
      ]
    },
    {
      "code" : "_MedicallyNecessaryDuplicateProcedureReason",
      "display" : "MedicallyNecessaryDuplicateProcedureReason",
      "definition" : "**Definition:** This domain is used to document why the procedure is a duplicate of one ordered/charged previously for the same patient within the same date of service and has been determined to be medically necessary.\r\n\r\n**Example:** A doctor needs a different view in a chest X-Ray.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "22210"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActBillableClinicalServiceReason"
        }
      ]
    },
    {
      "code" : "_ActBillableClinicalServiceReason",
      "display" : "ActBillableClinicalServiceReason",
      "definition" : "Reason for Clinical Service being performed.\r\n\r\nThis domain excludes reasons specified by diagnosed conditions.\r\n\r\nExamples of values from this domain include duplicate therapy and fraudulent prescription.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "20939"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActBillableServiceReason"
        }
      ]
    },
    {
      "code" : "OVRER",
      "display" : "emergency treatment override",
      "definition" : "To perform one or more operations on information to which the patient has not consented by authorized entities for treating a condition which poses an immediate threat to the patient's health and which requires immediate medical intervention.\r\n\r\n*Usage Notes:* The patient is unable to provide consent, but the provider determines they have an urgent healthcare related reason to access the record.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "The patient is unable to provide consent, but the provider determines they have an urgent healthcare related reason to access the record."
        },
        {
          "code" : "internalId",
          "valueCode" : "22194"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActConsentInformationAccessOverrideReason"
        }
      ]
    },
    {
      "code" : "OVRINCOMP",
      "display" : "incompetency override",
      "definition" : "To perform one or more operations on information to which the patient has not consented because deemed incompetent to provide consent.\r\n\r\n*Usage Note:* Maps to v2 CON-16 Subject Competence Indicator (ID) 01791 Definition: Identifies whether the subject was deemed competent to provide consent. Refer to table HL7 Table 0136 - Yes/No Indicator and CON-23 Non-Subject Consenter Reason User-defined Table 0502 - Non-Subject Consenter Reason code NC \"Subject is not competent to consent\".",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23877"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActConsentInformationAccessOverrideReason"
        }
      ]
    },
    {
      "code" : "OVRPJ",
      "display" : "professional judgment override",
      "definition" : "To perform one or more operations on information to which the patient declined to consent for providing health care.\r\n\r\n*Usage Notes:* The patient, while able to give consent, has not. However the provider believes it is in the patient's interest to access the record without patient consent.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "The patient, while able to give consent, has not.  However the provider believes it is in the patient's interest to access the record without patient consent."
        },
        {
          "code" : "internalId",
          "valueCode" : "22197"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActConsentInformationAccessOverrideReason"
        }
      ]
    },
    {
      "code" : "OVRPS",
      "display" : "public safety override",
      "definition" : "To perform one or more operations on information to which the patient has not consented for public safety reasons.\r\n\r\n*Usage Notes:* The patient, while able to give consent, has not. However, the provider believes that access to masked patient information is justified because of concerns related to public safety.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "The patient, while able to give consent, has not.  However, the provider believes that access to masked patient information is justified because of concerns related to public safety."
        },
        {
          "code" : "internalId",
          "valueCode" : "22195"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActConsentInformationAccessOverrideReason"
        }
      ]
    },
    {
      "code" : "OVRTPS",
      "display" : "third party safety override",
      "definition" : "To perform one or more operations on information to which the patient has not consented for third party safety.\r\n\r\n*Usage Notes:* The patient, while able to give consent, has not. However, the provider believes that access to masked patient information is justified because of concerns related to the health and safety of one or more third parties.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "The patient, while able to give consent, has not.  However, the provider believes that access to masked patient information is justified because of concerns related to the health and safety of one or more third parties."
        },
        {
          "code" : "internalId",
          "valueCode" : "22196"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActConsentInformationAccessOverrideReason"
        }
      ]
    },
    {
      "code" : "_EligibilityActReasonCode",
      "display" : "EligibilityActReasonCode",
      "definition" : "Identifies the reason or rational for why a person is eligibile for benefits under an insurance policy or progam.\r\n\r\n*Examples:*  A person is a claimant under an automobile insurance policy are client deceased & adopted client has been given a new policy identifier. A new employee is eligible for health insurance as an employment benefit. A person meets a government program eligibility criteria for financial, age or health status.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21493"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActCoverageReason"
        }
      ]
    },
    {
      "code" : "_ActCoverageProviderReason",
      "display" : "ActCoverageProviderReason",
      "definition" : "**Description:**Identifies the reason or rationale for coverage of a service or product based on characteristics of the provider, e.g., contractual relationship to payor, such as in or out-of-network; relationship of the covered party to the provider.\r\n\r\n**Example:**In closed managed care plan, a covered party is assigned a primary care provider who provides primary care services and authorizes referrals and ancillary and non-primary care services.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "22168"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActCoverageReason"
        }
      ]
    },
    {
      "code" : "_ActCoverageServiceReason",
      "display" : "ActCoverageServiceReason",
      "definition" : "**Description:**Identifies the reason or rationale for coverage of a service or product based on clinical efficacy criteria or practices prescribed by the payor.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "22169"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActCoverageReason"
        }
      ]
    },
    {
      "code" : "_CoverageExclusionReason",
      "display" : "CoverageExclusionReason",
      "definition" : "**Definition:** Identifies the reason or rationale for coverage of a service or product based on coverage exclusions related to the risk of adverse selection by covered parties.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "22165"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActCoverageReason"
        }
      ]
    },
    {
      "code" : "_CoverageFinancialParticipationReason",
      "display" : "CoverageFinancialParticipationReason",
      "definition" : "**Description:**Identifies the reason or rationale for coverage of a service or product based on financial participation responsibilities of the covered party.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "22166"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActCoverageReason"
        }
      ]
    },
    {
      "code" : "_CoverageLimitationReason",
      "display" : "CoverageLimitationReason",
      "definition" : "**Description:**Identifies the reason or rationale for limitations on the coverage of a service or product based on coverage contract provisions.\r\n\r\n**Example:**The maximum cost per unit; or the maximum number of units per period, which is typically the policy or program effective time.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "22167"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActCoverageReason"
        }
      ]
    },
    {
      "code" : "_ActConsentInformationAccessOverrideReason",
      "display" : "ActConsentInformationAccessOverrideReason",
      "definition" : "To perform one or more operations on information to which the patient has not consented as deemed necessary by authorized entities for providing care in the best interest of the patient; providing immediately needed health care for an emergent condition; or for protecting public or third party safety.\r\n\r\n*Usage Notes:* Used to convey the reason that a provider or other entity may or has accessed personal healthcare information. Typically, this involves overriding the subject's consent directives.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "Used to convey the reason that a provider or other entity may or has accessed personal healthcare information.  Typically, this involves overriding the subject's consent directives."
        },
        {
          "code" : "internalId",
          "valueCode" : "22198"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActHealthInformationManagementReason"
        }
      ]
    },
    {
      "code" : "PurposeOfUse",
      "display" : "purpose of use",
      "definition" : "Reason for performing one or more operations on information, which may be permitted by source system's security policy in accordance with one or more privacy policies and consent directives.\r\n\r\n*Usage Notes:* The rationale or purpose for an act relating to the management of personal health information, such as collecting personal health information for research or public health purposes.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "The rationale or purpose for an act relating to the management of personal health information, such as collecting personal health information for research or public health purposes."
        },
        {
          "code" : "internalId",
          "valueCode" : "23408"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActHealthInformationManagementReason"
        }
      ]
    },
    {
      "code" : "_ActHealthInformationPrivacyReason",
      "display" : "ActHealthInformationPrivacyReason",
      "definition" : "**Description:**The rationale or purpose for an act relating to the management of personal health information, such as collecting personal health information for research or public health purposes.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "22677"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActHealthInformationManagementReason"
        }
      ]
    },
    {
      "code" : "COVSUS",
      "display" : "coverage suspended",
      "definition" : "When a client has no contact with the health system for an extended period, coverage is suspended. Client will be reinstated to original start date upon proof of identification, residency etc.\r\n\r\nExample: Coverage may be suspended during a strike situation, when employer benefits for employees are not covered (i.e. not in effect).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19731"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActIneligibilityReason"
        }
      ]
    },
    {
      "code" : "DECSD",
      "display" : "deceased",
      "definition" : "Client deceased.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19729"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActIneligibilityReason"
        }
      ]
    },
    {
      "code" : "REGERR",
      "display" : "registered in error",
      "definition" : "Client was registered in error.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19730"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActIneligibilityReason"
        }
      ]
    },
    {
      "code" : "_ActHealthInformationManagementReason",
      "display" : "ActHealthInformationManagementReason",
      "definition" : "**Description:**The rationale or purpose for an act relating to health information management, such as archiving information for the purpose of complying with an organization policy or jurisdictional law relating to data retention.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22676"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActInformationManagementReason"
        }
      ]
    },
    {
      "code" : "_ActInformationPrivacyReason",
      "display" : "ActInformationPrivacyReason",
      "definition" : "**Description:**The rationale or purpose for an act relating to the management of personal information, such as disclosing personal tax information for the purpose of complying with a court order.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22697"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActInformationManagementReason"
        }
      ]
    },
    {
      "code" : "MARKT",
      "display" : "marketing",
      "definition" : "**Description:**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22708"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActInformationPrivacyReason"
        }
      ]
    },
    {
      "code" : "OPERAT",
      "display" : "operations",
      "definition" : "**Description:**Administrative and contractual processes required to support an activity, product, or service",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22699"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActInformationPrivacyReason"
        }
      ]
    },
    {
      "code" : "PAYMT",
      "display" : "payment",
      "definition" : "**Description:**Administrative, financial, and contractual processes related to payment for an activity, product, or service",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22698"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActInformationPrivacyReason"
        }
      ]
    },
    {
      "code" : "RESCH",
      "display" : "research",
      "definition" : "**Description:**Investigative activities conducted for the purposes of obtaining knowledge",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22707"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActInformationPrivacyReason"
        }
      ]
    },
    {
      "code" : "SRVC",
      "display" : "service",
      "definition" : "**Description:**Provision of a service, product, or capability to an individual or organization",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22709"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActInformationPrivacyReason"
        }
      ]
    },
    {
      "code" : "ADVSTORAGE",
      "display" : "adverse storage condition",
      "definition" : "**Description:** Storage conditions caused the substance to be ineffective.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23238"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActInvalidReason"
        }
      ]
    },
    {
      "code" : "EXPLOT",
      "display" : "expired lot",
      "definition" : "**Description:** The lot from which the substance was drawn was expired.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23236"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActInvalidReason"
        }
      ]
    },
    {
      "code" : "OUTSIDESCHED",
      "display" : "administered outside recommended schedule or practice",
      "definition" : "The substance was administered outside of the recommended schedule or practice.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23240"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActInvalidReason"
        }
      ]
    },
    {
      "code" : "PRODRECALL",
      "display" : "product recall",
      "definition" : "**Description:** The substance was recalled by the manufacturer.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23237"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActInvalidReason"
        }
      ]
    },
    {
      "code" : "INCCOVPTY",
      "display" : "incorrect covered party as patient",
      "definition" : "The covered party (patient) specified with the Invoice is not correct.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19733"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActInvoiceCancelReason"
        }
      ]
    },
    {
      "code" : "INCINVOICE",
      "display" : "incorrect billing",
      "definition" : "The billing information, specified in the Invoice Elements, is not correct. This could include incorrect costing for items included in the Invoice.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19735"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActInvoiceCancelReason"
        }
      ]
    },
    {
      "code" : "INCPOLICY",
      "display" : "incorrect policy",
      "definition" : "The policy specified with the Invoice is not correct. For example, it may belong to another Adjudicator or Covered Party.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19734"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActInvoiceCancelReason"
        }
      ]
    },
    {
      "code" : "INCPROV",
      "display" : "incorrect provider",
      "definition" : "The provider specified with the Invoice is not correct.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19736"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActInvoiceCancelReason"
        }
      ]
    },
    {
      "code" : "IMMUNE",
      "display" : "immunity",
      "definition" : "**Definition:**Testing has shown that the patient already has immunity to the agent targeted by the immunization.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21745"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActNoImmunizationReason"
        }
      ]
    },
    {
      "code" : "MEDPREC",
      "display" : "medical precaution",
      "definition" : "**Definition:**The patient currently has a medical condition for which the vaccine is contraindicated or for which precaution is warranted.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21747"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActNoImmunizationReason"
        }
      ]
    },
    {
      "code" : "OSTOCK",
      "display" : "product out of stock",
      "definition" : "**Definition:**There was no supply of the product on hand to perform the service.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21744"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActNoImmunizationReason"
        }
      ]
    },
    {
      "code" : "PATOBJ",
      "display" : "patient objection",
      "definition" : "**Definition:**The patient or their guardian objects to receiving the vaccine.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21740"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActNoImmunizationReason"
        }
      ]
    },
    {
      "code" : "PHILISOP",
      "display" : "philosophical objection",
      "definition" : "**Definition:**The patient or their guardian objects to receiving the vaccine because of philosophical beliefs.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21742"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActNoImmunizationReason"
        }
      ]
    },
    {
      "code" : "RELIG",
      "display" : "religious objection",
      "definition" : "**Definition:**The patient or their guardian objects to receiving the vaccine on religious grounds.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21741"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActNoImmunizationReason"
        }
      ]
    },
    {
      "code" : "VACEFF",
      "display" : "vaccine efficacy concerns",
      "definition" : "**Definition:**The intended vaccine has expired or is otherwise believed to no longer be effective.\r\n\r\n**Example:**Due to temperature exposure.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21746"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActNoImmunizationReason"
        }
      ]
    },
    {
      "code" : "VACSAF",
      "display" : "vaccine safety concerns",
      "definition" : "**Definition:**The patient or their guardian objects to receiving the vaccine because of concerns over its safety.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21743"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActNoImmunizationReason"
        }
      ]
    },
    {
      "code" : "FRR01",
      "display" : "order stopped",
      "definition" : "**Definition:**The order has been stopped by the prescriber but this fact has not necessarily captured electronically.\r\n\r\n**Example:**A verbal stop, a fax, etc.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21748"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActSupplyFulfillmentRefusalReason"
        }
      ]
    },
    {
      "code" : "FRR02",
      "display" : "stale-dated order",
      "definition" : "**Definition:**Order has not been fulfilled within a reasonable amount of time, and may not be current.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21749"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActSupplyFulfillmentRefusalReason"
        }
      ]
    },
    {
      "code" : "FRR03",
      "display" : "incomplete data",
      "definition" : "**Definition:**Data needed to safely act on the order which was expected to become available independent of the order is not yet available\r\n\r\n**Example:**Lab results, diagnostic imaging, etc.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21750"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActSupplyFulfillmentRefusalReason"
        }
      ]
    },
    {
      "code" : "FRR04",
      "display" : "product unavailable",
      "definition" : "**Definition:**Product not available or manufactured. Cannot supply.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21751"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActSupplyFulfillmentRefusalReason"
        }
      ]
    },
    {
      "code" : "FRR05",
      "display" : "ethical/religious",
      "definition" : "**Definition:**The dispenser has ethical, religious or moral objections to fulfilling the order/dispensing the product.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21752"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActSupplyFulfillmentRefusalReason"
        }
      ]
    },
    {
      "code" : "FRR06",
      "display" : "unable to provide care",
      "definition" : "**Definition:**Fulfiller not able to provide appropriate care associated with fulfilling the order.\r\n\r\n**Example:**Therapy requires ongoing monitoring by fulfiller and fulfiller will be ending practice, leaving town, unable to schedule necessary time, etc.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21753"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActSupplyFulfillmentRefusalReason"
        }
      ]
    },
    {
      "code" : "RET",
      "display" : "retest",
      "definition" : "**Definition:**The event occurred so that a test or observation performed at a prior event could be performed again due to conditions set forth in the protocol.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21623"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ClinicalResearchEventReason"
        }
      ]
    },
    {
      "code" : "SCH",
      "display" : "scheduled",
      "definition" : "**Definition:**The event occurred due to it being scheduled in the research protocol.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21622"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ClinicalResearchEventReason"
        }
      ]
    },
    {
      "code" : "TRM",
      "display" : "termination",
      "definition" : "**Definition:**The event occurred in order to terminate the subject's participation in the study.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21624"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ClinicalResearchEventReason"
        }
      ]
    },
    {
      "code" : "UNS",
      "display" : "unscheduled",
      "definition" : "**Definition:**The event that occurred was initiated by a study participant (e.g. the subject or the investigator), and did not occur for protocol reasons.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21625"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ClinicalResearchEventReason"
        }
      ]
    },
    {
      "code" : "NPT",
      "display" : "non-protocol",
      "definition" : "**Definition:**The observation or test was neither defined or scheduled in the study protocol.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21628"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ClinicalResearchObservationReason"
        }
      ]
    },
    {
      "code" : "PPT",
      "display" : "per protocol",
      "definition" : "**Definition:**The observation or test occurred due to it being defined in the research protocol, and during an activity or event that was scheduled in the protocol.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21626"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ClinicalResearchObservationReason"
        }
      ]
    },
    {
      "code" : "UPT",
      "display" : "per definition",
      "definition" : "**:**The observation or test occurred as defined in the research protocol, but at a point in time not specified in the study protocol.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21627"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ClinicalResearchObservationReason"
        }
      ]
    },
    {
      "code" : "ALTCHOICE",
      "display" : "try another treatment first",
      "definition" : "**Description:**This therapy has been ordered as a backup to a preferred therapy. This order will be released when and if the preferred therapy is unsuccessful.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21691"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_CombinedPharmacyOrderSuspendReasonCode"
        }
      ]
    },
    {
      "code" : "CLARIF",
      "display" : "prescription requires clarification",
      "definition" : "**Description:**Clarification is required before the order can be acted upon.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21689"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_CombinedPharmacyOrderSuspendReasonCode"
        }
      ]
    },
    {
      "code" : "DRUGHIGH",
      "display" : "drug level too high",
      "definition" : "**Description:**The current level of the medication in the patient's system is too high. The medication is suspended to allow the level to subside to a safer level.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21694"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_CombinedPharmacyOrderSuspendReasonCode"
        }
      ]
    },
    {
      "code" : "HOSPADM",
      "display" : "admission to hospital",
      "definition" : "**Description:**The patient has been admitted to a care facility and their community medications are suspended until hospital discharge.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21684"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_CombinedPharmacyOrderSuspendReasonCode"
        }
      ]
    },
    {
      "code" : "LABINT",
      "display" : "lab interference issues",
      "definition" : "**Description:**The therapy would interfere with a planned lab test and the therapy is being withdrawn until the test is completed.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21687"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_CombinedPharmacyOrderSuspendReasonCode"
        }
      ]
    },
    {
      "code" : "NON-AVAIL",
      "display" : "patient not-available",
      "definition" : "**Description:**Patient not available for a period of time due to a scheduled therapy, leave of absence or other reason.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21695"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_CombinedPharmacyOrderSuspendReasonCode"
        }
      ]
    },
    {
      "code" : "PREG",
      "display" : "parent is pregnant/breast feeding",
      "definition" : "**Description:**The patient is pregnant or breast feeding. The therapy will be resumed when the pregnancy is complete and the patient is no longer breastfeeding.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21692"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_CombinedPharmacyOrderSuspendReasonCode"
        }
      ]
    },
    {
      "code" : "SALG",
      "display" : "allergy",
      "definition" : "**Description:**The patient is believed to be allergic to a substance that is part of the therapy and the therapy is being temporarily withdrawn to confirm.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21685"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_CombinedPharmacyOrderSuspendReasonCode"
        }
      ]
    },
    {
      "code" : "SDDI",
      "display" : "drug interacts with another drug",
      "definition" : "**Description:**The drug interacts with a short-term treatment that is more urgently required. This order will be resumed when the short-term treatment is complete.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21690"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_CombinedPharmacyOrderSuspendReasonCode"
        }
      ]
    },
    {
      "code" : "SDUPTHER",
      "display" : "duplicate therapy",
      "definition" : "**Description:**Another short-term co-occurring therapy fulfills the same purpose as this therapy. This therapy will be resumed when the co-occuring therapy is complete.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21688"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_CombinedPharmacyOrderSuspendReasonCode"
        }
      ]
    },
    {
      "code" : "SINTOL",
      "display" : "suspected intolerance",
      "definition" : "**Description:**The patient is believed to have an intolerance to a substance that is part of the therapy and the therapy is being temporarily withdrawn to confirm.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21686"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_CombinedPharmacyOrderSuspendReasonCode"
        }
      ]
    },
    {
      "code" : "SURG",
      "display" : "patient scheduled for surgery",
      "definition" : "**Description:**The drug is contraindicated for patients receiving surgery and the patient is scheduled to be admitted for surgery in the near future. The drug will be resumed when the patient has sufficiently recovered from the surgery.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21696"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_CombinedPharmacyOrderSuspendReasonCode"
        }
      ]
    },
    {
      "code" : "WASHOUT",
      "display" : "waiting for old drug to wash out",
      "definition" : "**Description:**The patient was previously receiving a medication contraindicated with the current medication. The current medication will remain on hold until the prior medication has been cleansed from their system.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21693"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_CombinedPharmacyOrderSuspendReasonCode"
        }
      ]
    },
    {
      "code" : "ALTD",
      "display" : "altered decision",
      "definition" : "**Description:**The decision on which the recorded information was based was changed before the decision had an effect.\r\n\r\n**Example:**Aborted prescription before patient left office, released prescription before suspend took effect.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22024"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ControlActNullificationReasonCode"
        }
      ]
    },
    {
      "code" : "EIE",
      "display" : "entered in error",
      "definition" : "**Description:**The information was recorded incorrectly or was recorded in the wrong record.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22023"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ControlActNullificationReasonCode"
        }
      ]
    },
    {
      "code" : "NORECMTCH",
      "display" : "no record match",
      "definition" : "**Description:** There is no match for the record in the database.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22908"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ControlActNullificationReasonCode"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_StatusRevisionRefusalReasonCode"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "NOMATCH"
        }
      ]
    },
    {
      "code" : "INRQSTATE",
      "display" : "in requested state",
      "definition" : "The record is already in the requested state.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23015"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ControlActNullificationRefusalReasonType"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_StatusRevisionRefusalReasonCode"
        }
      ]
    },
    {
      "code" : "NOMATCH",
      "display" : "no match",
      "definition" : "**Description:** There is no match.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22907"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ControlActNullificationRefusalReasonType"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RefusalReasonCode"
        }
      ]
    },
    {
      "code" : "NOPERM",
      "display" : "no permission",
      "definition" : "**Description:** There is no permission.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22911"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ControlActNullificationRefusalReasonType"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_RefusalReasonCode"
        }
      ]
    },
    {
      "code" : "WRNGVER",
      "display" : "wrong version",
      "definition" : "**Description:** The record and version requested to update is not the current version.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23278"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ControlActNullificationRefusalReasonType"
        }
      ]
    },
    {
      "code" : "_MedicationOrderAbortReasonCode",
      "display" : "medication order abort reason",
      "definition" : "**Description:**Indicates the reason the medication order should be aborted.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21701"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ControlActReason"
        }
      ]
    },
    {
      "code" : "_MedicationOrderReleaseReasonCode",
      "display" : "medication order release reason",
      "definition" : "**Definition:**A collection of concepts that indicate why the prescription should be released from suspended state.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21711"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ControlActReason"
        }
      ]
    },
    {
      "code" : "_ModifyPrescriptionReasonType",
      "display" : "ModifyPrescriptionReasonType",
      "definition" : "Types of reason why a prescription is being changed.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23634"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ControlActReason"
        }
      ]
    },
    {
      "code" : "_PharmacySupplyEventAbortReason",
      "display" : "PharmacySupplyEventAbortReason",
      "definition" : "**Definition:**Identifies why the dispense event was not completed.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22849"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ControlActReason"
        }
      ]
    },
    {
      "code" : "_PharmacySupplyEventStockReasonCode",
      "display" : "pharmacy supply event stock reason",
      "definition" : "**Definition:**A collection of concepts that indicates the reason for a \"bulk supply\" of medication.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21721"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ControlActReason"
        }
      ]
    },
    {
      "code" : "_PharmacySupplyRequestRenewalRefusalReasonCode",
      "display" : "pharmacy supply request renewal refusal reason",
      "definition" : "**Definition:**A collection of concepts that identifies why a renewal prescription has been refused.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21727"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ControlActReason"
        }
      ]
    },
    {
      "code" : "_SupplyOrderAbortReasonCode",
      "display" : "supply order abort reason",
      "definition" : "**Definition:**A collection of concepts that indicates why the prescription should no longer be allowed to be dispensed (but can still administer what is already being dispensed).",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21736"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ControlActReason"
        }
      ]
    },
    {
      "code" : "_ControlActReasonConditionNullify",
      "display" : "ControlActReasonConditionNullify",
      "definition" : "Indicates why the ConditionaTMs status was changed to Nullified. *Examples* administrative error, diagnostic error.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21492"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ControlActReason"
        }
      ]
    },
    {
      "code" : "AGE",
      "display" : "age eligibility",
      "definition" : "A person becomes eligible for a program based on age.\r\n\r\n*Example:*  In the U.S., a person who is 65 years of age or older is eligible for Medicare.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21565"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_CoverageEligibilityReason"
        }
      ]
    },
    {
      "code" : "CRIME",
      "display" : "crime victim",
      "definition" : "A person becomes eligible for insurance or a program because of crime related health condition or injury.\r\n\r\n*Example:*  A person is a claimant under the U.S. Crime Victims Compensation program.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21558"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_CoverageEligibilityReason"
        }
      ]
    },
    {
      "code" : "DIS",
      "display" : "disability",
      "definition" : "A person becomes a claimant under a disability income insurance policy or a disability rehabilitation program because of a health condition or injury which limits the person's ability to earn an income or function without institutionalization.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21560"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_CoverageEligibilityReason"
        }
      ]
    },
    {
      "code" : "EMPLOY",
      "display" : "employment benefit",
      "definition" : "A person becomes eligible for insurance provided as an employment benefit based on employment status.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21556"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_CoverageEligibilityReason"
        }
      ]
    },
    {
      "code" : "FINAN",
      "display" : "financial eligibility",
      "definition" : "A person becomes eligible for a program based on financial criteria.\r\n\r\n*Example:*  A person whose family income is below a financial threshold for eligibility for Medicaid or SCHIP.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21564"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_CoverageEligibilityReason"
        }
      ]
    },
    {
      "code" : "HEALTH",
      "display" : "health status",
      "definition" : "A person becomes eligible for a program because of a qualifying health condition or injury.\r\n\r\n*Examples:*  A person is determined to have a qualifying health conditions include pregnancy, HIV/AIDs, tuberculosis, end stage renal disease, breast or cervical cancer, or other condition requiring specialized health services, hospice, institutional or community based care provided under a program",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21562"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_CoverageEligibilityReason"
        }
      ]
    },
    {
      "code" : "MULTI",
      "display" : "multiple criteria eligibility",
      "definition" : "A person becomes eligible for a program based on more than one criterion.\r\n\r\n*Examples:*  In the U.S., a child whose familiy income meets Medicaid financial thresholds and whose age is less than 18 is eligible for the Early and Periodic Screening, Diagnostic, and Treatment program (EPSDT). A person whose family income meets Medicaid financial thresholds and whose age is 65 years or older is eligible for Medicaid and Medicare, and are referred to as dual eligibles.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21566"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_CoverageEligibilityReason"
        }
      ]
    },
    {
      "code" : "PNC",
      "display" : "property and casualty condition",
      "definition" : "A person becomes a claimant under a property and casualty insurance policy because of a related health condition or injury resulting from a circumstance covered under the terms of the policy.\r\n\r\n*Example:*  A person is a claimant under a homeowners insurance policy because of an injury sustained on the policyholderaTMs premises.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21561"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_CoverageEligibilityReason"
        }
      ]
    },
    {
      "code" : "STATUTORY",
      "display" : "statutory eligibility",
      "definition" : "A person becomes eligible for a program based on statutory criteria.\r\n\r\n*Examples:*  A person is a member of an indigenous group, a veteran of military service, or in the U.S., a recipient of adoption assistance and foster care under Title IV-E of the Social Security.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21563"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_CoverageEligibilityReason"
        }
      ]
    },
    {
      "code" : "VEHIC",
      "display" : "motor vehicle accident victim",
      "definition" : "A person becomes a claimant under a motor vehicle accident insurance because of a motor vehicle accident related health condition or injury.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21559"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_CoverageEligibilityReason"
        }
      ]
    },
    {
      "code" : "WORK",
      "display" : "work related",
      "definition" : "A person becomes eligible for insurance or a program because of a work related health condition or injury.\r\n\r\n*Example:*  A person is a claimant under the U.S. Black Lung Program.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21557"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_CoverageEligibilityReason"
        }
      ]
    },
    {
      "code" : "_ActIneligibilityReason",
      "display" : "ActIneligibilityReason",
      "definition" : "Identifies the reason or rational for why a person is not eligibile for benefits under an insurance policy.\r\n\r\nExamples are client deceased & adopted client has been given a new policy identifier.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "20940"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_EligibilityActReasonCode"
        }
      ]
    },
    {
      "code" : "_CoverageEligibilityReason",
      "display" : "CoverageEligibilityReason",
      "definition" : "Definition: Identifies the reason or rational for why a person is eligibile for benefits under an insurance policy or progam.\r\n\r\n*Examples:*  A person is a claimant under an automobile insurance policy are client deceased & adopted client has been given a new policy identifier. A new employee is eligible for health insurance as an employment benefit. A person meets a government program eligibility criteria for financial, age or health status.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21555"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_EligibilityActReasonCode"
        }
      ]
    },
    {
      "code" : "CHGDATA",
      "display" : "information change",
      "definition" : "**Description:**Information has changed since the record was created.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21673"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_GenericUpdateReasonCode"
        }
      ]
    },
    {
      "code" : "FIXDATA",
      "display" : "error correction",
      "definition" : "**Description:**Previously recorded information was erroneous and is being corrected.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21674"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_GenericUpdateReasonCode"
        }
      ]
    },
    {
      "code" : "MDATA",
      "display" : "merge data",
      "definition" : "Information is combined into the record.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23469"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_GenericUpdateReasonCode"
        }
      ]
    },
    {
      "code" : "NEWDATA",
      "display" : "new information",
      "definition" : "**Description:**New information has become available to supplement the record.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21672"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_GenericUpdateReasonCode"
        }
      ]
    },
    {
      "code" : "UMDATA",
      "display" : "unmerge data",
      "definition" : "Information is separated from the record.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23470"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_GenericUpdateReasonCode"
        }
      ]
    },
    {
      "code" : "DISCONT",
      "display" : "product discontinued",
      "definition" : "**Description:**The medication is no longer being manufactured or is otherwise no longer available.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21706"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_MedicationOrderAbortReasonCode"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PharmacySupplyRequestRenewalRefusalReasonCode"
        }
      ]
    },
    {
      "code" : "INEFFECT",
      "display" : "ineffective",
      "definition" : "**Description:**The therapy has been found to not have the desired therapeutic benefit on the patient.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21703"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_MedicationOrderAbortReasonCode"
        }
      ]
    },
    {
      "code" : "MONIT",
      "display" : "response to monitoring",
      "definition" : "**Description:**Monitoring the patient while taking the medication, the decision has been made that the therapy is no longer appropriate.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21702"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_MedicationOrderAbortReasonCode"
        }
      ]
    },
    {
      "code" : "NOREQ",
      "display" : "no longer required for treatment",
      "definition" : "**Description:**The underlying condition has been resolved or has evolved such that a different treatment is no longer needed.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21704"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_MedicationOrderAbortReasonCode"
        }
      ]
    },
    {
      "code" : "NOTCOVER",
      "display" : "not covered",
      "definition" : "**Description:**The product does not have (or no longer has) coverage under the patientaTMs insurance policy.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21709"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_MedicationOrderAbortReasonCode"
        }
      ]
    },
    {
      "code" : "PREFUS",
      "display" : "patient refuse",
      "definition" : "**Description:**The patient refused to take the product.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21710"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_MedicationOrderAbortReasonCode"
        }
      ]
    },
    {
      "code" : "RECALL",
      "display" : "product recalled",
      "definition" : "**Description:**The manufacturer or other agency has requested that stocks of a medication be removed from circulation.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21707"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_MedicationOrderAbortReasonCode"
        }
      ]
    },
    {
      "code" : "REPLACE",
      "display" : "change in order",
      "definition" : "**Description:**Item in current order is no longer in use as requested and a new one has/will be created to replace it.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23262"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_MedicationOrderAbortReasonCode"
        }
      ]
    },
    {
      "code" : "REPLACEFIX",
      "display" : "error in order",
      "definition" : "**Description:**Current order was issued with incorrect data and a new order has/will be created to replace it.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23263"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_MedicationOrderAbortReasonCode"
        }
      ]
    },
    {
      "code" : "UNABLE",
      "display" : "unable to use",
      "definition" : "**Description:**<The patient is not (or is no longer) able to use the medication in a manner prescribed.\r\n\r\n**Example:**CanaTMt swallow.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21708"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_MedicationOrderAbortReasonCode"
        }
      ]
    },
    {
      "code" : "HOLDDONE",
      "display" : "suspend reason no longer applies",
      "definition" : "**Definition:**The original reason for suspending the medication has ended.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21713"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_MedicationOrderReleaseReasonCode"
        }
      ]
    },
    {
      "code" : "HOLDINAP",
      "display" : "suspend reason inappropriate",
      "definition" : "**Definition:**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21712"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_MedicationOrderReleaseReasonCode"
        }
      ]
    },
    {
      "code" : "ADMINERROR",
      "display" : "administrative error in order",
      "definition" : "Order was created with incorrect data and is changed to reflect the intended accuracy of the order.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23635"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ModifyPrescriptionReasonType"
        }
      ]
    },
    {
      "code" : "CLINMOD",
      "display" : "clinical modification",
      "definition" : "Order is changed based on a clinical reason.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23636"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ModifyPrescriptionReasonType"
        }
      ]
    },
    {
      "code" : "ADMREV",
      "display" : "administrative review",
      "definition" : "**Definition:** To evaluate for service authorization, payment, reporting, or performance/outcome measures.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22221"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PatientProfileQueryReasonCode"
        }
      ]
    },
    {
      "code" : "LEGAL",
      "display" : "subpoena",
      "definition" : "**Definition:**To provide information as a result of a subpoena.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21719"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PatientProfileQueryReasonCode"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OPERAT"
        }
      ]
    },
    {
      "code" : "PATCAR",
      "display" : "patient care",
      "definition" : "**Definition:**To obtain records as part of patient care.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21717"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PatientProfileQueryReasonCode"
        }
      ]
    },
    {
      "code" : "PATREQ",
      "display" : "patient request query",
      "definition" : "**Definition:**Patient requests information from their profile.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21716"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PatientProfileQueryReasonCode"
        }
      ]
    },
    {
      "code" : "PRCREV",
      "display" : "practice review",
      "definition" : "**Definition:**To evaluate the provider's current practice for professional-improvement reasons.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21720"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PatientProfileQueryReasonCode"
        }
      ]
    },
    {
      "code" : "REGUL",
      "display" : "regulatory review",
      "definition" : "**Description:**Review for the purpose of regulatory compliance.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21991"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PatientProfileQueryReasonCode"
        }
      ]
    },
    {
      "code" : "RSRCH",
      "display" : "research",
      "definition" : "**Definition:**To provide research data, as authorized by the patient.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21718"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PatientProfileQueryReasonCode"
        }
      ]
    },
    {
      "code" : "VALIDATION",
      "display" : "validation review",
      "definition" : "**Description:**To validate the patient's record.\r\n\r\n**Example:**Merging or unmerging records.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21992"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PatientProfileQueryReasonCode"
        }
      ]
    },
    {
      "code" : "CONTRA",
      "display" : "contraindication",
      "definition" : "**Definition:**Contraindication identified",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22855"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PharmacySupplyEventAbortReason"
        }
      ]
    },
    {
      "code" : "FOABORT",
      "display" : "order aborted",
      "definition" : "**Definition:**Order to be fulfilled was aborted",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22852"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PharmacySupplyEventAbortReason"
        }
      ]
    },
    {
      "code" : "FOSUSP",
      "display" : "order suspended",
      "definition" : "**Definition:**Order to be fulfilled was suspended",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22853"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PharmacySupplyEventAbortReason"
        }
      ]
    },
    {
      "code" : "NOPICK",
      "display" : "not picked up",
      "definition" : "**Definition:**Patient did not come to get medication",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22850"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PharmacySupplyEventAbortReason"
        }
      ]
    },
    {
      "code" : "PATDEC",
      "display" : "patient changed mind",
      "definition" : "**Definition:**Patient changed their mind regarding obtaining medication",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22851"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PharmacySupplyEventAbortReason"
        }
      ]
    },
    {
      "code" : "QUANTCHG",
      "display" : "change supply quantity",
      "definition" : "**Definition:**Patient requested a revised quantity of medication",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22854"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PharmacySupplyEventAbortReason"
        }
      ]
    },
    {
      "code" : "FLRSTCK",
      "display" : "floor stock",
      "definition" : "**Definition:**The bulk supply is issued to replenish a ward for local dispensing. (Includes both mobile and fixed-location ward stocks.)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21722"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PharmacySupplyEventStockReasonCode"
        }
      ]
    },
    {
      "code" : "LTC",
      "display" : "long term care use",
      "definition" : "**Definition:**The bulk supply will be administered within a long term care facility.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21725"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PharmacySupplyEventStockReasonCode"
        }
      ]
    },
    {
      "code" : "OFFICE",
      "display" : "office use",
      "definition" : "**Definition:**The bulk supply is intended for general clinician office use.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21724"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PharmacySupplyEventStockReasonCode"
        }
      ]
    },
    {
      "code" : "PHARM",
      "display" : "pharmacy transfer",
      "definition" : "**Definition:**The bulk supply is being transferred to another dispensing facility to.\r\n\r\n**Example:**Alleviate a temporary shortage.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21726"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PharmacySupplyEventStockReasonCode"
        }
      ]
    },
    {
      "code" : "PROG",
      "display" : "program use",
      "definition" : "**Definition:**The bulk supply is intended for dispensing according to a specific program.\r\n\r\n**Example:**Mass immunization.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21723"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PharmacySupplyEventStockReasonCode"
        }
      ]
    },
    {
      "code" : "LOCKED",
      "display" : "locked",
      "definition" : "**Definition:**The prescription may not be reassigned from the original pharmacy.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22864"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PharmacySupplyRequestFulfillerRevisionRefusalReasonCode"
        }
      ]
    },
    {
      "code" : "NOUSERPERM",
      "display" : "no user permission",
      "definition" : "**Definition:**The user does not have permission",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22865"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PharmacySupplyRequestFulfillerRevisionRefusalReasonCode"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_StatusRevisionRefusalReasonCode"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SubstanceAdministrationPermissionRefusalReasonCode"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "NOPERM"
        }
      ]
    },
    {
      "code" : "UNKWNTARGET",
      "display" : "unknown target",
      "definition" : "**Definition:**The target facility does not recognize the dispensing facility.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22866"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PharmacySupplyRequestFulfillerRevisionRefusalReasonCode"
        }
      ]
    },
    {
      "code" : "ALREADYRX",
      "display" : "new prescription exists",
      "definition" : "**Definition:**Patient has already been given a new (renewal) prescription.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21732"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PharmacySupplyRequestRenewalRefusalReasonCode"
        }
      ]
    },
    {
      "code" : "FAMPHYS",
      "display" : "family physician must authorize further fills",
      "definition" : "**Definition:**Request for further authorization must be done through patient's family physician.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21731"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PharmacySupplyRequestRenewalRefusalReasonCode"
        }
      ]
    },
    {
      "code" : "MODIFY",
      "display" : "modified prescription exists",
      "definition" : "**Definition:**Therapy has been changed and new prescription issued",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21733"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PharmacySupplyRequestRenewalRefusalReasonCode"
        }
      ]
    },
    {
      "code" : "NEEDAPMT",
      "display" : "patient must make appointment",
      "definition" : "**Definition:**Patient must see prescriber prior to further fills.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21728"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PharmacySupplyRequestRenewalRefusalReasonCode"
        }
      ]
    },
    {
      "code" : "NOTAVAIL",
      "display" : "prescriber not available",
      "definition" : "**Definition:**Original prescriber is no longer available to prescribe and no other prescriber has taken responsibility for the patient.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21730"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PharmacySupplyRequestRenewalRefusalReasonCode"
        }
      ]
    },
    {
      "code" : "NOTPAT",
      "display" : "patient no longer in this practice",
      "definition" : "**Definition:**Patient no longer or has never been under this prescribers care.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21729"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PharmacySupplyRequestRenewalRefusalReasonCode"
        }
      ]
    },
    {
      "code" : "ONHOLD",
      "display" : "medication on hold",
      "definition" : "**Definition:**This medication is on hold.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21734"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PharmacySupplyRequestRenewalRefusalReasonCode"
        }
      ]
    },
    {
      "code" : "PRNA",
      "display" : "product not available",
      "definition" : "**Description:**This product is not available or manufactured.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22867"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PharmacySupplyRequestRenewalRefusalReasonCode"
        }
      ]
    },
    {
      "code" : "STOPMED",
      "display" : "prescriber stopped medication for patient",
      "definition" : "Renewing or original prescriber informed patient to stop using the medication.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23625"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PharmacySupplyRequestRenewalRefusalReasonCode"
        }
      ]
    },
    {
      "code" : "TOOEARLY",
      "display" : "too early",
      "definition" : "**Definition:**The patient should have medication remaining.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21735"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_PharmacySupplyRequestRenewalRefusalReasonCode"
        }
      ]
    },
    {
      "code" : "BLK",
      "display" : "Unexpected Block (of Schedule)",
      "definition" : "The time slots previously allocated are now blocked and no longer available for booking Appointments",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14885"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SchedulingActReason"
        }
      ]
    },
    {
      "code" : "DEC",
      "display" : "Patient Deceased",
      "definition" : "The Patient is deceased",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14884"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SchedulingActReason"
        }
      ]
    },
    {
      "code" : "FIN",
      "display" : "No Financial Backing",
      "definition" : "Patient unable to pay and not covered by insurance",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14882"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SchedulingActReason"
        }
      ]
    },
    {
      "code" : "MED",
      "display" : "Medical Status Altered",
      "definition" : "The medical condition of the Patient has changed",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14883"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SchedulingActReason"
        }
      ]
    },
    {
      "code" : "MTG",
      "display" : "In an outside meeting",
      "definition" : "The Physician is in a meeting. For example, he/she may request administrative time to talk to family after appointment",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14886"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SchedulingActReason"
        }
      ]
    },
    {
      "code" : "PHY",
      "display" : "Physician request",
      "definition" : "The Physician requested the action",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14881"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SchedulingActReason"
        }
      ]
    },
    {
      "code" : "FILLED",
      "display" : "fully filled",
      "definition" : "Ordered quantity has already been completely fulfilled.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23016"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_StatusRevisionRefusalReasonCode"
        }
      ]
    },
    {
      "code" : "PATINELIG",
      "display" : "patient not eligible",
      "definition" : "**Definition:**Patient not eligible for drug",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22858"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SubstanceAdministrationPermissionRefusalReasonCode"
        }
      ]
    },
    {
      "code" : "PROTUNMET",
      "display" : "protocol not met",
      "definition" : "**Definition:**Patient does not meet required protocol",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22857"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SubstanceAdministrationPermissionRefusalReasonCode"
        }
      ]
    },
    {
      "code" : "PROVUNAUTH",
      "display" : "provider not authorized",
      "definition" : "**Definition:**Provider is not authorized to prescribe or dispense",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22859"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SubstanceAdministrationPermissionRefusalReasonCode"
        }
      ]
    },
    {
      "code" : "ALGINT",
      "display" : "allergy intolerance",
      "definition" : "**Definition:** Patient has had a prior allergic intolerance response to alternate product or one of its components.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22259"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SubstanceAdminSubstitutionNotAllowedReason"
        }
      ]
    },
    {
      "code" : "COMPCON",
      "display" : "compliance concern",
      "definition" : "**Definition:** Patient has compliance issues with medication such as differing appearance, flavor, size, shape or consistency.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22260"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SubstanceAdminSubstitutionNotAllowedReason"
        }
      ]
    },
    {
      "code" : "THERCHAR",
      "display" : "therapeutic characteristics",
      "definition" : "The prescribed product has specific clinical release or other therapeutic characteristics not shared by other substitutable medications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21815"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SubstanceAdminSubstitutionNotAllowedReason"
        }
      ]
    },
    {
      "code" : "TRIAL",
      "display" : "clinical trial drug",
      "definition" : "**Definition:** The specific manufactured drug is part of a clinical trial.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22261"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SubstanceAdminSubstitutionNotAllowedReason"
        }
      ]
    },
    {
      "code" : "CT",
      "display" : "continuing therapy",
      "definition" : "Indicates that the decision to substitute or to not substitute was driven by a desire to maintain consistency with a pre-existing therapy. I.e. The performer provided the same item/service as had been previously provided rather than providing exactly what was ordered, or rather than substituting with a lower-cost equivalent.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19989"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SubstanceAdminSubstitutionReason"
        }
      ]
    },
    {
      "code" : "FP",
      "display" : "formulary policy",
      "definition" : "Indicates that the decision to substitute or to not substitute was driven by a policy expressed within the formulary.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19990"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SubstanceAdminSubstitutionReason"
        }
      ]
    },
    {
      "code" : "OS",
      "display" : "out of stock",
      "definition" : "In the case of 'substitution', indicates that the substitution occurred because the ordered item was not in stock. In the case of 'no substitution', indicates that a cheaper equivalent was not substituted because it was not in stock.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19987"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SubstanceAdminSubstitutionReason"
        }
      ]
    },
    {
      "code" : "RR",
      "display" : "regulatory requirement",
      "definition" : "Indicates that the decision to substitute or to not substitute was driven by a jurisdictional regulatory requirement mandating or prohibiting substitution.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19988"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SubstanceAdminSubstitutionReason"
        }
      ]
    },
    {
      "code" : "IMPROV",
      "display" : "condition improved",
      "definition" : "**Definition:**The patient's medical condition has nearly abated.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21737"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SupplyOrderAbortReasonCode"
        }
      ]
    },
    {
      "code" : "INTOL",
      "display" : "intolerance",
      "definition" : "**Description:**The patient has an intolerance to the medication.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21990"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SupplyOrderAbortReasonCode"
        }
      ]
    },
    {
      "code" : "NEWSTR",
      "display" : "new strength",
      "definition" : "**Definition:**The current medication will be replaced by a new strength of the same medication.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21739"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SupplyOrderAbortReasonCode"
        }
      ]
    },
    {
      "code" : "NEWTHER",
      "display" : "new therapy",
      "definition" : "**Definition:**A new therapy will be commenced when current supply exhausted.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21738"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_SupplyOrderAbortReasonCode"
        }
      ]
    },
    {
      "code" : "ER",
      "display" : "Error",
      "definition" : "Moved to an error in placing the patient in the original location.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "15984"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TransferActReason"
        }
      ]
    },
    {
      "code" : "RQ",
      "display" : "Request",
      "definition" : "Moved at the request of the patient.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "15985"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_TransferActReason"
        }
      ]
    },
    {
      "code" : "COLDCHNBRK",
      "display" : "cold chain break",
      "definition" : "**Description:** Cold chain was not maintained for the substance.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23239"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ADVSTORAGE"
        }
      ]
    },
    {
      "code" : "CLINTRCHNPC",
      "display" : "clinical trial research without patient care",
      "definition" : "To perform one or more operations on information for conducting scientific investigations in accordance with clinical trial protocols to obtain health care knowledge without provision of patient care. May be post-coordinated or used with other purposes of use such as disease, discipline, specialty, population origins or ancestry, translational healthcare research. For example, a clinical trial conducted on laboratory specimens collected from a specified patient population.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23868"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "CLINTRCH"
        }
      ]
    },
    {
      "code" : "CLINTRCHPC",
      "display" : "clinical trial research with patient care",
      "definition" : "To perform one or more operations on information for conducting scientific investigations with patient care in accordance with clinical trial protocols to obtain health care knowledge. May be post-coordinated or used with other purposes of use such as disease, discipline, specialty, population origins or ancestry, translational healthcare research. For example, an \"off-label\" drug used for cancer therapy administer to a specified patient population.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23869"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "CLINTRCH"
        }
      ]
    },
    {
      "code" : "PRECLINTRCH",
      "display" : "preclinical trial research",
      "definition" : "To perform one or more operations on information in preparation for conducting scientific investigation to obtain health care knowledge, such as research on animals or review of patient health records, to determine the feasibility of a clinical trial study; assist with protocol design; or in preparation for institutional review board or ethics committee approval process. May be post-coordinated or used with other purposes of use such as disease, discipline, specialty, population origins or ancestry, translational healthcare research.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23870"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "CLINTRCH"
        }
      ]
    },
    {
      "code" : "ELIGDTRM",
      "display" : "eligibility determination",
      "definition" : "To perform one or more operations on information used for conducting eligibility determination for coverage in a program or policy. May entail review of financial status or disability assessment.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23420"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "COVERAGE"
        }
      ]
    },
    {
      "code" : "ELIGVER",
      "display" : "eligibility verification",
      "definition" : "To perform one or more operations on information used for conducting eligibility verification of coverage in a program or policy. May entail provider contacting coverage source (e.g., government health program such as workers compensation or health plan) for confirmation of enrollment, eligibility for specific services, and any applicable copays.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23457"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "COVERAGE"
        }
      ]
    },
    {
      "code" : "ENROLLM",
      "display" : "enrollment",
      "definition" : "To perform one or more operations on information used for enrolling a covered party in a program or policy. May entail recording of covered party's and any dependent's demographic information and benefit choices.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23458"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "COVERAGE"
        }
      ]
    },
    {
      "code" : "MILDCRG",
      "display" : "military discharge",
      "definition" : "To perform one or more operations on information for the process of releasing military personnel from their service obligations, which may include determining service merit, discharge benefits, and disability assessment.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23876"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "COVERAGE"
        }
      ]
    },
    {
      "code" : "BTG",
      "display" : "break the glass",
      "definition" : "To perform policy override operations on information for provision of immediately needed health care for an emergent condition affecting potential harm, death or patient safety by end users who are not provisioned for this purpose of use. Includes override of organizational provisioning policies and may include override of subject of care consent directive restricting access.\r\n\r\n*Map:* Partially Maps to ISO 14265 Classification Term \"Emergency care provision to an individual subject of care\" described as \"To inform persons needing to provide health care services to the subject of care urgently, possibly needing to over-ride the policies and consents pertaining to Purpose 1 above.\" Purpose 1 is equivalent to HL7 treatment purpose of use: \"Clinical care provision to an individual subject of care\" described as \"To inform persons or processes responsible for providing health care services to the subject of care.\" The ISO description conflates both of the proposed specializations of HL7 ETREAT: break the glass and the typically broader access to health information normally available to providers who are provisioned for emergency workflows on a regular basis, e.g., Emergency Room providers. Examples of greater access than is normally accessible by providers based on the need to know are access to sensitive information for which access typically requires a patient's consent. This is not an override of a patient's dissent to disclose sensitive information in cases where the applicable policy waives the need for that consent to access this information. In US, Title 38 Section 7332 and 42 CFR Part 2 both permit emergency access without the need to override a patient's consent directive; rather, this access is a limitation to the patient's right to dissent from disclosure.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23924"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ETREAT"
        }
      ]
    },
    {
      "code" : "ERTREAT",
      "display" : "emergency room treatment",
      "definition" : "To perform one or more operations on information for provision of immediately needed health care for an emergent condition in an emergency room or similar emergent care context by end users provisioned for this purpose, which does not constitute as policy override such as in a \"Break the Glass\" purpose of use.\r\n\r\nMap:Partially Maps to ISO 14265 Classification Term \"Emergency care provision to an individual subject of care\" described as \"To inform persons needing to provide health care services to the subject of care urgently, possibly needing to over-ride the policies and consents pertaining to Purpose 1 above.\" Purpose 1 is equivalent to HL7 treatment purpose of use: \"Clinical care provision to an individual subject of care\" described as \"To inform persons or processes responsible for providing health care services to the subject of care.\"\r\n\r\nThe ISO description conflates both of the proposed specializations of HL7 ETREAT: break the glass and the typically broader access to health information normally available to providers who are provisioned for emergency workflows on a regular basis, e.g., Emergency Room providers. Examples of greater access than is normally accessible by providers based on the need to know are access to sensitive information for which access typically requires a patient's consent. This is not an override of a patient's dissent to disclose sensitive information in cases where the applicable policy waives the need for that consent to access this information. In US, Title 38 Section 7332 and 42 CFR Part 2 both permit emergency access without the need to override a patient's consent directive; rather, this access is a limitation to the patient's right to dissent from disclosure.\r\n\r\nThere is a semantic gap in concepts. This classification term is described as activities \"to inform persons\" rather than the rationale for performing actions/operations on information related to the activity.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23925"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ETREAT"
        }
      ]
    },
    {
      "code" : "CAREMGT",
      "display" : "care management",
      "definition" : "To perform analytics, evaluation and other secondary uses of treatment and healthcare related information to manage the quality, efficacy, patient safety, population health, and cost effectiveness of healthcare delivery. Explicitly excludes the use of information to organize the delivery of health care for care coordination and case management, or to provide healthcare treatment.\r\n\r\n*Usage Note:* The concept of care management is narrower than the list of activities related to more general organizational objectives such as provider profiling, education of healthcare and non-healthcare professionals; insurance underwriting, premium rating, reinsurance; organizational legal, medical review, auditing, compliance and fraud and abuse detection; business planning, development, and restructuring; fund-raising; and customer service.\r\n\r\n*Map:* Maps to ISO 14265 Classification Term \"Health service management and quality assurance\" described as \"To inform persons or processes responsible for determining the availability, quality, safety, equity and cost-effectiveness of health care services.\"\r\n\r\nThere is a semantic gap in concepts. This classification term is described as activities, i.e., \"to inform persons\" or \"to inform processes\" rather than the rationale for performing actions/operations on information related to the activity.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22683"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HOPERAT"
        }
      ]
    },
    {
      "code" : "DONAT",
      "display" : "donation",
      "definition" : "To perform one or more operations on information used for cadaveric organ, eye or tissue donation.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23412"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HOPERAT"
        }
      ]
    },
    {
      "code" : "FRAUD",
      "display" : "fraud",
      "definition" : "To perform one or more operations on information used for fraud detection and prevention processes.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23413"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HOPERAT"
        }
      ]
    },
    {
      "code" : "GOV",
      "display" : "government",
      "definition" : "To perform one or more operations on information used within government processes.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23414"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HOPERAT"
        }
      ]
    },
    {
      "code" : "HACCRED",
      "display" : "health accreditation",
      "definition" : "To perform one or more operations on information for conducting activities related to meeting accreditation criteria.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22692"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HOPERAT"
        }
      ]
    },
    {
      "code" : "HCOMPL",
      "display" : "health compliance",
      "definition" : "To perform one or more operations on information used for conducting activities required to meet a mandate.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22689"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HOPERAT"
        }
      ]
    },
    {
      "code" : "HDECD",
      "display" : "decedent",
      "definition" : "To perform one or more operations on information used for handling deceased patient matters.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23415"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HOPERAT"
        }
      ]
    },
    {
      "code" : "HDIRECT",
      "display" : "directory",
      "definition" : "To perform one or more operation operations on information used to manage a patient directory.\r\n\r\n**Examples:** \r\n\r\n *  facility\r\n *  enterprise\r\n *  payer\r\n *  health information exchange patient directory",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23416"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HOPERAT"
        }
      ]
    },
    {
      "code" : "HDM",
      "display" : "healthcare delivery management",
      "definition" : "To perform one or more actions on information used for conducting administrative and contractual activities by or on behalf of organizational entities responsible for delivery of an individual's benefits in a healthcare program, health plan or insurance. Explicitly excludes the use of information to organize the delivery of health care for care coordination and case management, or to provide healthcare treatment.\r\n\r\n*Usage Note:* Examples of activities conducted under this purpose of use: provider profiling, risk adjustment, underwriting, fraud and abuse, quality improvement population health and care management. Aligns with HIPAA Operation POU minus coordination of care or other treatment related activities. Similar to the description in SAMHSA Confidentiality of Substance Use Disorder Patient Records Supplemental notice of proposed rulemaking.\r\n\r\n*Map:* Maps to ISO 14265 Classification Term \"Administration of care for an individual subject of care\" described as \"To inform persons or processes responsible for enabling the availability of resources or funding or permissions for providing health care services to the subject of care.\"\r\n\r\nHowever, this classification term is described as activities, i.e., \"to inform persons\" or \"to inform processes\" rather than the rationale for performing actions/operations on information related to the activity.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23926"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HOPERAT"
        }
      ]
    },
    {
      "code" : "HLEGAL",
      "display" : "legal",
      "definition" : "To perform one or more operations on information for conducting activities required by legal proceeding.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22690"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HOPERAT"
        }
      ]
    },
    {
      "code" : "HOUTCOMS",
      "display" : "health outcome measure",
      "definition" : "To perform one or more operations on information used for assessing results and comparative effectiveness achieved by health care practices and interventions.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22688"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HOPERAT"
        }
      ]
    },
    {
      "code" : "HPRGRP",
      "display" : "health program reporting",
      "definition" : "To perform one or more operations on information used for conducting activities to meet program accounting requirements.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22691"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HOPERAT"
        }
      ]
    },
    {
      "code" : "HQUALIMP",
      "display" : "health quality improvement",
      "definition" : "To perform one or more operations on information used for conducting administrative activities to improve health care quality.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22687"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HOPERAT"
        }
      ]
    },
    {
      "code" : "HSYSADMIN",
      "display" : "health system administration",
      "definition" : "To perform one or more operations on information to administer the electronic systems used for the delivery of health care.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22695"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HOPERAT"
        }
      ]
    },
    {
      "code" : "MEMADMIN",
      "display" : "member administration",
      "definition" : "To perform one or more operations on information to administer health care coverage to an enrollee under a policy or program.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22694"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HOPERAT"
        }
      ]
    },
    {
      "code" : "MILCDM",
      "display" : "military command",
      "definition" : "To perform one or more operations on information for conducting activities required by military processes, procedures, policies, or law.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23875"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HOPERAT"
        }
      ]
    },
    {
      "code" : "PATADMIN",
      "display" : "patient administration",
      "definition" : "To perform one or more operations on information used for operational activities conducted to administer the delivery of health care to a patient.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22693"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HOPERAT"
        }
      ]
    },
    {
      "code" : "PATSFTY",
      "display" : "patient safety",
      "definition" : "To perform one or more operations on information in processes related to ensuring the safety of health care.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22696"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HOPERAT"
        }
      ]
    },
    {
      "code" : "PERFMSR",
      "display" : "performance measure",
      "definition" : "To perform one or more operations on information used for monitoring performance of recommended health care practices and interventions.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23417"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HOPERAT"
        }
      ]
    },
    {
      "code" : "RECORDMGT",
      "display" : "records management",
      "definition" : "To perform one or more operations on information used within the health records management process.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23418"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HOPERAT"
        }
      ]
    },
    {
      "code" : "SYSDEV",
      "display" : "system development",
      "definition" : "To perform one or more operations on information to design, develop, implement, test, or deploy a healthcare system or application.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23873"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HOPERAT"
        }
      ]
    },
    {
      "code" : "TRAIN",
      "display" : "training",
      "definition" : "To perform one or more operations on information used in training and education.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23419"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HOPERAT"
        }
      ]
    },
    {
      "code" : "MLTRAINING",
      "display" : "machine learning training",
      "definition" : "To perform one or more operations on information used in training a machine learning (AI) model.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "123419"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HOPERAT"
        }
      ]
    },
    {
      "code" : "CLMATTCH",
      "display" : "claim attachment",
      "definition" : "To perform one or more operations on information for provision of additional clinical evidence in support of a request for coverage or payment for health services.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23421"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HPAYMT"
        }
      ]
    },
    {
      "code" : "COVAUTH",
      "display" : "coverage authorization",
      "definition" : "To perform one or more operations on information for conducting prior authorization or predetermination of coverage for services.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23422"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HPAYMT"
        }
      ]
    },
    {
      "code" : "COVERAGE",
      "display" : "coverage under policy or program",
      "definition" : "To perform one or more operations on information for conducting activities related to coverage under a program or policy.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23456"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HPAYMT"
        }
      ]
    },
    {
      "code" : "REMITADV",
      "display" : "remittance advice",
      "definition" : "To perform one or more operations on information about the amount remitted for a health care claim.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23423"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HPAYMT"
        }
      ]
    },
    {
      "code" : "PMTDS",
      "display" : "decision support assisted payment decision",
      "definition" : "To apply algorithms (e.g. AI, CDS) to perform one or more operations on information to arrive at decision used in payment for provision of health care.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "123423"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HPAYMT"
        }
      ]
    },
    {
      "code" : "BIORCH",
      "display" : "biomedical research",
      "definition" : "To perform one or more operations on information for conducting scientific investigations to obtain health care knowledge. Use of the data must be related to specified biomedical basic or applied research. For example, research on rare plants to determine whether biologic properties may be useful for pharmaceutical development. May be used in combination with clinical trial and other healthcare research purposes of use.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23864"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HRESCH"
        }
      ]
    },
    {
      "code" : "CLINTRCH",
      "display" : "clinical trial research",
      "definition" : "To perform one or more operations on information for conducting scientific investigations in accordance with clinical trial protocols to obtain health care knowledge.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23424"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HRESCH"
        }
      ]
    },
    {
      "code" : "DSRCH",
      "display" : "disease specific healthcare research",
      "definition" : "To perform one or more operations on information for conducting scientific investigations to obtain health care knowledge. Use of the data must be related to specified conditions, diagnosis, or disease healthcare research. For example, conducting cancer research by testing reaction of tumor cells to certain biologics. May be used in combination with clinical trial and other healthcare research purposes of use.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23865"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HRESCH"
        }
      ]
    },
    {
      "code" : "POARCH",
      "display" : "population origins or ancestry healthcare research",
      "definition" : "To perform one or more operations on information, including genealogical pedigrees, historical records, surveys, family health data, health records, and genetic information, for conducting scientific investigations to obtain health care knowledge. Use of the data must be related to population origins and/or ancestry healthcare research. For example, gathering genetic specimens from a specific population in order to determine the ancestry and population origins of that group. May be used in combination with clinical trial and other healthcare research purposes of use.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23866"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HRESCH"
        }
      ]
    },
    {
      "code" : "TRANSRCH",
      "display" : "translational healthcare research",
      "definition" : "To perform one or more operations on information for conducting scientific investigations to obtain health care knowledge related to evidence based medicine during the course of providing healthcare treatment. Sometimes referred to as \"bench to bedside\", which is the iterative feedback loop between healthcare research and clinical trials with input from information collected in the course of routine provision of healthcare. For example, by extending a patient encounter to conduct a survey related to a research topic such as attitudes about use of a wellness device that a patient agreed to use. May be used in combination with clinical trial and other healthcare research purposes of use.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23867"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HRESCH"
        }
      ]
    },
    {
      "code" : "LABELING",
      "display" : "labeling",
      "definition" : "To perform one or more operations on information to assign, persist, and manage labels to healthcare data to characterize various aspects, such as its security classification, sensitivity, compartment, integrity, and provenance; applicable privacy, consent, security, provenance, and trust policies; and handling caveats such as purpose of use, obligations, and refrain policies.\r\n\r\nLabel management includes classification of target data by constructing and binding of a label set per applicable policies, security policy information file semantics, and classification guides. Label management also includes process and procedures for subsequent revision of a label for, e.g., reclassification, downgrading classification, and declassification.\r\n\r\nLabel revisions may be triggered by, e.g., expiry of classification period; changes in applicable policy, e.g., revocation of a consent directive; or changes in the governing policy domain in which the data is relocated or a copy of the data is sent. If a label is revised, an audit log should be kept and the provenance of the label changes should be tracked.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23871"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HSYSADMIN"
        }
      ]
    },
    {
      "code" : "METAMGT",
      "display" : "metadata management",
      "definition" : "To perform one or more operations on information to assign, persist, and manage metadata to healthcare data to characterize various aspects used for its indexing, discovery, retrieval, and processing by systems, applications, and end users. For example, master index identifier, media type, and location.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23872"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "HSYSADMIN"
        }
      ]
    },
    {
      "code" : "NOPRODMTCH",
      "display" : "no product match",
      "definition" : "**Description:** There is no match for the product in the master file repository.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22909"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "NOMATCH"
        }
      ]
    },
    {
      "code" : "NOSERMTCH",
      "display" : "no service match",
      "definition" : "**Description:** There is no match for the service in the master file repository.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22910"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "NOMATCH"
        }
      ]
    },
    {
      "code" : "NOVERMTCH",
      "display" : "no version match",
      "definition" : "**Description:** There is no match for the record and version.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23279"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "NOMATCH"
        }
      ]
    },
    {
      "code" : "NOAGNTPERM",
      "display" : "no agent permission",
      "definition" : "**Description:** The agent does not have permission.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22913"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "NOPERM"
        }
      ]
    },
    {
      "code" : "NOUSRPERM",
      "display" : "no user permission",
      "definition" : "**Description:** The user does not have permission.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "22912"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "NOPERM"
        }
      ]
    },
    {
      "code" : "ACCRED",
      "display" : "accreditation",
      "definition" : "**Description:**Operational activities conducted for the purposes of meeting of criteria defined by an accrediting entity for an activity, product, or service",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22704"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OPERAT"
        }
      ]
    },
    {
      "code" : "COMPL",
      "display" : "compliance",
      "definition" : "**Description:**Operational activities required to meet a mandate related to an activity, product, or service",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22702"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OPERAT"
        }
      ]
    },
    {
      "code" : "ENADMIN",
      "display" : "entity administration",
      "definition" : "**Description:**Operational activities conducted to administer information relating to entities involves with an activity, product, or service",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22705"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OPERAT"
        }
      ]
    },
    {
      "code" : "OUTCOMS",
      "display" : "outcome measure",
      "definition" : "**Description:**Operational activities conducted for the purposes of assessing the results of an activity, product, or service",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22701"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OPERAT"
        }
      ]
    },
    {
      "code" : "PRGRPT",
      "display" : "program reporting",
      "definition" : "**Description:**Operational activities conducted to meet program accounting requirements related to an activity, product, or service",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22703"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OPERAT"
        }
      ]
    },
    {
      "code" : "QUALIMP",
      "display" : "quality improvement",
      "definition" : "**Description:**Operational activities conducted for the purposes of improving the quality of an activity, product, or service",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22700"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OPERAT"
        }
      ]
    },
    {
      "code" : "SYSADMN",
      "display" : "system administration",
      "definition" : "**Description:**Operational activities conducted to administer the electronic systems used for an activity, product, or service",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22706"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OPERAT"
        }
      ]
    },
    {
      "code" : "FAMRQT",
      "display" : "family requested",
      "definition" : "To perform one or more operations on information in response to a request by a family member authorized by the patient.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23426"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "PATRQT"
        }
      ]
    },
    {
      "code" : "PWATRNY",
      "display" : "power of attorney",
      "definition" : "To perform one or more operations on information in response to a request by a person appointed as the patient's legal representative.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23427"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "PATRQT"
        }
      ]
    },
    {
      "code" : "SUPNWK",
      "display" : "support network",
      "definition" : "To perform one or more operations on information in response to a request by a person authorized by the patient.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23428"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "PATRQT"
        }
      ]
    },
    {
      "code" : "DISASTER",
      "display" : "disaster",
      "definition" : "To perform one or more operations on information used for provision of immediately needed health care to a population of living subjects located in a disaster zone.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23410"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "PUBHLTH"
        }
      ]
    },
    {
      "code" : "THREAT",
      "display" : "threat",
      "definition" : "To perform one or more operations on information used to prevent injury or disease to living subjects who may be the target of violence.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23411"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "PUBHLTH"
        }
      ]
    },
    {
      "code" : "HMARKT",
      "display" : "healthcare marketing",
      "definition" : "To perform one or more operations on information for marketing services and products related to health care.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22678"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "PurposeOfUse"
        }
      ]
    },
    {
      "code" : "HOPERAT",
      "display" : "healthcare operations",
      "definition" : "To perform one or more operations on information used for conducting administrative and contractual activities related to the provision of health care.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22686"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "PurposeOfUse"
        }
      ]
    },
    {
      "code" : "HPAYMT",
      "display" : "healthcare payment",
      "definition" : "To perform one or more operations on information for conducting financial or contractual activities related to payment for provision of health care.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22685"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "PurposeOfUse"
        }
      ]
    },
    {
      "code" : "HRESCH",
      "display" : "healthcare research",
      "definition" : "To perform one or more operations on information for conducting scientific investigations to obtain health care knowledge. Use of the data iincludes basic and applied research such as biomedical, population origin or ancestry, translational research, and disease, discipline, specialty specific healthcare research and clinical trial research.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22679"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "PurposeOfUse"
        }
      ]
    },
    {
      "code" : "PATRQT",
      "display" : "patient requested",
      "definition" : "To perform one or more operations on information in response to a patient's request.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23425"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "PurposeOfUse"
        }
      ]
    },
    {
      "code" : "PUBHLTH",
      "display" : "public health",
      "definition" : "To perform one or more operations on information for conducting public health activities, such as the reporting of notifiable conditions.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23409"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "PurposeOfUse"
        }
      ]
    },
    {
      "code" : "TREAT",
      "display" : "treatment",
      "definition" : "To perform one or more operations on information for provision of health care.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22680"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "PurposeOfUse"
        }
      ]
    },
    {
      "code" : "DOSECHG",
      "display" : "change in medication/dose",
      "definition" : "**Description:**The medication is being re-prescribed at a different dosage.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21705"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "REPLACE"
        }
      ]
    },
    {
      "code" : "HTEST",
      "display" : "test health data",
      "definition" : "To perform one or more operations on information that is simulated or synthetic health data used for testing system capabilities outside of a production or operational system environment.\r\n\r\n*Usage Note:* Data marked with a HTEST security label enables an access control system to permit interfacing systems or end users provisioned with a clearance, which includes a HTEST purpose of use attribute, to test, verify, or validate that a system or application will operate in production as intended based on design specifications.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23874"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SYSDEV"
        }
      ]
    },
    {
      "code" : "CLINTRL",
      "display" : "clinical trial",
      "definition" : "To perform health care as part of the clinical trial protocol.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22684"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "TREAT"
        }
      ]
    },
    {
      "code" : "COC",
      "display" : "coordination of care",
      "definition" : "To perform one or more actions on information in order to organize the provision and case management of an individual's healthcare, including: Monitoring a person's goals, needs, and preferences; acting as the communication link between two or more participants concerned with a person's health and wellness; organizing and facilitating care activities and promoting self-management by advocating for, empowering, and educating a person; and ensuring safe, appropriate, non-duplicative, and effective integrated care.\r\n\r\n*Usage Note:* Use when describing these functions: 1. Monitoring a person's goals, needs, and preferences. 2. Acting as the communication link between two or more participants concerned with a person's health and wellness. 3. Organizing and facilitating care activities and promoting self-management by advocating for, empowering, and educating a person. 4. Ensuring safe, appropriate, non-duplicative, and effective integrated care.\r\n\r\nThe goal is to clearly differentiate this type of coordination of care from HIPAA Operations by specifying that these actions on information are undertaken in the provision of healthcare treatment.\r\n\r\nFor similar uses of this concept, see SAMHSA Confidentiality of Substance Use Disorder Patient Records Supplemental notice of proposed rulemaking, which differentiates concepts of care coordination and case management for the provision of treatment as specifically distinct from activities related to health care delivery management and the operations of organizational entities involved in the delivery of healthcare.\r\n\r\n*Map:* Maps to ISO 14265 Classification Terms: \"Support of care activities within the provider organisation for an individual subject of care\" described as \"To inform persons or processes enabling others to provide health care services to the subject of care.\" \"Subject of Care Uses\" described as \"To inform the subject of care in support of his or her own interests.\"",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23927"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "TREAT"
        }
      ]
    },
    {
      "code" : "ETREAT",
      "display" : "Emergency Treatment",
      "definition" : "To perform one or more operations on information for provision of immediately needed health care for an emergent condition.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22682"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "TREAT"
        }
      ]
    },
    {
      "code" : "POPHLTH",
      "display" : "population health",
      "definition" : "To perform one or more operations on information for provision of health care to a population of living subjects, e.g., needle exchange program.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22681"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "TREAT"
        }
      ]
    },
    {
      "code" : "TREATDS",
      "display" : "decision support assisted treatment decision",
      "definition" : "To apply algorithms (e.g. AI, CDS) to perform one or more operations on information to arrive at decision used in health care treatment.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "122681"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "TREAT"
        }
      ]
    }
  ]
}

```
