# addressUsage - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **addressUsage**

## CodeSystem: addressUsage 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0617 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AddressUsage |
| *Other Identifiers:*OID:2.16.840.1.113883.18.375 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts specifying how an address is intended to be used. Used in HL7 Version 2.x messaging in the XAD segment. 

 
Underlying Master Code System for V2 table 0617 (Address Usage) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSAddressUsage](ValueSet-v2-0617.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0617",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "inm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0617",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.375"
    }
  ],
  "version" : "3.0.0",
  "name" : "AddressUsage",
  "title" : "addressUsage",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying how an address is intended to be used.  Used in HL7 Version 2.x messaging in the XAD segment.",
  "purpose" : "Underlying Master Code System for V2 table 0617 (Address Usage)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0617",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    },
    {
      "code" : "v2-concCommentAsPub",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concCommentAsPub",
      "description" : "V2 Concept Comment As Published",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "6259",
      "code" : "M",
      "display" : "Mailing",
      "definition" : "Mailing",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Identifies an address for mail correspondence from a healthcare provider as stipulated by the subject.\r\nFor example, under the tenets of certain privacy regulations, it is exclusive to the patient and is typically maintained at the encounter or visit level versus the person level as it only has relevance to the specifics of a given encounter.  This is an exception category of address in that the patient has stipulated that they want all correspondence relevant to a given encounter sent to this address in lieu of any other address on file.  Providers are required to accommodate such requests under HIPAA promulgated regulation.  Note that mailing and legal address may be mutually exclusive as defined below.  (Implementors are reminded that although the privacy regulation requires the provider to honor such requests, it does require the provider to enquire whether the patient has a preferred address other than the one volunteered.)"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Identifies an address for mail correspondence from a healthcare provider as stipulated by the subject.\r\nFor example, under the tenets of certain privacy regulations, it is exclusive to the patient and is typically maintained at the encounter or visit level versus the person level as it only has relevance to the specifics of a given encounter.  This is an exception category of address in that the patient has stipulated that they want all correspondence relevant to a given encounter sent to this address in lieu of any other address on file.  Providers are required to accommodate such requests under HIPAA promulgated regulation.  Note that mailing and legal address may be mutually exclusive as defined below.  (Implementors are reminded that although the privacy regulation requires the provider to honor such requests, it does require the provider to enquire whether the patient has a preferred address other than the one volunteered.)"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6260",
      "code" : "V",
      "display" : "Visit",
      "definition" : "Visit",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Identifies an address at which the individual is physically located and may be visited."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Identifies an address at which the individual is physically located and may be visited."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6261",
      "code" : "C",
      "display" : "Classification",
      "definition" : "Classification",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Identifies an address used for the purpose of demographic classification or searching.  Such addresses frequently contain insufficient information to be used as mailing or visit addresses.  For example, they may only indicate country and postal code, without providing a street address."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Identifies an address used for the purpose of demographic classification or searching.  Such addresses frequently contain insufficient information to be used as mailing or visit addresses.  For example, they may only indicate country and postal code, without providing a street address."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
