# serviceRequestRelationship - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **serviceRequestRelationship**

## CodeSystem: serviceRequestRelationship 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0506 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ServiceRequestRelationship |
| *Other Identifiers:*OID:2.16.840.1.113883.18.330 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts used to specify an additional or alternate relationship between this service request and other service requests. Used in the Timing/Quantity Relationship (TQ2) segment in HL7 Version 2.x messaging. 

 
Underlying Master Code System for V2 table 0506 (Service Request Relationship) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSServiceRequestRelationship](ValueSet-v2-0506.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0506",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0506",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.330"
    }
  ],
  "version" : "3.0.0",
  "name" : "ServiceRequestRelationship",
  "title" : "serviceRequestRelationship",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts used to specify an additional or alternate relationship between this service request and other service requests.  Used in the Timing/Quantity Relationship (TQ2) segment in HL7 Version 2.x messaging.",
  "purpose" : "Underlying Master Code System for V2 table 0506 (Service Request Relationship)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0506",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    },
    {
      "code" : "v2-concCommentAsPub",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concCommentAsPub",
      "description" : "V2 Concept Comment As Published",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "5522",
      "code" : "N",
      "display" : "Nurse prerogative",
      "definition" : "Nurse prerogative",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Where a set of two or more orders exist and the Nurse, or other caregiver, has the prerogative to choose which order will be administered at a particular point in time.  For example,\r\n\tMilk of Magnesia PO 30 ml qhs (at bedtime)\r\n\tDulcolax Supp R @ hs prn\r\n\tColace 100 mg capsule PO bid \r\nThe nurse would be administering MOM, but may add the Colace and may also give the Dulcolax Supp as needed to promote and maintain regularity."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Where a set of two or more orders exist and the Nurse, or other caregiver, has the prerogative to choose which order will be administered at a particular point in time.  For example,\r\n\tMilk of Magnesia PO 30 ml qhs (at bedtime)\r\n\tDulcolax Supp R @ hs prn\r\n\tColace 100 mg capsule PO bid \r\nThe nurse would be administering MOM, but may add the Colace and may also give the Dulcolax Supp as needed to promote and maintain regularity."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5523",
      "code" : "C",
      "display" : "Compound",
      "definition" : "Compound",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "A compound is an extempo order which may be made up of multiple drugs.  For example, many hospitals have a standard item called \"Magic Mouthwash\".  The item is ordered that way by the physician. The extempo items will contain multiple products, such as Maalox, Benadryl, Xylocaine, etc.  They will all be mixed together and will be dispensed in a single container."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "A compound is an extempo order which may be made up of multiple drugs.  For example, many hospitals have a standard item called \"Magic Mouthwash\".  The item is ordered that way by the physician. The extempo items will contain multiple products, such as Maalox, Benadryl, Xylocaine, etc.  They will all be mixed together and will be dispensed in a single container."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5524",
      "code" : "T",
      "display" : "Tapering",
      "definition" : "Tapering",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "A tapering order is one in which the same drug is used, but it has a declining dosage over a number of days.\r\nFor example, Decadron 0.5 mg is often ordered this way.  The order would look like this:\r\n\tDecadron 0.5 mg qid (four times a day) for 2 days, then\r\n\tDecadron 0.5 mg tid (three times a day) for 2 days, then\r\n\tDecadron 0.5 mg bid (twice a day) for 2 days, then\r\n\tDecadron 0.5 mg qd (daily) for 2 days, then stop."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "A tapering order is one in which the same drug is used, but it has a declining dosage over a number of days.\r\nFor example, Decadron 0.5 mg is often ordered this way.  The order would look like this:\r\n\tDecadron 0.5 mg qid (four times a day) for 2 days, then\r\n\tDecadron 0.5 mg tid (three times a day) for 2 days, then\r\n\tDecadron 0.5 mg bid (twice a day) for 2 days, then\r\n\tDecadron 0.5 mg qd (daily) for 2 days, then stop."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5525",
      "code" : "E",
      "display" : "Exclusive",
      "definition" : "Exclusive",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "An exclusive order is an order where only one of the multiple items should be administered at any one dosage time.  The nurse may chose between the alternatives, but should only give ONE of them.  An example would be: Phenergan 25 mg PO, IM or R q6h prn (orally, intramuscularly, or rectally every 6 hours as needed)."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "An exclusive order is an order where only one of the multiple items should be administered at any one dosage time.  The nurse may chose between the alternatives, but should only give ONE of them.  An example would be: Phenergan 25 mg PO, IM or R q6h prn (orally, intramuscularly, or rectally every 6 hours as needed)."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5526",
      "code" : "S",
      "display" : "Simultaneous",
      "definition" : "Simultaneous",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "A simultaneous order is 2 or more drugs which are ordered to be given at the same time.  A common example of this would be Demerol and Phenergan (Phenergan is given with the Demerol to control the nausea that Demerol can cause).  The order could be: Demerol 50 mg IM with Phenergan 25 mg IM q4h prn (every 4 hours as needed)."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "A simultaneous order is 2 or more drugs which are ordered to be given at the same time.  A common example of this would be Demerol and Phenergan (Phenergan is given with the Demerol to control the nausea that Demerol can cause).  The order could be: Demerol 50 mg IM with Phenergan 25 mg IM q4h prn (every 4 hours as needed)."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
