# sequenceCondition - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **sequenceCondition**

## CodeSystem: sequenceCondition 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0504 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:SequenceCondition |
| *Other Identifiers:*OID:2.16.840.1.113883.18.328 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts used to specify the relationship between the start/end of the related service request(s) (from TQ2-3, TQ2-4 or TQ2-5) and the current service request from ORC-2, 3 or 4. Used in HL7 Version 2.x messaging in the TQ2 segment. 

 
Underlying Master Code System for V2 table 0504 (Sequence Condition Code) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSSequenceConditionCode](ValueSet-v2-0504.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0504",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0504",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.328"
    }
  ],
  "version" : "3.0.0",
  "name" : "SequenceCondition",
  "title" : "sequenceCondition",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts used to specify the relationship between the start/end of the related service request(s) (from TQ2-3, TQ2-4 or TQ2-5) and the current service request from ORC-2, 3 or 4.  Used in HL7 Version 2.x messaging in the TQ2 segment.",
  "purpose" : "Underlying Master Code System for V2 table 0504 (Sequence Condition Code)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0504",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "5514",
      "code" : "EE",
      "display" : "End related service request(s), end current service request.",
      "definition" : "End related service request(s), end current service request.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5515",
      "code" : "ES",
      "display" : "End related service request(s), start current service request.",
      "definition" : "End related service request(s), start current service request.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5516",
      "code" : "SS",
      "display" : "Start related service request(s), start current service request.",
      "definition" : "Start related service request(s), start current service request.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5517",
      "code" : "SE",
      "display" : "Start related service request(s), end current service request.",
      "definition" : "Start related service request(s), end current service request.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
