# non-subjectConsenterReason - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **non-subjectConsenterReason**

## CodeSystem: non-subjectConsenterReason 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0502 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:NonSubjectConsenterReason |
| *Other Identifiers:*OID:2.16.840.1.113883.18.326 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts used to specify a reason consent was granted by a person other than the subject of the consent. Used in the Consent (CON) segment in HL7 Version 2.x messaging. 

 
Underlying Master Code System for V2 table 0502 (Non-Subject Consenter Reason) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSNonSubjectConsenterReason](ValueSet-v2-0502.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0502",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "sd"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0502",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.326"
    }
  ],
  "version" : "3.0.0",
  "name" : "NonSubjectConsenterReason",
  "title" : "non-subjectConsenterReason",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined  code system of concepts used to specify a reason consent was granted by a person other than the subject of the consent.  Used in the Consent (CON) segment in HL7 Version 2.x messaging.",
  "purpose" : "Underlying Master Code System for V2 table 0502 (Non-Subject Consenter Reason)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0502",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "5508",
      "code" : "MIN",
      "display" : "Subject is a minor",
      "definition" : "Subject is a minor",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5509",
      "code" : "NC",
      "display" : "Subject is not competent to consent",
      "definition" : "Subject is not competent to consent",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5510",
      "code" : "LM",
      "display" : "Legally mandated",
      "definition" : "Legally mandated",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
