# bodySiteModifier - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **bodySiteModifier**

## CodeSystem: bodySiteModifier 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0495 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:BodySiteModifier |
| *Other Identifiers:*OID:2.16.840.1.113883.18.319 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts specifying the modifier for the body site. Used in HL7 Version 2.x messaging in the RXR segment. 

 
Underlying Master Code System for V2 table 0495 (Body Site Modifier) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSBodySiteModifier](ValueSet-v2-0495.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0495",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0495",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.319"
    }
  ],
  "version" : "3.0.0",
  "name" : "BodySiteModifier",
  "title" : "bodySiteModifier",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying the modifier for the body site.  Used in HL7 Version 2.x messaging in the RXR segment.",
  "purpose" : "Underlying Master Code System for V2 table 0495 (Body Site Modifier)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0495",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "5338",
      "code" : "ANT",
      "display" : "Anterior",
      "definition" : "Anterior",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5339",
      "code" : "BIL",
      "display" : "Bilateral",
      "definition" : "Bilateral",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5340",
      "code" : "DIS",
      "display" : "Distal",
      "definition" : "Distal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5341",
      "code" : "EXT",
      "display" : "External",
      "definition" : "External",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5342",
      "code" : "LAT",
      "display" : "Lateral",
      "definition" : "Lateral",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5343",
      "code" : "L",
      "display" : "Left",
      "definition" : "Left",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "links"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5344",
      "code" : "LOW",
      "display" : "Lower",
      "definition" : "Lower",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5345",
      "code" : "MED",
      "display" : "Medial",
      "definition" : "Medial",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5346",
      "code" : "POS",
      "display" : "Posterior",
      "definition" : "Posterior",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5347",
      "code" : "PRO",
      "display" : "Proximal",
      "definition" : "Proximal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5348",
      "code" : "LLQ",
      "display" : "Quadrant, Left Lower",
      "definition" : "Quadrant, Left Lower",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5349",
      "code" : "LUQ",
      "display" : "Quadrant, Left Upper",
      "definition" : "Quadrant, Left Upper",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5350",
      "code" : "RLQ",
      "display" : "Quadrant, Right Lower",
      "definition" : "Quadrant, Right Lower",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5351",
      "code" : "RUQ",
      "display" : "Quadrant, Right Upper",
      "definition" : "Quadrant, Right Upper",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5352",
      "code" : "R",
      "display" : "Right",
      "definition" : "Right",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5353",
      "code" : "UPP",
      "display" : "Upper",
      "definition" : "Upper",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
