# paymentAdjustmentInformation - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **paymentAdjustmentInformation**

## CodeSystem: paymentAdjustmentInformation 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0468 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:PaymentAdjustmentInformation |
| *Other Identifiers:*OID:2.16.840.1.113883.18.297 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts specifying any payment adjustment due to drugs or medical devices. Used in HL7 Version 2.x messaging in the GP2 segment. 

 
Underlying Master Code System for V2 table 0468 (Payment Adjustment Code) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSPaymentAdjustmentCode](ValueSet-v2-0468.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0468",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0468",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.297"
    }
  ],
  "version" : "3.0.0",
  "name" : "PaymentAdjustmentInformation",
  "title" : "paymentAdjustmentInformation",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying any payment adjustment due to drugs or medical devices.  Used in HL7 Version 2.x messaging in the GP2 segment.",
  "purpose" : "Underlying Master Code System for V2 table 0468 (Payment Adjustment Code)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0468",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "4851",
      "code" : "1",
      "display" : "No payment adjustment",
      "definition" : "No payment adjustment",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4852",
      "code" : "2",
      "display" : "Designated current drug or biological payment adjustment applies to APC (status indicator G)",
      "definition" : "Designated current drug or biological payment adjustment applies to APC (status indicator G)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4853",
      "code" : "3",
      "display" : "Designated new device payment adjustment applies to APC (status indicator H)",
      "definition" : "Designated new device payment adjustment applies to APC (status indicator H)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4854",
      "code" : "4",
      "display" : "Designated new drug or new biological payment adjustment applies to APC (status indicator J)",
      "definition" : "Designated new drug or new biological payment adjustment applies to APC (status indicator J)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4855",
      "code" : "5",
      "display" : "Deductible not applicable (specific list of HCPCS codes)",
      "definition" : "Deductible not applicable (specific list of HCPCS codes)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
