# overallClaimDisposition - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **overallClaimDisposition**

## CodeSystem: overallClaimDisposition 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0457 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:OverallClaimDisposition |
| *Other Identifiers:*OID:2.16.840.1.113883.18.292 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts specifying the final status of the claim. Used in HL7 Version 2.x messaging in the GP1 segment. 

 
Underlying Master Code System for V2 table 0457 (Overall Claim Disposition Code) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSOverallClaimDispositionCode](ValueSet-v2-0457.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0457",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0457",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.292"
    }
  ],
  "version" : "3.0.0",
  "name" : "OverallClaimDisposition",
  "title" : "overallClaimDisposition",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying the final status of the claim.  Used in HL7 Version 2.x messaging in the GP1 segment.",
  "purpose" : "Underlying Master Code System for V2 table 0457 (Overall Claim Disposition Code)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0457",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "4832",
      "code" : "0",
      "display" : "No edits present on claim",
      "definition" : "No edits present on claim",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4833",
      "code" : "1",
      "display" : "Only edits present are for line item denial or rejection",
      "definition" : "Only edits present are for line item denial or rejection",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4834",
      "code" : "2",
      "display" : "Multiple-day claim with one or more days denied or rejected",
      "definition" : "Multiple-day claim with one or more days denied or rejected",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4835",
      "code" : "3",
      "display" : "Claim denied, rejected, suspended or returned to provider with only post payment edits",
      "definition" : "Claim denied, rejected, suspended or returned to provider with only post payment edits",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4836",
      "code" : "4",
      "display" : "Claim denied, rejected, suspended or returned to provider with only pre payment edits",
      "definition" : "Claim denied, rejected, suspended or returned to provider with only pre payment edits",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
