# immunizationRegistryStatus - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **immunizationRegistryStatus**

## CodeSystem: immunizationRegistryStatus 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0441 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ImmunizationRegistryStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.18.281 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts specifying the immunization registry status of the patient. Used in HL7 Version 2.x messaging in the PD1 segment. 

 
Underlying Master Code System for V2 table 0441 (Immunization Registry Status) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSImmunizationRegistryStatus](ValueSet-v2-0441.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0441",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0441",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.281"
    }
  ],
  "version" : "3.0.0",
  "name" : "ImmunizationRegistryStatus",
  "title" : "immunizationRegistryStatus",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying the immunization registry status of the patient.  Used in HL7 Version 2.x messaging in the PD1 segment.",
  "purpose" : "Underlying Master Code System for V2 table 0441 (Immunization Registry Status)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0441",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "4783",
      "code" : "A",
      "display" : "Active",
      "definition" : "Active",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4784",
      "code" : "I",
      "display" : "Inactive",
      "definition" : "Inactive",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4785",
      "code" : "L",
      "display" : "Inactive - Lost to follow-up (cancel contract)",
      "definition" : "Inactive - Lost to follow-up (cancel contract)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4786",
      "code" : "M",
      "display" : "Inactive - Moved or gone elsewhere (cancel contract)",
      "definition" : "Inactive - Moved or gone elsewhere (cancel contract)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4787",
      "code" : "P",
      "display" : "Inactive - Permanently inactive (Do not reactivate or add new entries to the record)",
      "definition" : "Inactive - Permanently inactive (Do not reactivate or add new entries to the record)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4788",
      "code" : "O",
      "display" : "Other",
      "definition" : "Other",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4789",
      "code" : "U",
      "display" : "Unknown",
      "definition" : "Unknown",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
