# matchAlgorithms - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **matchAlgorithms**

## CodeSystem: matchAlgorithms 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0393 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:MatchAlgorithms |
| *Other Identifiers:*OID:2.16.840.1.113883.18.244 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts identifying the name or identity of the specific search algorithm to which the RCP-5 Search Confidence Threshold and the QRI-1 Candidate Confidence refer. Used in HL7 Version 2.x messaging in the Query Response Instance (QRI) segment. 

 
Underlying Master Code System for V2 table 0393 (Match Algorithms) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSMatchAlgorithms](ValueSet-v2-0393.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0393",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "inm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0393",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.244"
    }
  ],
  "version" : "3.0.0",
  "name" : "MatchAlgorithms",
  "title" : "matchAlgorithms",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts identifying the name or identity of the specific search algorithm to which the RCP-5 Search Confidence Threshold and the QRI-1 Candidate Confidence refer.  Used in HL7 Version 2.x messaging in the Query Response Instance (QRI) segment.",
  "purpose" : "Underlying Master Code System for V2 table 0393 (Match Algorithms)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0393",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "4016",
      "code" : "LINKSOFT_2.01",
      "display" : "Proprietary algorithm for LinkSoft v2.01",
      "definition" : "Proprietary algorithm for LinkSoft v2.01",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4017",
      "code" : "MATCHWARE_1.2",
      "display" : "Proprietary algorithm for MatchWare v1.2",
      "definition" : "Proprietary algorithm for MatchWare v1.2",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
