# processingType - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **processingType**

## CodeSystem: processingType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0388 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ProcessingType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.239 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts identifying the processing type that applies to the test code. If this attribute is omitted, then regular production is the default. Used in HL7 Version 2.x messaging in the Test Code Configuration (TCC) segment. 

 
Underlying Master Code System for V2 table 0388 (Processing Type) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSProcessingType](ValueSet-v2-0388.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0388",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0388",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.239"
    }
  ],
  "version" : "3.0.0",
  "name" : "ProcessingType",
  "title" : "processingType",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts identifying the processing type that applies to the test code.  If this attribute is omitted, then regular production is the default.  Used in HL7 Version 2.x messaging in the Test Code Configuration (TCC) segment.",
  "purpose" : "Underlying Master Code System for V2 table 0388 (Processing Type)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0388",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "3858",
      "code" : "P",
      "display" : "Regular Production",
      "definition" : "Regular Production",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3859",
      "code" : "E",
      "display" : "Evaluation",
      "definition" : "Evaluation",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
