# daysOfTheWeek - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **daysOfTheWeek**

## CodeSystem: daysOfTheWeek 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0267 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:DaysOfTheWeek |
| *Other Identifiers:*OID:2.16.840.1.113883.18.160 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts used to identify the day(s) of the week when a location may be scheduled for appointments. Used in HL7 Version 2.x messaging in the UVC and LDP segments. 

 
Underlying Master Code System for V2 table 0267 (Days of the Week) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSDaysOfTheWeek](ValueSet-v2-0267.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0267",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "inm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0267",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.160"
    }
  ],
  "version" : "3.0.0",
  "name" : "DaysOfTheWeek",
  "title" : "daysOfTheWeek",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts used to identify the day(s) of the week when a location may be scheduled for appointments.  Used in HL7 Version 2.x messaging in the UVC and LDP segments.",
  "purpose" : "Underlying Master Code System for V2 table 0267 (Days of the Week)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0267",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "2619",
      "code" : "SAT",
      "display" : "Saturday",
      "definition" : "Saturday",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2620",
      "code" : "SUN",
      "display" : "Sunday",
      "definition" : "Sunday",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2621",
      "code" : "MON",
      "display" : "Monday",
      "definition" : "Monday",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2622",
      "code" : "TUE",
      "display" : "Tuesday",
      "definition" : "Tuesday",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2623",
      "code" : "WED",
      "display" : "Wednesday",
      "definition" : "Wednesday",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2624",
      "code" : "THU",
      "display" : "Thursday",
      "definition" : "Thursday",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2625",
      "code" : "FRI",
      "display" : "Friday",
      "definition" : "Friday",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
