# specimenAction - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **specimenAction**

## CodeSystem: specimenAction 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0065 | *Version*:3.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:SpecimenAction |
| *Other Identifiers:*OID:2.16.840.1.113883.18.25 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts which specify actions to be taken with respect to the specimens that accompany or precede an order. The purpose of these are to further qualify (when appropriate) the general action indicated by the order control code (code system xxxx). Used in HL7 Version 2.x messaging in the OBR segment. 

 
Underlying Master Code System for V2 table 0065 (Specimen Action Code) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSActionCode](ValueSet-v2-0065.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0065",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0065",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.25"
    }
  ],
  "version" : "3.0.0",
  "name" : "SpecimenAction",
  "title" : "specimenAction",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts which specify actions to be taken with respect to the specimens that accompany or precede an order.  The purpose of these are to further qualify (when appropriate) the general action indicated by the order control code (code system xxxx).  Used in HL7 Version 2.x messaging in the OBR segment.",
  "purpose" : "Underlying Master Code System for V2 table 0065 (Specimen Action Code)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0065",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "871",
      "code" : "C",
      "display" : "Cancel order for battery or tests named",
      "definition" : "Cancel order for battery or tests named",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Stornoauftrag zu bekannter Probe"
        }
      ],
      "property" : [
        {
          "code" : "v2-table-deprecated",
          "valueCode" : "2.9"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "872",
      "code" : "A",
      "display" : "Add ordered tests to the existing specimen",
      "definition" : "Add ordered tests to the existing specimen",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Zusätzliche Tests zur vorhandenen Probe"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "873",
      "code" : "G",
      "display" : "Generated order; reflex order",
      "definition" : "Generated order; reflex order",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Nachgeordneter Auftrag / Auftrag als Reaktion auf Untersuchungsergebnis"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "874",
      "code" : "L",
      "display" : "Lab to obtain specimen from patient",
      "definition" : "Lab to obtain specimen from patient",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Holauftrag für Labor"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "875",
      "code" : "O",
      "display" : "Specimen obtained by service other than Lab",
      "definition" : "Specimen obtained by service other than Lab",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Probe wird / wurde mit dem Auftrag zur Verfügung gestellt"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "876",
      "code" : "P",
      "display" : "Pending specimen; Order sent prior to delivery",
      "definition" : "Pending specimen; Order sent prior to delivery",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Probe steht noch aus - Auftrag liegt schon vor"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "877",
      "code" : "R",
      "display" : "Revised order",
      "definition" : "Revised order",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Geänderter Auftrag"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "878",
      "code" : "S",
      "display" : "Schedule the tests specified below",
      "definition" : "Schedule the tests specified below",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Spezifizierte Untersuchungen einplanen"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
