# Substance Category Codes - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Substance Category Codes**

## CodeSystem: Substance Category Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/substance-category | *Version*:1.0.1 | | |
| Active as of 2026-01-26 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:SubstanceCategoryCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1138 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
Substance category codes 

 This Code system is referenced in the content logical definition of the following value sets: 

* [SubstanceCategoryCodes](ValueSet-substance-category.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "substance-category",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/substance-category",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1138"
    }
  ],
  "version" : "1.0.1",
  "name" : "SubstanceCategoryCodes",
  "title" : "Substance Category Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-01-26T07:21:33+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Substance category codes",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/substance-category",
  "content" : "complete",
  "concept" : [
    {
      "code" : "allergen",
      "display" : "Allergen",
      "definition" : "A substance that causes an allergic reaction."
    },
    {
      "code" : "biological",
      "display" : "Biological Substance",
      "definition" : "A substance that is produced by or extracted from a biological source."
    },
    {
      "code" : "body",
      "display" : "Body Substance",
      "definition" : "A substance that comes directly from a human or an animal (e.g. blood, urine, feces, tears, etc.)."
    },
    {
      "code" : "chemical",
      "display" : "Chemical",
      "definition" : "Any organic or inorganic substance of a particular molecular identity, including -- (i) any combination of such substances occurring in whole or in part as a result of a chemical reaction or occurring in nature and (ii) any element or uncombined radical (http://www.epa.gov/opptintr/import-export/pubs/importguide.pdf)."
    },
    {
      "code" : "food",
      "display" : "Dietary Substance",
      "definition" : "A food, dietary ingredient, or dietary supplement for human or animal."
    },
    {
      "code" : "drug",
      "display" : "Drug or Medicament",
      "definition" : "A substance intended for use in the diagnosis, cure, mitigation, treatment, or prevention of disease in man or other animals (Federal Food Drug and Cosmetic Act)."
    },
    {
      "code" : "material",
      "display" : "Material",
      "definition" : "A finished product which is not normally ingested, absorbed or injected (e.g. steel, iron, wood, plastic and paper)."
    }
  ]
}

```
