# Organization Alias Type - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization Alias Type**

## CodeSystem: Organization Alias Type 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/organization-alias-type | *Version*:1.0.0 | | |
| Draft as of 2026-01-26 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:OrganizationAliasType |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This code system defines a set of codes for indicating oranization alias type. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [OrganizationAliasType](ValueSet-organization-alias-type.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "organization-alias-type",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/organization-alias-type",
  "version" : "1.0.0",
  "name" : "OrganizationAliasType",
  "title" : "Organization Alias Type",
  "status" : "draft",
  "experimental" : false,
  "date" : "2026-01-26T07:21:33+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This code system defines a set of codes for indicating oranization alias type.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/organization-alias-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "legalalternative",
      "display" : "Legal Alternative",
      "definition" : "A pseudonym used by an organization to perform their business under a name that differs from the registered, legal name of the business, also known as a trade name, business name, or 'doing business as' (d.b.a.)."
    },
    {
      "code" : "historical",
      "display" : "Historical",
      "definition" : "Any previously used legal or trade names used by an organization since the creation of the business. Could include names used by independent organizations before a merger or other reorganization."
    },
    {
      "code" : "common",
      "display" : "Common",
      "definition" : "Common name, i.e. SNAF, Rehab, etc."
    }
  ]
}

```
