# StatisticsCode - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **StatisticsCode**

## CodeSystem: StatisticsCode 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/observation-statistics | *Version*:1.0.0 | |
| Draft as of 2020-04-09 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:StatisticsCode |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1126 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
The statistical operation parameter -"statistic" codes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [StatisticsCode](ValueSet-observation-statistics.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "observation-statistics",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/observation-statistics",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1126"
    }
  ],
  "version" : "1.0.0",
  "name" : "StatisticsCode",
  "title" : "StatisticsCode",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The statistical operation parameter -\"statistic\" codes.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/observation-statistics",
  "content" : "complete",
  "concept" : [
    {
      "code" : "average",
      "display" : "Average",
      "definition" : "The [mean](https://en.wikipedia.org/wiki/Arithmetic_mean) of N measurements over the stated period."
    },
    {
      "code" : "maximum",
      "display" : "Maximum",
      "definition" : "The [maximum](https://en.wikipedia.org/wiki/Maximal_element) value of N measurements over the stated period."
    },
    {
      "code" : "minimum",
      "display" : "Minimum",
      "definition" : "The [minimum](https://en.wikipedia.org/wiki/Minimal_element) value of N measurements over the stated period."
    },
    {
      "code" : "count",
      "display" : "Count",
      "definition" : "The [number] of valid measurements over the stated period that contributed to the other statistical outputs."
    },
    {
      "code" : "total-count",
      "display" : "Total Count",
      "definition" : "The total [number] of valid measurements over the stated period, including observations that were ignored because they did not contain valid result values."
    },
    {
      "code" : "median",
      "display" : "Median",
      "definition" : "The [median](https://en.wikipedia.org/wiki/Median) of N measurements over the stated period."
    },
    {
      "code" : "std-dev",
      "display" : "Standard Deviation",
      "definition" : "The [standard deviation](https://en.wikipedia.org/wiki/Standard_deviation) of N measurements over the stated period."
    },
    {
      "code" : "sum",
      "display" : "Sum",
      "definition" : "The [sum](https://en.wikipedia.org/wiki/Summation) of N measurements over the stated period."
    },
    {
      "code" : "variance",
      "display" : "Variance",
      "definition" : "The [variance](https://en.wikipedia.org/wiki/Variance) of N measurements over the stated period."
    },
    {
      "code" : "20-percent",
      "display" : "20th Percentile",
      "definition" : "The 20th [Percentile](https://en.wikipedia.org/wiki/Percentile) of N measurements over the stated period."
    },
    {
      "code" : "80-percent",
      "display" : "80th Percentile",
      "definition" : "The 80th [Percentile](https://en.wikipedia.org/wiki/Percentile) of N measurements over the stated period."
    },
    {
      "code" : "4-lower",
      "display" : "Lower Quartile",
      "definition" : "The lower [Quartile](https://en.wikipedia.org/wiki/Quartile) Boundary of N measurements over the stated period."
    },
    {
      "code" : "4-upper",
      "display" : "Upper Quartile",
      "definition" : "The upper [Quartile](https://en.wikipedia.org/wiki/Quartile) Boundary of N measurements over the stated period."
    },
    {
      "code" : "4-dev",
      "display" : "Quartile Deviation",
      "definition" : "The difference between the upper and lower [Quartiles](https://en.wikipedia.org/wiki/Quartile) is called the Interquartile range. (IQR = Q3-Q1) Quartile deviation or Semi-interquartile range is one-half the difference between the first and the third quartiles."
    },
    {
      "code" : "5-1",
      "display" : "1st Quintile",
      "definition" : "The lowest of four values that divide the N measurements into a frequency distribution of five classes with each containing one fifth of the total population."
    },
    {
      "code" : "5-2",
      "display" : "2nd Quintile",
      "definition" : "The second of four values that divide the N measurements into a frequency distribution of five classes with each containing one fifth of the total population."
    },
    {
      "code" : "5-3",
      "display" : "3rd Quintile",
      "definition" : "The third of four values that divide the N measurements into a frequency distribution of five classes with each containing one fifth of the total population."
    },
    {
      "code" : "5-4",
      "display" : "4th Quintile",
      "definition" : "The fourth of four values that divide the N measurements into a frequency distribution of five classes with each containing one fifth of the total population."
    },
    {
      "code" : "skew",
      "display" : "Skew",
      "definition" : "Skewness is a measure of the asymmetry of the probability distribution of a real-valued random variable about its mean. The skewness value can be positive or negative, or even undefined.  Source: [Wikipedia](https://en.wikipedia.org/wiki/Skewness)."
    },
    {
      "code" : "kurtosis",
      "display" : "Kurtosis",
      "definition" : "Kurtosis  is a measure of the \"tailedness\" of the probability distribution of a real-valued random variable.   Source: [Wikipedia](https://en.wikipedia.org/wiki/Kurtosis)."
    },
    {
      "code" : "regression",
      "display" : "Regression",
      "definition" : "Linear regression is an approach for modeling two-dimensional sample points with one independent variable and one dependent variable (conventionally, the x and y coordinates in a Cartesian coordinate system) and finds a linear function (a non-vertical straight line) that, as accurately as possible, predicts the dependent variable values as a function of the independent variables. Source: [Wikipedia](https://en.wikipedia.org/wiki/Simple_linear_regression)  This Statistic code will return both a gradient and an intercept value."
    }
  ]
}

```
