# Nutrition intake category codes - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Nutrition intake category codes**

## CodeSystem: Nutrition intake category codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/nutrition-intake-category | *Version*:1.0.0 | |
| Draft as of 2026-01-26 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:NutritionIntakeWCategoryCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1431 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
NutritionIntake Category Codes 

 This Code system is referenced in the content logical definition of the following value sets: 

* [NutritionIntakeCategoryCodes](ValueSet-nutrition-intake-category.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "nutrition-intake-category",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/nutrition-intake-category",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1431"
    }
  ],
  "version" : "1.0.0",
  "name" : "NutritionIntakeWCategoryCodes",
  "title" : "Nutrition intake category codes",
  "status" : "draft",
  "experimental" : false,
  "date" : "2026-01-26T07:21:33+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "NutritionIntake Category Codes",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/nutrition-intake-category",
  "content" : "complete",
  "concept" : [
    {
      "code" : "inpatient",
      "display" : "Inpatient",
      "definition" : "Includes orders for nutrition to be administered or consumed in an inpatient or acute care setting"
    },
    {
      "code" : "outpatient",
      "display" : "Outpatient",
      "definition" : "Includes orders for nutrition to be administered or consumed in an outpatient setting (for example, Emergency Department, Outpatient Clinic, Outpatient Surgery, Doctor's office)"
    },
    {
      "code" : "community",
      "display" : "Community",
      "definition" : "Includes orders for nutrition to be administered or consumed by the patient in their home (this would include long term care or nursing homes, hospices, etc.)."
    },
    {
      "code" : "patientspecified",
      "display" : "Patient Specified",
      "definition" : "Includes statements about nutrition use, including over the counter medication, provided by the patient, agent or another provider"
    }
  ]
}

```
