# Modifier type Codes - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Modifier type Codes**

## CodeSystem: Modifier type Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/modifiers | *Version*:1.0.1 | | |
| Active as of 2026-01-26 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ModifierTypeCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1151 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This value set includes sample Modifier type codes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ModifierTypeCodes](ValueSet-claim-modifiers.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "modifiers",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/modifiers",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1151"
    }
  ],
  "version" : "1.0.1",
  "name" : "ModifierTypeCodes",
  "title" : "Modifier type Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-01-26T07:21:33+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set includes sample Modifier type codes.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/claim-modifiers",
  "content" : "complete",
  "concept" : [
    {
      "code" : "a",
      "display" : "Repair of prior service or installation",
      "definition" : "Repair of prior service or installation."
    },
    {
      "code" : "b",
      "display" : "Temporary service or installation",
      "definition" : "Temporary service or installation."
    },
    {
      "code" : "c",
      "display" : "TMJ treatment",
      "definition" : "Treatment associated with TMJ."
    },
    {
      "code" : "e",
      "display" : "Implant or associated with an implant",
      "definition" : "Implant or associated with an implant."
    },
    {
      "code" : "rooh",
      "display" : "Rush or Outside of office hours",
      "definition" : "A Rush service or service performed outside of normal office hours."
    },
    {
      "code" : "x",
      "display" : "None",
      "definition" : "None."
    }
  ]
}

```
