# Example Message Reason Codes - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Example Message Reason Codes**

## CodeSystem: Example Message Reason Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/message-reasons-encounter | *Version*:1.0.1 | | |
| Active as of 2026-01-26 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ExampleMessageReasonCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1122 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
Example Message Reasons. These are the set of codes that might be used an updating an encounter using admin-update. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ExampleMessageReasonCodes](ValueSet-message-reason-encounter.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "message-reasons-encounter",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "inm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/message-reasons-encounter",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1122"
    }
  ],
  "version" : "1.0.1",
  "name" : "ExampleMessageReasonCodes",
  "title" : "Example Message Reason Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-01-26T07:21:33+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Example Message Reasons. These are the set of codes that might be used an updating an encounter using admin-update.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/message-reason-encounter",
  "content" : "complete",
  "concept" : [
    {
      "code" : "admit",
      "display" : "Admit",
      "definition" : "The patient has been admitted."
    },
    {
      "code" : "discharge",
      "display" : "Discharge",
      "definition" : "The patient has been discharged."
    },
    {
      "code" : "absent",
      "display" : "Absent",
      "definition" : "The patient has temporarily left the institution."
    },
    {
      "code" : "return",
      "display" : "Returned",
      "definition" : "The patient has returned from a temporary absence."
    },
    {
      "code" : "moved",
      "display" : "Moved",
      "definition" : "The patient has been moved to a new location."
    },
    {
      "code" : "edit",
      "display" : "Edit",
      "definition" : "Encounter details have been updated (e.g. to correct a coding error)."
    }
  ]
}

```
