# MedicationRequest Category Codes - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicationRequest Category Codes**

## CodeSystem: MedicationRequest Category Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/medicationrequest-category | *Version*:1.0.0 | | |
| Draft as of 2026-01-26 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:MedicationRequestCategoryCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1323 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
MedicationRequest Category Codes 

 This Code system is referenced in the content logical definition of the following value sets: 

* [MedicationRequestCategoryCodes](ValueSet-medicationrequest-category.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "medicationrequest-category",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/medicationrequest-category",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1323"
    }
  ],
  "version" : "1.0.0",
  "name" : "MedicationRequestCategoryCodes",
  "title" : "MedicationRequest Category Codes",
  "status" : "draft",
  "experimental" : false,
  "date" : "2026-01-26T07:21:33+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "MedicationRequest Category Codes",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/medicationrequest-category",
  "content" : "complete",
  "concept" : [
    {
      "code" : "inpatient",
      "display" : "Inpatient",
      "definition" : "Includes requests for medications to be administered or consumed in an inpatient or acute care setting"
    },
    {
      "code" : "outpatient",
      "display" : "Outpatient",
      "definition" : "Includes requests for medications to be administered or consumed in an outpatient setting (for example, Emergency Department, Outpatient Clinic, Outpatient Surgery, Doctor's office)"
    },
    {
      "code" : "community",
      "display" : "Community",
      "definition" : "Includes requests for medications to be administered or consumed by the patient in their home (this would include long term care or nursing homes, hospices, etc.)"
    },
    {
      "code" : "discharge",
      "display" : "Discharge",
      "definition" : "Includes requests for medications created when the patient is being released from a facility"
    }
  ]
}

```
