# Measure Population Type - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Measure Population Type**

## CodeSystem: Measure Population Type 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/measure-population | *Version*:2.0.0 | | |
| Active as of 2020-04-09 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 4 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:MeasurePopulationType |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1231 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
The type of population. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [MeasurePopulationType](ValueSet-measure-population.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "measure-population",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/measure-population",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1231"
    }
  ],
  "version" : "2.0.0",
  "name" : "MeasurePopulationType",
  "title" : "Measure Population Type",
  "status" : "active",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The type of population.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/measure-population",
  "content" : "complete",
  "concept" : [
    {
      "code" : "initial-population",
      "display" : "Initial Population",
      "definition" : "The initial population criteria refers to all patients, subjects, or events to be evaluated by a quality measure involving patients or subjects who share a common set of specified characterstics. All patients, subjects, or events counted (for example, as numerator, as denominator) are drawn from the initial population."
    },
    {
      "code" : "numerator",
      "display" : "Numerator",
      "definition" : "The numerator inclusion statement describes the process, condition, event, or outcome that satisfies the measure’s focus or intent. The numerator inclusion statement includes parameters such as: \r\n\r\n * the Event or events that will satisfy the numerator inclusion criteria \r\n * the Performance period or time interval in which the numerator event must occur, if it is different from that used for identifying the denominator. \r\n\r\n Note that this code is used to identify the starting inclusion criteria for the numerator. The final calculated numerator must be determined by considering all relevant criteria for the scoring type, including numerator inclusion and exclusion criteria. \r\n\r\n Source: https://mmshub.cms.gov/measure-lifecycle/measure-specification/develop-specification/numerator"
    },
    {
      "code" : "numerator-exclusion",
      "display" : "Numerator Exclusion",
      "definition" : "Numerator exclusion criteria define patients, subjects, or events to be excluded from the numerator. Numerator exclusions are used in proportion and ratio measures to help narrow the numerator (for inverted measures)."
    },
    {
      "code" : "denominator",
      "display" : "Denominator",
      "definition" : "Denominator inclusion criteria define the patients, subjects, or events that should be included in the lower portion of a fraction used to calculate a rate, proportion, or ratio. \r\n\r\n Note that this code is used to identify the starting inclusion criteria for the denominator. The final calculated denominator must be determined by considering all relevant criteria for the scoring type, including denominator inclusion, exclusion, and exception criteria. The final calculated denominator can be the same as the initial population, or a subset of the initial population to further constrain the population for the purpose of the measure."
    },
    {
      "code" : "denominator-exclusion",
      "display" : "Denominator Exclusion",
      "definition" : "Denominator exclusion criteria define patients, subjects, or events that should be excluded from the denominator. Denominator exclusions are used in proportion and ratio measures to help narrow the denominator. For example, patients with bilateral lower extremity amputations would be listed as a denominator exclusion for a measure requiring foot exams."
    },
    {
      "code" : "denominator-exception",
      "display" : "Denominator Exception",
      "definition" : "Denominator exceptions are conditions that should remove a patient, subject, or event from the denominator of a measure only if the numerator criteria are not met. Denominator exception allows for adjustment of the calculated score for those providers with higher risk populations. Denominator exception criteria are only used in proportion measures."
    },
    {
      "code" : "measure-population",
      "display" : "Measure Population",
      "definition" : "Measure population inclusion criteria define the patients, subjects, or events for which the measure observation should be taken. Measure populations are used for continuous variable measures rather than numerator and denominator criteria. \r\n\r\n Note that this code is used to identify the starting inclusion criteria for the measure population. The final calculated measure population must be determined by considering all relevant criteria for the scoring type, including measure population inclusion and exclusion criteria."
    },
    {
      "code" : "measure-population-exclusion",
      "display" : "Measure Population Exclusion",
      "definition" : "Measure population exclusion criteria define the patients or events that should be excluded from the measure population before determining the outcome of one or more continuous variables defined for the measure observation. Measure population exclusion criteria are used within continuous variable measures to help narrow the measure population."
    },
    {
      "code" : "measure-observation",
      "display" : "Measure Observation",
      "definition" : "Measure observation criteria are used to define an individual observation to be performed for each patient, subject, or event in the measure population. Measure observations for each case in the population are aggregated to determine the overall measure score for the population."
    }
  ]
}

```
