# Insurance Coverage Type - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Insurance Coverage Type**

## CodeSystem: Insurance Coverage Type 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/insurance-coverage-type | *Version*:1.0.0 | | |
| Active as of 2026-01-26 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:InsuranceCoverageType |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This code system defines a set of codes for Insurance CoverageType. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [InsuranceCoverageType](ValueSet-insurance-coverage-type.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "insurance-coverage-type",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/insurance-coverage-type",
  "version" : "1.0.0",
  "name" : "InsuranceCoverageType",
  "title" : "Insurance Coverage Type",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-01-26T07:21:33+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This code system defines a set of codes for Insurance CoverageType.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/insurance-coverage-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "medical",
      "display" : "Medical",
      "definition" : "Medical insurance coverage."
    },
    {
      "code" : "dental",
      "display" : "Dental",
      "definition" : "Dental insurance coverage."
    },
    {
      "code" : "menthlth",
      "display" : "Mental Health",
      "definition" : "Mental health insurance coverage."
    },
    {
      "code" : "substanceabuse",
      "display" : "Substance Abuse",
      "definition" : "Substance abuse services insurance coverage."
    },
    {
      "code" : "vision",
      "display" : "Vision",
      "definition" : "Vision insurance coverage."
    },
    {
      "code" : "drug",
      "display" : "Drug",
      "definition" : "Prescription drug coverage."
    },
    {
      "code" : "stc",
      "display" : "Short Term Care",
      "definition" : "Short term care."
    },
    {
      "code" : "ltc",
      "display" : "Long Term Care",
      "definition" : "Long term care."
    },
    {
      "code" : "hospice",
      "display" : "Hospice",
      "definition" : "Hospice insurance coverage."
    },
    {
      "code" : "homehealth",
      "display" : "Home Health",
      "definition" : "Home health services insurance coverage."
    },
    {
      "code" : "dmepos",
      "display" : "DMEPOS",
      "definition" : "Durable Medical Equipment, Prosthetics/Orthotics and Supplies."
    },
    {
      "code" : "imagingadv",
      "display" : "Advanced Imaging (CT/PET Scans, MRIs)",
      "definition" : "Advances imaging techniques services (CT/PET Scans, MRIs) coverage."
    },
    {
      "code" : "prev",
      "display" : "Preventive Care/Screening/Immunization",
      "definition" : "Routine healthcare services to prevent health related problems eligible benefits."
    },
    {
      "code" : "rehab",
      "display" : "Rehabilitation",
      "definition" : "Rehabilitation."
    }
  ]
}

```
