# Immunization Evaluation Dose Status codes - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Immunization Evaluation Dose Status codes**

## CodeSystem: Immunization Evaluation Dose Status codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/immunization-evaluation-dose-status | *Version*:1.0.1 | | |
| Active as of 2026-01-26 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ImmunizationEvaluationDoseStatusCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1102 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
The value set to instantiate this attribute should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the validity of a dose relative to a particular recommended schedule. This value set is provided as a suggestive example. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ImmunizationEvaluationDoseStatusCodes](ValueSet-immunization-evaluation-dose-status.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "immunization-evaluation-dose-status",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pher"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/immunization-evaluation-dose-status",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1102"
    }
  ],
  "version" : "1.0.1",
  "name" : "ImmunizationEvaluationDoseStatusCodes",
  "title" : "Immunization Evaluation Dose Status codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-01-26T07:21:33+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The value set to instantiate this attribute should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the validity of a dose relative to a particular recommended schedule. This value set is provided as a suggestive example.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/immunization-evaluation-dose-status",
  "content" : "complete",
  "concept" : [
    {
      "code" : "valid",
      "display" : "Valid",
      "definition" : "The dose counts toward fulfilling a path to immunity for a patient, providing protection against the target disease."
    },
    {
      "code" : "notvalid",
      "display" : "Not valid",
      "definition" : "The dose does not count toward fulfilling a path to immunity for a patient."
    }
  ]
}

```
