# Immunization Evaluation Dose Status Reason codes - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Immunization Evaluation Dose Status Reason codes**

## CodeSystem: Immunization Evaluation Dose Status Reason codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/immunization-evaluation-dose-status-reason | *Version*:1.0.1 | | |
| Active as of 2026-01-26 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ImmunizationEvaluationDoseStatusReasonCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1103 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
The value set to instantiate this attribute should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the reason why an administered dose has been assigned a particular status. Often, this reason describes why a dose is considered invalid. This value set is provided as a suggestive example. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ImmunizationEvaluationDoseStatusReasonCodes](ValueSet-immunization-evaluation-dose-status-reason.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "immunization-evaluation-dose-status-reason",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pher"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/immunization-evaluation-dose-status-reason",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1103"
    }
  ],
  "version" : "1.0.1",
  "name" : "ImmunizationEvaluationDoseStatusReasonCodes",
  "title" : "Immunization Evaluation Dose Status Reason codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-01-26T07:21:33+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The value set to instantiate this attribute should be drawn from a terminologically robust code system that consists of or contains concepts to support describing the reason why an administered dose has been assigned a particular status. Often, this reason describes why a dose is considered invalid. This value set is provided as a suggestive example.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/immunization-evaluation-dose-status-reason",
  "content" : "complete",
  "concept" : [
    {
      "code" : "partialdose",
      "display" : "Partial Dose",
      "definition" : "The full volume of the dose was not administered to the patient."
    },
    {
      "code" : "coldchainbreak",
      "display" : "Cold Chain Break",
      "definition" : "The vaccine experienced a cold chain break."
    },
    {
      "code" : "recall",
      "display" : "Manufacturer Recall",
      "definition" : "The vaccine was recalled by the manufacturer."
    },
    {
      "code" : "adversestorage",
      "display" : "Adverse Storage",
      "definition" : "The vaccine experienced adverse storage conditions."
    },
    {
      "code" : "expired",
      "display" : "Expired Product",
      "definition" : "The vaccine was expired at the time of administration."
    },
    {
      "code" : "outsideschedule",
      "display" : "Outside Schedule",
      "definition" : "The vaccine was administered in a manner that is inconsistent with the evaluated schedule."
    }
  ]
}

```
