# GoalAcceptanceStatus - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **GoalAcceptanceStatus**

## CodeSystem: GoalAcceptanceStatus 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/goal-acceptance-status | *Version*:1.0.0 | |
| Draft as of 2020-04-09 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:GoalAcceptanceStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1270 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Codes indicating whether the goal has been accepted by a stakeholder. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [GoalAcceptanceStatus](ValueSet-goal-acceptance-status.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "goal-acceptance-status",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/goal-acceptance-status",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1270"
    }
  ],
  "version" : "1.0.0",
  "name" : "GoalAcceptanceStatus",
  "title" : "GoalAcceptanceStatus",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Codes indicating whether the goal has been accepted by a stakeholder.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/goal-acceptance-status",
  "content" : "complete",
  "concept" : [
    {
      "code" : "agree",
      "display" : "Agree",
      "definition" : "Stakeholder supports pursuit of the goal."
    },
    {
      "code" : "disagree",
      "display" : "Disagree",
      "definition" : "Stakeholder is not in support of the pursuit of the goal."
    },
    {
      "code" : "pending",
      "display" : "Pending",
      "definition" : "Stakeholder has not yet made a decision on whether they support the goal."
    }
  ]
}

```
