# Failure-action - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Failure-action**

## CodeSystem: Failure-action 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/failure-action | *Version*:1.0.1 | |
| Active as of 2024-04-24 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:Failure_action |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.891 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | |

 
The result if validation fails 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Failure_action](ValueSet-verificationresult-failure-action.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "failure-action",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/failure-action",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.891"
    }
  ],
  "version" : "1.0.1",
  "name" : "Failure_action",
  "title" : "Failure-action",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-24T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The result if validation fails",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/verificationresult-failure-action",
  "content" : "complete",
  "concept" : [
    {
      "code" : "fatal",
      "display" : "Fatal"
    },
    {
      "code" : "warn",
      "display" : "Warning"
    },
    {
      "code" : "rec-only",
      "display" : "Record only"
    },
    {
      "code" : "none",
      "display" : "None"
    }
  ]
}

```
