# Example Payment Type Codes - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Example Payment Type Codes**

## CodeSystem: Example Payment Type Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/ex-paymenttype | *Version*:1.0.1 | | |
| Active as of 2026-01-26 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ExamplePaymentTypeCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1181 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This value set includes example Payment Type codes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ExamplePaymentTypeCodes](ValueSet-ex-paymenttype.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "ex-paymenttype",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/ex-paymenttype",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1181"
    }
  ],
  "version" : "1.0.1",
  "name" : "ExamplePaymentTypeCodes",
  "title" : "Example Payment Type Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-01-26T07:21:33+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set includes example Payment Type codes.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/ex-paymenttype",
  "content" : "complete",
  "concept" : [
    {
      "code" : "complete",
      "display" : "Complete",
      "definition" : "Complete (final) payment of the benefit under the Claim less any adjustments."
    },
    {
      "code" : "partial",
      "display" : "Partial",
      "definition" : "Partial payment of the benefit under the Claim less any adjustments."
    }
  ]
}

```
