# Example Diagnosis Type Codes - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Example Diagnosis Type Codes**

## CodeSystem: Example Diagnosis Type Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/ex-diagnosistype | *Version*:1.0.1 | | |
| Active as of 2026-01-26 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ExampleDiagnosisTypeCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1167 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This value set includes example Diagnosis Type codes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ExampleDiagnosisTypeCodes](ValueSet-ex-diagnosistype.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "ex-diagnosistype",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/ex-diagnosistype",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1167"
    }
  ],
  "version" : "1.0.1",
  "name" : "ExampleDiagnosisTypeCodes",
  "title" : "Example Diagnosis Type Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-01-26T07:21:33+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set includes example Diagnosis Type codes.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/ex-diagnosistype",
  "content" : "complete",
  "concept" : [
    {
      "code" : "admitting",
      "display" : "Admitting Diagnosis",
      "definition" : "The diagnosis given as the reason why the patient was admitted to the hospital."
    },
    {
      "code" : "clinical",
      "display" : "Clinical Diagnosis",
      "definition" : "A diagnosis made on the basis of medical signs and patient-reported symptoms, rather than diagnostic tests."
    },
    {
      "code" : "differential",
      "display" : "Differential Diagnosis",
      "definition" : "One of a set of the possible diagnoses that could be connected to the signs, symptoms, and lab findings."
    },
    {
      "code" : "discharge",
      "display" : "Discharge Diagnosis",
      "definition" : "The diagnosis given when the patient is discharged from the hospital."
    },
    {
      "code" : "laboratory",
      "display" : "Laboratory Diagnosis",
      "definition" : "A diagnosis based significantly on laboratory reports or test results, rather than the physical examination of the patient."
    },
    {
      "code" : "nursing",
      "display" : "Nursing Diagnosis",
      "definition" : "A diagnosis which identifies people's responses to situations in their lives, such as a readiness to change or a willingness to accept assistance."
    },
    {
      "code" : "prenatal",
      "display" : "Prenatal Diagnosis",
      "definition" : "A diagnosis determined prior to birth."
    },
    {
      "code" : "principal",
      "display" : "Principal Diagnosis",
      "definition" : "The single medical diagnosis that is most relevant to the patient's chief complaint or need for treatment."
    },
    {
      "code" : "radiology",
      "display" : "Radiology Diagnosis",
      "definition" : "A diagnosis based primarily on the results from medical imaging studies."
    },
    {
      "code" : "remote",
      "display" : "Remote Diagnosis",
      "definition" : "A diagnosis determined using telemedicine techniques."
    },
    {
      "code" : "retrospective",
      "display" : "Retrospective Diagnosis",
      "definition" : "The labeling of an illness in a specific historical event using modern knowledge, methods and disease classifications."
    },
    {
      "code" : "self",
      "display" : "Self Diagnosis",
      "definition" : "A diagnosis determined by the patient."
    }
  ]
}

```
