# Episode of care type - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Episode of care type**

## CodeSystem: Episode of care type 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/episodeofcare-type | *Version*:1.0.1 | | |
| Active as of 2026-01-26 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:EpisodeOfCareType |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1189 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This example value set defines a set of codes that can be used to express the usage type of an EpisodeOfCare record. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [EpisodeOfCareType](ValueSet-episodeofcare-type.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "episodeofcare-type",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/episodeofcare-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1189"
    }
  ],
  "version" : "1.0.1",
  "name" : "EpisodeOfCareType",
  "title" : "Episode of care type",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-01-26T07:21:33+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This example value set defines a set of codes that can be used to express the usage type of an EpisodeOfCare record.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/episodeofcare-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "hacc",
      "display" : "Home and Community Care"
    },
    {
      "code" : "pac",
      "display" : "Post Acute Care"
    },
    {
      "code" : "diab",
      "display" : "Post coordinated diabetes program"
    },
    {
      "code" : "da",
      "display" : "Drug and alcohol rehabilitation"
    },
    {
      "code" : "cacp",
      "display" : "Community-based aged care"
    }
  ]
}

```
