# CRD Coverage Detail Codes - HL7 Terminology (THO) v7.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CRD Coverage Detail Codes**

## CodeSystem: CRD Coverage Detail Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/crd-coverage-detail | *Version*:1.0.0 | | |
| Active as of 2025-10-16 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:CRDCoverageDetail |
| *Other Identifiers:*OID:2.16.840.1.113883.5.177 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
Codes that describe additional details related to a coverage information assertion. These live in THO rather than the CRD specification to support adding additional concepts without putting out a new CRD release. 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "crd-coverage-detail",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/crd-coverage-detail",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.177"
    }
  ],
  "version" : "1.0.0",
  "name" : "CRDCoverageDetail",
  "title" : "CRD Coverage Detail Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-16T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Codes that describe additional details related to a coverage information assertion.  These live in THO rather than the CRD specification to support adding additional concepts without putting out a new CRD release.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "abstract",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "type" : "boolean"
    }
  ],
  "concept" : [
    {
      "code" : "_limitation",
      "display" : "Limitation details",
      "definition" : "Identifies detail codes that define limitations of coverage.  (Category should be 'cat-limitation')",
      "property" : [
        {
          "code" : "abstract",
          "valueBoolean" : true
        }
      ],
      "concept" : [
        {
          "code" : "allowed-quantity",
          "display" : "Maximum quantity",
          "definition" : "Indicates limitations on the number of services/products allowed (possibly per time period).  Value should be a Quantity"
        },
        {
          "code" : "allowed-period",
          "display" : "Maximum allowed period",
          "definition" : "Indicates the maximum period of time that can be covered in a single order.  Value should be a Period"
        }
      ]
    },
    {
      "code" : "_decisional",
      "display" : "Decisional details",
      "definition" : "Identifies detail codes that may impact patient and clinician decision making  (Category should be 'cat-decisional')",
      "property" : [
        {
          "code" : "abstract",
          "valueBoolean" : true
        }
      ],
      "concept" : [
        {
          "code" : "in-network-copay",
          "display" : "Copay for in-network",
          "definition" : "Indicates a percentage co-pay to expect if delivered in-network.  Value should be a Quantity."
        },
        {
          "code" : "out-network-copay",
          "display" : "Copay for out-of-network",
          "definition" : "Indicates a percentage co-pay to expect if delivered out-of-network.  Value should be a Quantity."
        },
        {
          "code" : "concurrent-review",
          "display" : "Concurrent review",
          "definition" : "Additional payer-defined documentation will be required prior to claim payment.  Value should be a boolean."
        },
        {
          "code" : "appropriate-use-needed",
          "display" : "Appropriate use",
          "definition" : "Payer-defined appropriate use process must be invoked to determine coverage.  Value should be a boolean."
        }
      ]
    },
    {
      "code" : "_other",
      "display" : "Other details",
      "definition" : "Identifies detail codes that are generally not relevant to clinicians/patients  (Category should be 'cat-other')",
      "property" : [
        {
          "code" : "abstract",
          "valueBoolean" : true
        }
      ],
      "concept" : [
        {
          "code" : "policy-link",
          "display" : "Policy Link",
          "definition" : "A URL pointing to the specific portion of a payer policy, coverage agreement or similar authoritative document that provides a portion of the basis for the decision documented in the coverage-information.  Value should be a url."
        }
      ]
    },
    {
      "code" : "instructions",
      "display" : "Instructions",
      "definition" : "Information to display to the user that gives guidance about what steps to take in achieving the recommended actions identified by this coverage-information (e.g. special instructions about requesting authorization, details about information needed, details about data retention, etc.).  Value should be a string.  (Category may vary.)"
    }
  ]
}

```
